/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Metric;
import com.codahale.metrics.RatioGauge;
import com.codahale.metrics.Timer;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.LatencyMetrics;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.apache.cassandra.utils.EstimatedHistogram;
import org.apache.cassandra.utils.TopKSampler;

public class ColumnFamilyMetrics {
    public final Gauge<Long> memtableOnHeapSize;
    public final Gauge<Long> memtableOffHeapSize;
    public final Gauge<Long> memtableLiveDataSize;
    public final Gauge<Long> allMemtablesOnHeapSize;
    public final Gauge<Long> allMemtablesOffHeapSize;
    public final Gauge<Long> allMemtablesLiveDataSize;
    public final Gauge<Long> memtableColumnsCount;
    public final Counter memtableSwitchCount;
    public final Gauge<Double> compressionRatio;
    public final Gauge<long[]> estimatedRowSizeHistogram;
    public final Gauge<long[]> estimatedColumnCountHistogram;
    public final ColumnFamilyHistogram sstablesPerReadHistogram;
    public final LatencyMetrics readLatency;
    public final LatencyMetrics rangeLatency;
    public final LatencyMetrics writeLatency;
    public final Counter pendingFlushes;
    public final Gauge<Integer> pendingCompactions;
    public final Gauge<Integer> liveSSTableCount;
    public final Counter liveDiskSpaceUsed;
    public final Counter totalDiskSpaceUsed;
    public final Gauge<Long> minRowSize;
    public final Gauge<Long> maxRowSize;
    public final Gauge<Long> meanRowSize;
    public final Gauge<Long> bloomFilterFalsePositives;
    public final Gauge<Long> recentBloomFilterFalsePositives;
    public final Gauge<Double> bloomFilterFalseRatio;
    public final Gauge<Double> recentBloomFilterFalseRatio;
    public final Gauge<Long> bloomFilterDiskSpaceUsed;
    public final Gauge<Long> bloomFilterOffHeapMemoryUsed;
    public final Gauge<Long> indexSummaryOffHeapMemoryUsed;
    public final Gauge<Long> compressionMetadataOffHeapMemoryUsed;
    public final Gauge<Double> keyCacheHitRate;
    public final ColumnFamilyHistogram tombstoneScannedHistogram;
    public final ColumnFamilyHistogram liveScannedHistogram;
    public final ColumnFamilyHistogram colUpdateTimeDeltaHistogram;
    public final Gauge<Long> trueSnapshotsSize;
    public final Counter rowCacheHitOutOfRange;
    public final Counter rowCacheHit;
    public final Counter rowCacheMiss;
    public final LatencyMetrics casPrepare;
    public final LatencyMetrics casPropose;
    public final LatencyMetrics casCommit;
    public final Timer coordinatorReadLatency;
    public final Timer coordinatorScanLatency;
    public final Histogram waitingOnFreeMemtableSpace;
    private final MetricNameFactory factory;
    private static final MetricNameFactory globalNameFactory = new AllColumnFamilyMetricNameFactory();
    public final Counter speculativeRetries;
    public static final LatencyMetrics globalReadLatency = new LatencyMetrics(globalNameFactory, "Read");
    public static final LatencyMetrics globalWriteLatency = new LatencyMetrics(globalNameFactory, "Write");
    public static final LatencyMetrics globalRangeLatency = new LatencyMetrics(globalNameFactory, "Range");
    public final Map<Sampler, TopKSampler<ByteBuffer>> samplers;
    public static final ConcurrentMap<String, Set<Metric>> allColumnFamilyMetrics = Maps.newConcurrentMap();
    public static final Set<String> all = Sets.newHashSet();

    private static long[] combineHistograms(Iterable<SSTableReader> sstables, GetHistogram getHistogram) {
        Iterator<SSTableReader> iterator = sstables.iterator();
        if (!iterator.hasNext()) {
            return new long[0];
        }
        long[] firstBucket = getHistogram.getHistogram(iterator.next()).getBuckets(false);
        long[] values = new long[firstBucket.length];
        System.arraycopy(firstBucket, 0, values, 0, values.length);
        while (iterator.hasNext()) {
            long[] nextBucket = getHistogram.getHistogram(iterator.next()).getBuckets(false);
            if (nextBucket.length > values.length) {
                long[] newValues = new long[nextBucket.length];
                System.arraycopy(firstBucket, 0, newValues, 0, firstBucket.length);
                for (int i = 0; i < newValues.length; ++i) {
                    int n = i;
                    newValues[n] = newValues[n] + nextBucket[i];
                }
                values = newValues;
                continue;
            }
            for (int i = 0; i < values.length; ++i) {
                int n = i;
                values[n] = values[n] + nextBucket[i];
            }
        }
        return values;
    }

    public ColumnFamilyMetrics(final ColumnFamilyStore cfs) {
        this.factory = new ColumnFamilyMetricNameFactory(cfs);
        this.samplers = Maps.newHashMap();
        for (Sampler sampler : Sampler.values()) {
            this.samplers.put(sampler, new TopKSampler());
        }
        this.memtableColumnsCount = this.createColumnFamilyGauge("MemtableColumnsCount", new Gauge<Long>(){

            public Long getValue() {
                return cfs.getDataTracker().getView().getCurrentMemtable().getOperations();
            }
        });
        this.memtableOnHeapSize = this.createColumnFamilyGauge("MemtableOnHeapSize", new Gauge<Long>(){

            public Long getValue() {
                return cfs.getDataTracker().getView().getCurrentMemtable().getAllocator().onHeap().owns();
            }
        });
        this.memtableOffHeapSize = this.createColumnFamilyGauge("MemtableOffHeapSize", new Gauge<Long>(){

            public Long getValue() {
                return cfs.getDataTracker().getView().getCurrentMemtable().getAllocator().offHeap().owns();
            }
        });
        this.memtableLiveDataSize = this.createColumnFamilyGauge("MemtableLiveDataSize", new Gauge<Long>(){

            public Long getValue() {
                return cfs.getDataTracker().getView().getCurrentMemtable().getLiveDataSize();
            }
        });
        this.allMemtablesOnHeapSize = this.createColumnFamilyGauge("AllMemtablesHeapSize", new Gauge<Long>(){

            public Long getValue() {
                long size = 0L;
                for (ColumnFamilyStore cfs2 : cfs.concatWithIndexes()) {
                    size += cfs2.getDataTracker().getView().getCurrentMemtable().getAllocator().onHeap().owns();
                }
                return size;
            }
        });
        this.allMemtablesOffHeapSize = this.createColumnFamilyGauge("AllMemtablesOffHeapSize", new Gauge<Long>(){

            public Long getValue() {
                long size = 0L;
                for (ColumnFamilyStore cfs2 : cfs.concatWithIndexes()) {
                    size += cfs2.getDataTracker().getView().getCurrentMemtable().getAllocator().offHeap().owns();
                }
                return size;
            }
        });
        this.allMemtablesLiveDataSize = this.createColumnFamilyGauge("AllMemtablesLiveDataSize", new Gauge<Long>(){

            public Long getValue() {
                long size = 0L;
                for (ColumnFamilyStore cfs2 : cfs.concatWithIndexes()) {
                    size += cfs2.getDataTracker().getView().getCurrentMemtable().getLiveDataSize();
                }
                return size;
            }
        });
        this.memtableSwitchCount = this.createColumnFamilyCounter("MemtableSwitchCount");
        this.estimatedRowSizeHistogram = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("EstimatedRowSizeHistogram"), new Gauge<long[]>(){

            public long[] getValue() {
                return ColumnFamilyMetrics.combineHistograms(cfs.getSSTables(), new GetHistogram(){

                    @Override
                    public EstimatedHistogram getHistogram(SSTableReader reader) {
                        return reader.getEstimatedRowSize();
                    }
                });
            }
        });
        this.estimatedColumnCountHistogram = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("EstimatedColumnCountHistogram"), new Gauge<long[]>(){

            public long[] getValue() {
                return ColumnFamilyMetrics.combineHistograms(cfs.getSSTables(), new GetHistogram(){

                    @Override
                    public EstimatedHistogram getHistogram(SSTableReader reader) {
                        return reader.getEstimatedColumnCount();
                    }
                });
            }
        });
        this.sstablesPerReadHistogram = this.createColumnFamilyHistogram("SSTablesPerReadHistogram", cfs.keyspace.metric.sstablesPerReadHistogram);
        this.compressionRatio = this.createColumnFamilyGauge("CompressionRatio", new Gauge<Double>(){

            public Double getValue() {
                double sum = 0.0;
                int total = 0;
                for (SSTableReader sstable : cfs.getSSTables()) {
                    if (sstable.getCompressionRatio() == -1.0) continue;
                    sum += sstable.getCompressionRatio();
                    ++total;
                }
                return total != 0 ? sum / (double)total : 0.0;
            }
        }, new Gauge<Double>(){

            public Double getValue() {
                double sum = 0.0;
                int total = 0;
                for (Keyspace keyspace : Keyspace.all()) {
                    for (SSTableReader sstable : keyspace.getAllSSTables()) {
                        if (sstable.getCompressionRatio() == -1.0) continue;
                        sum += sstable.getCompressionRatio();
                        ++total;
                    }
                }
                return total != 0 ? sum / (double)total : 0.0;
            }
        });
        this.readLatency = new LatencyMetrics(this.factory, "Read", cfs.keyspace.metric.readLatency, globalReadLatency);
        this.writeLatency = new LatencyMetrics(this.factory, "Write", cfs.keyspace.metric.writeLatency, globalWriteLatency);
        this.rangeLatency = new LatencyMetrics(this.factory, "Range", cfs.keyspace.metric.rangeLatency, globalRangeLatency);
        this.pendingFlushes = this.createColumnFamilyCounter("PendingFlushes");
        this.pendingCompactions = this.createColumnFamilyGauge("PendingCompactions", new Gauge<Integer>(){

            public Integer getValue() {
                return cfs.getCompactionStrategy().getEstimatedRemainingTasks();
            }
        });
        this.liveSSTableCount = this.createColumnFamilyGauge("LiveSSTableCount", new Gauge<Integer>(){

            public Integer getValue() {
                return cfs.getDataTracker().getSSTables().size();
            }
        });
        this.liveDiskSpaceUsed = this.createColumnFamilyCounter("LiveDiskSpaceUsed");
        this.totalDiskSpaceUsed = this.createColumnFamilyCounter("TotalDiskSpaceUsed");
        this.minRowSize = this.createColumnFamilyGauge("MinRowSize", new Gauge<Long>(){

            public Long getValue() {
                long min = 0L;
                for (SSTableReader sstable : cfs.getSSTables()) {
                    if (min != 0L && sstable.getEstimatedRowSize().min() >= min) continue;
                    min = sstable.getEstimatedRowSize().min();
                }
                return min;
            }
        }, new Gauge<Long>(){

            public Long getValue() {
                long min = Long.MAX_VALUE;
                for (Metric cfGauge : (Set)allColumnFamilyMetrics.get("MinRowSize")) {
                    min = Math.min(min, ((Number)((Gauge)cfGauge).getValue()).longValue());
                }
                return min;
            }
        });
        this.maxRowSize = this.createColumnFamilyGauge("MaxRowSize", new Gauge<Long>(){

            public Long getValue() {
                long max = 0L;
                for (SSTableReader sstable : cfs.getSSTables()) {
                    if (sstable.getEstimatedRowSize().max() <= max) continue;
                    max = sstable.getEstimatedRowSize().max();
                }
                return max;
            }
        }, new Gauge<Long>(){

            public Long getValue() {
                long max = 0L;
                for (Metric cfGauge : (Set)allColumnFamilyMetrics.get("MaxRowSize")) {
                    max = Math.max(max, ((Number)((Gauge)cfGauge).getValue()).longValue());
                }
                return max;
            }
        });
        this.meanRowSize = this.createColumnFamilyGauge("MeanRowSize", new Gauge<Long>(){

            public Long getValue() {
                long sum = 0L;
                long count = 0L;
                for (SSTableReader sstable : cfs.getSSTables()) {
                    long n = sstable.getEstimatedRowSize().count();
                    sum += sstable.getEstimatedRowSize().mean() * n;
                    count += n;
                }
                return count > 0L ? sum / count : 0L;
            }
        }, new Gauge<Long>(){

            public Long getValue() {
                long sum = 0L;
                long count = 0L;
                for (Keyspace keyspace : Keyspace.all()) {
                    for (SSTableReader sstable : keyspace.getAllSSTables()) {
                        long n = sstable.getEstimatedRowSize().count();
                        sum += sstable.getEstimatedRowSize().mean() * n;
                        count += n;
                    }
                }
                return count > 0L ? sum / count : 0L;
            }
        });
        this.bloomFilterFalsePositives = this.createColumnFamilyGauge("BloomFilterFalsePositives", new Gauge<Long>(){

            public Long getValue() {
                long count = 0L;
                for (SSTableReader sstable : cfs.getSSTables()) {
                    count += sstable.getBloomFilterFalsePositiveCount();
                }
                return count;
            }
        });
        this.recentBloomFilterFalsePositives = this.createColumnFamilyGauge("RecentBloomFilterFalsePositives", new Gauge<Long>(){

            public Long getValue() {
                long count = 0L;
                for (SSTableReader sstable : cfs.getSSTables()) {
                    count += sstable.getRecentBloomFilterFalsePositiveCount();
                }
                return count;
            }
        });
        this.bloomFilterFalseRatio = this.createColumnFamilyGauge("BloomFilterFalseRatio", new Gauge<Double>(){

            public Double getValue() {
                long falseCount = 0L;
                long trueCount = 0L;
                for (SSTableReader sstable : cfs.getSSTables()) {
                    falseCount += sstable.getBloomFilterFalsePositiveCount();
                    trueCount += sstable.getBloomFilterTruePositiveCount();
                }
                if (falseCount == 0L && trueCount == 0L) {
                    return 0.0;
                }
                return (double)falseCount / (double)(trueCount + falseCount);
            }
        }, new Gauge<Double>(){

            public Double getValue() {
                long falseCount = 0L;
                long trueCount = 0L;
                for (Keyspace keyspace : Keyspace.all()) {
                    for (SSTableReader sstable : keyspace.getAllSSTables()) {
                        falseCount += sstable.getBloomFilterFalsePositiveCount();
                        trueCount += sstable.getBloomFilterTruePositiveCount();
                    }
                }
                if (falseCount == 0L && trueCount == 0L) {
                    return 0.0;
                }
                return (double)falseCount / (double)(trueCount + falseCount);
            }
        });
        this.recentBloomFilterFalseRatio = this.createColumnFamilyGauge("RecentBloomFilterFalseRatio", new Gauge<Double>(){

            public Double getValue() {
                long falseCount = 0L;
                long trueCount = 0L;
                for (SSTableReader sstable : cfs.getSSTables()) {
                    falseCount += sstable.getRecentBloomFilterFalsePositiveCount();
                    trueCount += sstable.getRecentBloomFilterTruePositiveCount();
                }
                if (falseCount == 0L && trueCount == 0L) {
                    return 0.0;
                }
                return (double)falseCount / (double)(trueCount + falseCount);
            }
        }, new Gauge<Double>(){

            public Double getValue() {
                long falseCount = 0L;
                long trueCount = 0L;
                for (Keyspace keyspace : Keyspace.all()) {
                    for (SSTableReader sstable : keyspace.getAllSSTables()) {
                        falseCount += sstable.getRecentBloomFilterFalsePositiveCount();
                        trueCount += sstable.getRecentBloomFilterTruePositiveCount();
                    }
                }
                if (falseCount == 0L && trueCount == 0L) {
                    return 0.0;
                }
                return (double)falseCount / (double)(trueCount + falseCount);
            }
        });
        this.bloomFilterDiskSpaceUsed = this.createColumnFamilyGauge("BloomFilterDiskSpaceUsed", new Gauge<Long>(){

            public Long getValue() {
                long total = 0L;
                for (SSTableReader sst : cfs.getSSTables()) {
                    total += sst.getBloomFilterSerializedSize();
                }
                return total;
            }
        });
        this.bloomFilterOffHeapMemoryUsed = this.createColumnFamilyGauge("BloomFilterOffHeapMemoryUsed", new Gauge<Long>(){

            public Long getValue() {
                long total = 0L;
                for (SSTableReader sst : cfs.getSSTables()) {
                    total += sst.getBloomFilterOffHeapSize();
                }
                return total;
            }
        });
        this.indexSummaryOffHeapMemoryUsed = this.createColumnFamilyGauge("IndexSummaryOffHeapMemoryUsed", new Gauge<Long>(){

            public Long getValue() {
                long total = 0L;
                for (SSTableReader sst : cfs.getSSTables()) {
                    total += sst.getIndexSummaryOffHeapSize();
                }
                return total;
            }
        });
        this.compressionMetadataOffHeapMemoryUsed = this.createColumnFamilyGauge("CompressionMetadataOffHeapMemoryUsed", new Gauge<Long>(){

            public Long getValue() {
                long total = 0L;
                for (SSTableReader sst : cfs.getSSTables()) {
                    total += sst.getCompressionMetadataOffHeapSize();
                }
                return total;
            }
        });
        this.speculativeRetries = this.createColumnFamilyCounter("SpeculativeRetries");
        this.keyCacheHitRate = (Gauge)CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName("KeyCacheHitRate"), new RatioGauge(){

            public RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)this.getNumerator(), (double)this.getDenominator());
            }

            protected double getNumerator() {
                long hits = 0L;
                for (SSTableReader sstable : cfs.getSSTables()) {
                    hits += sstable.getKeyCacheHit();
                }
                return hits;
            }

            protected double getDenominator() {
                long requests = 0L;
                for (SSTableReader sstable : cfs.getSSTables()) {
                    requests += sstable.getKeyCacheRequest();
                }
                return Math.max(requests, 1L);
            }
        });
        this.tombstoneScannedHistogram = this.createColumnFamilyHistogram("TombstoneScannedHistogram", cfs.keyspace.metric.tombstoneScannedHistogram);
        this.liveScannedHistogram = this.createColumnFamilyHistogram("LiveScannedHistogram", cfs.keyspace.metric.liveScannedHistogram);
        this.colUpdateTimeDeltaHistogram = this.createColumnFamilyHistogram("ColUpdateTimeDeltaHistogram", cfs.keyspace.metric.colUpdateTimeDeltaHistogram);
        this.coordinatorReadLatency = CassandraMetricsRegistry.Metrics.timer(this.factory.createMetricName("CoordinatorReadLatency"));
        this.coordinatorScanLatency = CassandraMetricsRegistry.Metrics.timer(this.factory.createMetricName("CoordinatorScanLatency"));
        this.waitingOnFreeMemtableSpace = CassandraMetricsRegistry.Metrics.histogram(this.factory.createMetricName("WaitingOnFreeMemtableSpace"));
        this.trueSnapshotsSize = this.createColumnFamilyGauge("SnapshotsSize", new Gauge<Long>(){

            public Long getValue() {
                return cfs.trueSnapshotsSize();
            }
        });
        this.rowCacheHitOutOfRange = this.createColumnFamilyCounter("RowCacheHitOutOfRange");
        this.rowCacheHit = this.createColumnFamilyCounter("RowCacheHit");
        this.rowCacheMiss = this.createColumnFamilyCounter("RowCacheMiss");
        this.casPrepare = new LatencyMetrics(this.factory, "CasPrepare", cfs.keyspace.metric.casPrepare);
        this.casPropose = new LatencyMetrics(this.factory, "CasPropose", cfs.keyspace.metric.casPropose);
        this.casCommit = new LatencyMetrics(this.factory, "CasCommit", cfs.keyspace.metric.casCommit);
    }

    public void updateSSTableIterated(int count) {
        this.sstablesPerReadHistogram.update(count);
    }

    public void release() {
        for (String name : all) {
            ((Set)allColumnFamilyMetrics.get(name)).remove(CassandraMetricsRegistry.Metrics.getMetrics().get(this.factory.createMetricName(name).getMetricName()));
            CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName(name));
        }
        this.readLatency.release();
        this.writeLatency.release();
        this.rangeLatency.release();
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("EstimatedRowSizeHistogram"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("EstimatedColumnCountHistogram"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("KeyCacheHitRate"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("CoordinatorReadLatency"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("CoordinatorScanLatency"));
        CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName("WaitingOnFreeMemtableSpace"));
    }

    protected <T extends Number> Gauge<T> createColumnFamilyGauge(final String name, Gauge<T> gauge) {
        return this.createColumnFamilyGauge(name, gauge, new Gauge<Long>(){

            public Long getValue() {
                long total = 0L;
                for (Metric cfGauge : (Set)allColumnFamilyMetrics.get(name)) {
                    total += ((Number)((Gauge)cfGauge).getValue()).longValue();
                }
                return total;
            }
        });
    }

    protected <G, T> Gauge<T> createColumnFamilyGauge(String name, Gauge<T> gauge, Gauge<G> globalGauge) {
        Gauge<T> cfGauge = CassandraMetricsRegistry.Metrics.register(this.factory.createMetricName(name), gauge);
        if (this.register(name, (Metric)cfGauge)) {
            CassandraMetricsRegistry.Metrics.register(globalNameFactory.createMetricName(name), globalGauge);
        }
        return cfGauge;
    }

    protected Counter createColumnFamilyCounter(final String name) {
        Counter cfCounter = CassandraMetricsRegistry.Metrics.counter(this.factory.createMetricName(name));
        if (this.register(name, (Metric)cfCounter)) {
            CassandraMetricsRegistry.Metrics.register(globalNameFactory.createMetricName(name), new Gauge<Long>(){

                public Long getValue() {
                    long total = 0L;
                    for (Metric cfGauge : (Set)allColumnFamilyMetrics.get(name)) {
                        total += ((Counter)cfGauge).getCount();
                    }
                    return total;
                }
            });
        }
        return cfCounter;
    }

    protected ColumnFamilyHistogram createColumnFamilyHistogram(String name, Histogram keyspaceHistogram) {
        Histogram cfHistogram = CassandraMetricsRegistry.Metrics.histogram(this.factory.createMetricName(name));
        this.register(name, (Metric)cfHistogram);
        return new ColumnFamilyHistogram(cfHistogram, keyspaceHistogram, CassandraMetricsRegistry.Metrics.histogram(globalNameFactory.createMetricName(name)));
    }

    private boolean register(String name, Metric metric) {
        boolean ret = allColumnFamilyMetrics.putIfAbsent(name, new HashSet()) == null;
        ((Set)allColumnFamilyMetrics.get(name)).add(metric);
        all.add(name);
        return ret;
    }

    public static enum Sampler {
        READS,
        WRITES;

    }

    static class AllColumnFamilyMetricNameFactory
    implements MetricNameFactory {
        AllColumnFamilyMetricNameFactory() {
        }

        @Override
        public CassandraMetricsRegistry.MetricName createMetricName(String metricName) {
            String groupName = ColumnFamilyMetrics.class.getPackage().getName();
            StringBuilder mbeanName = new StringBuilder();
            mbeanName.append(groupName).append(":");
            mbeanName.append("type=ColumnFamily");
            mbeanName.append(",name=").append(metricName);
            return new CassandraMetricsRegistry.MetricName(groupName, "ColumnFamily", metricName, "all", mbeanName.toString());
        }
    }

    static class ColumnFamilyMetricNameFactory
    implements MetricNameFactory {
        private final String keyspaceName;
        private final String columnFamilyName;
        private final boolean isIndex;

        ColumnFamilyMetricNameFactory(ColumnFamilyStore cfs) {
            this.keyspaceName = cfs.keyspace.getName();
            this.columnFamilyName = cfs.name;
            this.isIndex = cfs.isIndex();
        }

        @Override
        public CassandraMetricsRegistry.MetricName createMetricName(String metricName) {
            String groupName = ColumnFamilyMetrics.class.getPackage().getName();
            String type = this.isIndex ? "IndexColumnFamily" : "ColumnFamily";
            StringBuilder mbeanName = new StringBuilder();
            mbeanName.append(groupName).append(":");
            mbeanName.append("type=").append(type);
            mbeanName.append(",keyspace=").append(this.keyspaceName);
            mbeanName.append(",scope=").append(this.columnFamilyName);
            mbeanName.append(",name=").append(metricName);
            return new CassandraMetricsRegistry.MetricName(groupName, type, metricName, this.keyspaceName + "." + this.columnFamilyName, mbeanName.toString());
        }
    }

    public static class ColumnFamilyHistogram {
        public final Histogram[] all;
        public final Histogram cf;

        private ColumnFamilyHistogram(Histogram cf, Histogram keyspace, Histogram global) {
            this.cf = cf;
            this.all = new Histogram[]{cf, keyspace, global};
        }

        public void update(long i) {
            for (Histogram histo : this.all) {
                histo.update(i);
            }
        }
    }

    private static interface GetHistogram {
        public EstimatedHistogram getHistogram(SSTableReader var1);
    }
}

