/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.DataInput;
import java.io.IOError;
import java.io.IOException;
import java.util.Iterator;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.serializers.MarshalException;

public class SSTableIdentityIterator
implements Comparable<SSTableIdentityIterator>,
OnDiskAtomIterator {
    private final DecoratedKey key;
    private final DataInput in;
    public final ColumnSerializer.Flag flag;
    private final ColumnFamily columnFamily;
    private final Iterator<OnDiskAtom> atomIterator;
    private final boolean validateColumns;
    private final String filename;

    public SSTableIdentityIterator(SSTableReader sstable, RandomAccessReader file, DecoratedKey key) {
        this(sstable, file, key, false);
    }

    public SSTableIdentityIterator(SSTableReader sstable, RandomAccessReader file, DecoratedKey key, boolean checkData) {
        this(sstable.metadata, file, file.getPath(), key, checkData, sstable, ColumnSerializer.Flag.LOCAL);
    }

    private SSTableIdentityIterator(CFMetaData metadata, FileDataInput in, String filename, DecoratedKey key, boolean checkData, SSTableReader sstable, ColumnSerializer.Flag flag) {
        assert (!checkData || sstable != null);
        this.in = in;
        this.filename = filename;
        this.key = key;
        this.flag = flag;
        this.validateColumns = checkData;
        Version dataVersion = sstable == null ? DatabaseDescriptor.getSSTableFormat().info.getLatestVersion() : sstable.descriptor.version;
        int expireBefore = (int)(System.currentTimeMillis() / 1000L);
        this.columnFamily = ArrayBackedSortedColumns.factory.create(metadata);
        try {
            this.columnFamily.delete(DeletionTime.serializer.deserialize(in));
            this.atomIterator = this.columnFamily.metadata().getOnDiskIterator(in, flag, expireBefore, dataVersion);
        }
        catch (IOException e) {
            if (sstable != null) {
                sstable.markSuspect();
            }
            throw new CorruptSSTableException((Exception)e, filename);
        }
    }

    @Override
    public DecoratedKey getKey() {
        return this.key;
    }

    @Override
    public ColumnFamily getColumnFamily() {
        return this.columnFamily;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.atomIterator.hasNext();
        }
        catch (IOError e) {
            if (e.getCause() instanceof IOException) {
                throw new CorruptSSTableException((Exception)((IOException)e.getCause()), this.filename);
            }
            throw e;
        }
    }

    @Override
    public OnDiskAtom next() {
        try {
            OnDiskAtom atom = this.atomIterator.next();
            if (this.validateColumns) {
                atom.validateFields(this.columnFamily.metadata());
            }
            return atom;
        }
        catch (MarshalException me) {
            throw new CorruptSSTableException((Exception)me, this.filename);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
    }

    public String getPath() {
        if (this.in instanceof RandomAccessReader) {
            RandomAccessReader file = (RandomAccessReader)this.in;
            return file.getPath();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareTo(SSTableIdentityIterator o) {
        return this.key.compareTo(o.key);
    }
}

