/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.compress;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.io.compress.ICompressor;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xerial.snappy.Snappy;
import org.xerial.snappy.SnappyError;

public class SnappyCompressor
implements ICompressor {
    public static final SnappyCompressor instance = new SnappyCompressor();
    private static Logger logger = LoggerFactory.getLogger(SnappyCompressor.class);

    public static SnappyCompressor create(Map<String, String> compressionOptions) {
        Snappy.getNativeLibraryVersion();
        return instance;
    }

    public static boolean isAvailable() {
        try {
            SnappyCompressor.create(Collections.emptyMap());
            return true;
        }
        catch (Exception e) {
            JVMStabilityInspector.inspectThrowable(e);
            return false;
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError | SnappyError e) {
            return false;
        }
    }

    @Override
    public Set<String> supportedOptions() {
        return Collections.emptySet();
    }

    @Override
    public int initialCompressedBufferLength(int chunkLength) {
        return Snappy.maxCompressedLength((int)chunkLength);
    }

    @Override
    public int compress(ByteBuffer src, ICompressor.WrappedByteBuffer dest) throws IOException {
        int result = Snappy.compress((ByteBuffer)src, (ByteBuffer)dest.buffer);
        dest.buffer.position(dest.buffer.limit());
        dest.buffer.limit(dest.buffer.capacity());
        return result;
    }

    @Override
    public int uncompress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws IOException {
        return Snappy.rawUncompress((byte[])input, (int)inputOffset, (int)inputLength, (Object)output, (int)outputOffset);
    }

    @Override
    public int uncompress(ByteBuffer input, ByteBuffer output) throws IOException {
        if (input.hasArray() && output.hasArray()) {
            return Snappy.rawUncompress((byte[])input.array(), (int)(input.arrayOffset() + input.position()), (int)input.remaining(), (Object)output.array(), (int)(output.arrayOffset() + output.position()));
        }
        return Snappy.uncompress((ByteBuffer)input, (ByteBuffer)output);
    }

    @Override
    public boolean useDirectOutputByteBuffers() {
        return true;
    }

    static {
        if (!SnappyCompressor.isAvailable()) {
            logger.warn("Cannot initialize native Snappy library. Compression on new sstables will be disabled.");
        }
    }
}

