/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.BufferCell;
import org.apache.cassandra.db.CFRowAdder;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.commitlog.ReplayPosition;
import org.apache.cassandra.db.compaction.CompactionHistoryTabularData;
import org.apache.cassandra.db.compaction.LeveledCompactionStrategy;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.LocalStrategy;
import org.apache.cassandra.metrics.RestorableMeter;
import org.apache.cassandra.schema.LegacySchemaTables;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.service.paxos.PaxosState;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.SemanticVersion;
import org.apache.cassandra.utils.UUIDGen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemKeyspace {
    private static final Logger logger = LoggerFactory.getLogger(SystemKeyspace.class);
    public static final SemanticVersion UNREADABLE_VERSION = new SemanticVersion("0.0.0-unknown");
    public static final SemanticVersion NULL_VERSION = new SemanticVersion("0.0.0-absent");
    public static final String NAME = "system";
    public static final String HINTS = "hints";
    public static final String BATCHLOG = "batchlog";
    public static final String PAXOS = "paxos";
    public static final String BUILT_INDEXES = "IndexInfo";
    public static final String LOCAL = "local";
    public static final String PEERS = "peers";
    public static final String PEER_EVENTS = "peer_events";
    public static final String RANGE_XFERS = "range_xfers";
    public static final String COMPACTIONS_IN_PROGRESS = "compactions_in_progress";
    public static final String COMPACTION_HISTORY = "compaction_history";
    public static final String SSTABLE_ACTIVITY = "sstable_activity";
    public static final String SIZE_ESTIMATES = "size_estimates";
    public static final String AVAILABLE_RANGES = "available_ranges";
    public static final CFMetaData Hints = SystemKeyspace.compile("hints", "hints awaiting delivery", "CREATE TABLE %s (target_id uuid,hint_id timeuuid,message_version int,mutation blob,PRIMARY KEY ((target_id), hint_id, message_version)) WITH COMPACT STORAGE").compactionStrategyOptions(Collections.singletonMap("enabled", "false")).gcGraceSeconds(0);
    public static final CFMetaData Batchlog = SystemKeyspace.compile("batchlog", "batches awaiting replay", "CREATE TABLE %s (id uuid,data blob,version int,written_at timestamp,PRIMARY KEY ((id)))").compactionStrategyOptions(Collections.singletonMap("min_threshold", "2")).gcGraceSeconds(0);
    private static final CFMetaData Paxos = SystemKeyspace.compile("paxos", "in-progress paxos proposals", "CREATE TABLE %s (row_key blob,cf_id UUID,in_progress_ballot timeuuid,most_recent_commit blob,most_recent_commit_at timeuuid,proposal blob,proposal_ballot timeuuid,PRIMARY KEY ((row_key), cf_id))").compactionStrategyClass(LeveledCompactionStrategy.class);
    public static final CFMetaData BuiltIndexes = SystemKeyspace.compile("IndexInfo", "built column indexes", "CREATE TABLE \"%s\" (table_name text,index_name text,PRIMARY KEY ((table_name), index_name)) WITH COMPACT STORAGE");
    private static final CFMetaData Local = SystemKeyspace.compile("local", "information about the local node", "CREATE TABLE %s (key text,bootstrapped text,cluster_name text,cql_version text,data_center text,gossip_generation int,host_id uuid,native_protocol_version text,partitioner text,rack text,release_version text,schema_version uuid,thrift_version text,tokens set<varchar>,truncated_at map<uuid, blob>,PRIMARY KEY ((key)))");
    private static final CFMetaData Peers = SystemKeyspace.compile("peers", "information about known peers in the cluster", "CREATE TABLE %s (peer inet,data_center text,host_id uuid,preferred_ip inet,rack text,release_version text,rpc_address inet,schema_version uuid,tokens set<varchar>,PRIMARY KEY ((peer)))");
    private static final CFMetaData PeerEvents = SystemKeyspace.compile("peer_events", "events related to peers", "CREATE TABLE %s (peer inet,hints_dropped map<uuid, int>,PRIMARY KEY ((peer)))");
    private static final CFMetaData RangeXfers = SystemKeyspace.compile("range_xfers", "ranges requested for transfer", "CREATE TABLE %s (token_bytes blob,requested_at timestamp,PRIMARY KEY ((token_bytes)))");
    private static final CFMetaData CompactionsInProgress = SystemKeyspace.compile("compactions_in_progress", "unfinished compactions", "CREATE TABLE %s (id uuid,columnfamily_name text,inputs set<int>,keyspace_name text,PRIMARY KEY ((id)))");
    private static final CFMetaData CompactionHistory = SystemKeyspace.compile("compaction_history", "week-long compaction history", "CREATE TABLE %s (id uuid,bytes_in bigint,bytes_out bigint,columnfamily_name text,compacted_at timestamp,keyspace_name text,rows_merged map<int, bigint>,PRIMARY KEY ((id)))").defaultTimeToLive((int)TimeUnit.DAYS.toSeconds(7L));
    private static final CFMetaData SSTableActivity = SystemKeyspace.compile("sstable_activity", "historic sstable read rates", "CREATE TABLE %s (keyspace_name text,columnfamily_name text,generation int,rate_120m double,rate_15m double,PRIMARY KEY ((keyspace_name, columnfamily_name, generation)))");
    private static final CFMetaData SizeEstimates = SystemKeyspace.compile("size_estimates", "per-table primary range size estimates", "CREATE TABLE %s (keyspace_name text,table_name text,range_start text,range_end text,mean_partition_size bigint,partitions_count bigint,PRIMARY KEY ((keyspace_name), table_name, range_start, range_end))").gcGraceSeconds(0);
    private static final CFMetaData AvailableRanges = SystemKeyspace.compile("available_ranges", "Available keyspace/ranges during bootstrap/replace that are ready to be served", "CREATE TABLE %s (keyspace_name text PRIMARY KEY,ranges set<blob>)");
    private static volatile Map<UUID, Pair<ReplayPosition, Long>> truncationRecords;

    private static CFMetaData compile(String name, String description, String schema) {
        return CFMetaData.compile(String.format(schema, name), NAME).comment(description);
    }

    public static KSMetaData definition() {
        Iterable tables = Iterables.concat(LegacySchemaTables.All, Arrays.asList(BuiltIndexes, Hints, Batchlog, Paxos, Local, Peers, PeerEvents, RangeXfers, CompactionsInProgress, CompactionHistory, SSTableActivity, SizeEstimates, AvailableRanges));
        return new KSMetaData(NAME, LocalStrategy.class, Collections.emptyMap(), true, tables);
    }

    private static DecoratedKey decorate(ByteBuffer key) {
        return StorageService.getPartitioner().decorateKey(key);
    }

    public static void finishStartup() {
        SystemKeyspace.setupVersion();
        LegacySchemaTables.saveSystemKeyspaceSchema();
    }

    private static void setupVersion() {
        String req = "INSERT INTO system.%s (  key,   cluster_name,   release_version,   cql_version,   thrift_version,   native_protocol_version,   data_center,   rack,   partitioner) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
        IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
        QueryProcessor.executeOnceInternal(String.format(req, LOCAL), LOCAL, DatabaseDescriptor.getClusterName(), FBUtilities.getReleaseVersionString(), QueryProcessor.CQL_VERSION.toString(), "20.1.0", String.valueOf(4), snitch.getDatacenter(FBUtilities.getBroadcastAddress()), snitch.getRack(FBUtilities.getBroadcastAddress()), DatabaseDescriptor.getPartitioner().getClass().getName());
    }

    public static UUID startCompaction(ColumnFamilyStore cfs, Iterable<SSTableReader> toCompact) {
        if (NAME.equals(cfs.keyspace.getName())) {
            return null;
        }
        UUID compactionId = UUIDGen.getTimeUUID();
        Iterable generations = Iterables.transform(toCompact, (Function)new Function<SSTableReader, Integer>(){

            public Integer apply(SSTableReader sstable) {
                return sstable.descriptor.generation;
            }
        });
        String req = "INSERT INTO system.%s (id, keyspace_name, columnfamily_name, inputs) VALUES (?, ?, ?, ?)";
        QueryProcessor.executeInternal(String.format(req, COMPACTIONS_IN_PROGRESS), compactionId, cfs.keyspace.getName(), cfs.name, Sets.newHashSet((Iterable)generations));
        SystemKeyspace.forceBlockingFlush(COMPACTIONS_IN_PROGRESS);
        return compactionId;
    }

    public static void finishCompaction(UUID taskId) {
        assert (taskId != null);
        QueryProcessor.executeInternal(String.format("DELETE FROM system.%s WHERE id = ?", COMPACTIONS_IN_PROGRESS), taskId);
        SystemKeyspace.forceBlockingFlush(COMPACTIONS_IN_PROGRESS);
    }

    public static Map<Pair<String, String>, Map<Integer, UUID>> getUnfinishedCompactions() {
        String req = "SELECT * FROM system.%s";
        UntypedResultSet resultSet = QueryProcessor.executeInternal(String.format(req, COMPACTIONS_IN_PROGRESS), new Object[0]);
        HashMap<Pair<String, String>, Map<Integer, UUID>> unfinishedCompactions = new HashMap<Pair<String, String>, Map<Integer, UUID>>();
        for (UntypedResultSet.Row row : resultSet) {
            String keyspace = row.getString("keyspace_name");
            String columnfamily = row.getString("columnfamily_name");
            Set<Integer> inputs = row.getSet("inputs", Int32Type.instance);
            UUID taskID = row.getUUID("id");
            Pair<String, String> kscf = Pair.create(keyspace, columnfamily);
            HashMap<Integer, UUID> generationToTaskID = (HashMap<Integer, UUID>)unfinishedCompactions.get(kscf);
            if (generationToTaskID == null) {
                generationToTaskID = new HashMap<Integer, UUID>(inputs.size());
            }
            for (Integer generation : inputs) {
                generationToTaskID.put(generation, taskID);
            }
            unfinishedCompactions.put(kscf, generationToTaskID);
        }
        return unfinishedCompactions;
    }

    public static void discardCompactionsInProgress() {
        ColumnFamilyStore compactionLog = Keyspace.open(NAME).getColumnFamilyStore(COMPACTIONS_IN_PROGRESS);
        compactionLog.truncateBlocking();
    }

    public static void updateCompactionHistory(String ksname, String cfname, long compactedAt, long bytesIn, long bytesOut, Map<Integer, Long> rowsMerged) {
        if (ksname.equals(NAME) && cfname.equals(COMPACTION_HISTORY)) {
            return;
        }
        String req = "INSERT INTO system.%s (id, keyspace_name, columnfamily_name, compacted_at, bytes_in, bytes_out, rows_merged) VALUES (?, ?, ?, ?, ?, ?, ?)";
        QueryProcessor.executeInternal(String.format(req, COMPACTION_HISTORY), UUIDGen.getTimeUUID(), ksname, cfname, ByteBufferUtil.bytes(compactedAt), bytesIn, bytesOut, rowsMerged);
    }

    public static TabularData getCompactionHistory() throws OpenDataException {
        UntypedResultSet queryResultSet = QueryProcessor.executeInternal(String.format("SELECT * from system.%s", COMPACTION_HISTORY), new Object[0]);
        return CompactionHistoryTabularData.from(queryResultSet);
    }

    public static synchronized void saveTruncationRecord(ColumnFamilyStore cfs, long truncatedAt, ReplayPosition position) {
        String req = "UPDATE system.%s SET truncated_at = truncated_at + ? WHERE key = '%s'";
        QueryProcessor.executeInternal(String.format(req, LOCAL, LOCAL), SystemKeyspace.truncationAsMapEntry(cfs, truncatedAt, position));
        truncationRecords = null;
        SystemKeyspace.forceBlockingFlush(LOCAL);
    }

    public static synchronized void removeTruncationRecord(UUID cfId) {
        String req = "DELETE truncated_at[?] from system.%s WHERE key = '%s'";
        QueryProcessor.executeInternal(String.format(req, LOCAL, LOCAL), cfId);
        truncationRecords = null;
        SystemKeyspace.forceBlockingFlush(LOCAL);
    }

    private static Map<UUID, ByteBuffer> truncationAsMapEntry(ColumnFamilyStore cfs, long truncatedAt, ReplayPosition position) {
        DataOutputBuffer out = new DataOutputBuffer();
        try {
            ReplayPosition.serializer.serialize(position, (DataOutputPlus)out);
            out.writeLong(truncatedAt);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return Collections.singletonMap(cfs.metadata.cfId, ByteBuffer.wrap(out.getData(), 0, out.getLength()));
    }

    public static ReplayPosition getTruncatedPosition(UUID cfId) {
        Pair<ReplayPosition, Long> record = SystemKeyspace.getTruncationRecord(cfId);
        return record == null ? null : (ReplayPosition)record.left;
    }

    public static long getTruncatedAt(UUID cfId) {
        Pair<ReplayPosition, Long> record = SystemKeyspace.getTruncationRecord(cfId);
        return record == null ? Long.MIN_VALUE : (Long)record.right;
    }

    private static synchronized Pair<ReplayPosition, Long> getTruncationRecord(UUID cfId) {
        if (truncationRecords == null) {
            truncationRecords = SystemKeyspace.readTruncationRecords();
        }
        return truncationRecords.get(cfId);
    }

    private static Map<UUID, Pair<ReplayPosition, Long>> readTruncationRecords() {
        UntypedResultSet rows = QueryProcessor.executeInternal(String.format("SELECT truncated_at FROM system.%s WHERE key = '%s'", LOCAL, LOCAL), new Object[0]);
        HashMap<UUID, Pair<ReplayPosition, Long>> records = new HashMap<UUID, Pair<ReplayPosition, Long>>();
        if (!rows.isEmpty() && rows.one().has("truncated_at")) {
            Map<UUID, ByteBuffer> map = rows.one().getMap("truncated_at", UUIDType.instance, BytesType.instance);
            for (Map.Entry<UUID, ByteBuffer> entry : map.entrySet()) {
                records.put(entry.getKey(), SystemKeyspace.truncationRecordFromBlob(entry.getValue()));
            }
        }
        return records;
    }

    private static Pair<ReplayPosition, Long> truncationRecordFromBlob(ByteBuffer bytes) {
        try {
            DataInputStream in = new DataInputStream(ByteBufferUtil.inputStream(bytes));
            return Pair.create(ReplayPosition.serializer.deserialize(in), in.available() > 0 ? in.readLong() : Long.MIN_VALUE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static synchronized void updateTokens(InetAddress ep, Collection<Token> tokens) {
        if (ep.equals(FBUtilities.getBroadcastAddress())) {
            SystemKeyspace.removeEndpoint(ep);
            return;
        }
        String req = "INSERT INTO system.%s (peer, tokens) VALUES (?, ?)";
        QueryProcessor.executeInternal(String.format(req, PEERS), ep, SystemKeyspace.tokensAsSet(tokens));
    }

    public static synchronized void updatePreferredIP(InetAddress ep, InetAddress preferred_ip) {
        String req = "INSERT INTO system.%s (peer, preferred_ip) VALUES (?, ?)";
        QueryProcessor.executeInternal(String.format(req, PEERS), ep, preferred_ip);
        SystemKeyspace.forceBlockingFlush(PEERS);
    }

    public static synchronized void updatePeerInfo(InetAddress ep, String columnName, Object value) {
        if (ep.equals(FBUtilities.getBroadcastAddress())) {
            return;
        }
        String req = "INSERT INTO system.%s (peer, %s) VALUES (?, ?)";
        QueryProcessor.executeInternal(String.format(req, PEERS, columnName), ep, value);
    }

    public static synchronized void updateHintsDropped(InetAddress ep, UUID timePeriod, int value) {
        String req = "UPDATE system.%s USING TTL 2592000 SET hints_dropped[ ? ] = ? WHERE peer = ?";
        QueryProcessor.executeInternal(String.format(req, PEER_EVENTS), timePeriod, value, ep);
    }

    public static synchronized void updateSchemaVersion(UUID version) {
        String req = "INSERT INTO system.%s (key, schema_version) VALUES ('%s', ?)";
        QueryProcessor.executeInternal(String.format(req, LOCAL, LOCAL), version);
    }

    private static Set<String> tokensAsSet(Collection<Token> tokens) {
        Token.TokenFactory factory = StorageService.getPartitioner().getTokenFactory();
        HashSet<String> s = new HashSet<String>(tokens.size());
        for (Token tk : tokens) {
            s.add(factory.toString(tk));
        }
        return s;
    }

    private static Collection<Token> deserializeTokens(Collection<String> tokensStrings) {
        Token.TokenFactory factory = StorageService.getPartitioner().getTokenFactory();
        ArrayList<Token> tokens = new ArrayList<Token>(tokensStrings.size());
        for (String tk : tokensStrings) {
            tokens.add(factory.fromString(tk));
        }
        return tokens;
    }

    public static synchronized void removeEndpoint(InetAddress ep) {
        String req = "DELETE FROM system.%s WHERE peer = ?";
        QueryProcessor.executeInternal(String.format(req, PEERS), ep);
    }

    public static synchronized void updateTokens(Collection<Token> tokens) {
        assert (!tokens.isEmpty()) : "removeEndpoint should be used instead";
        String req = "INSERT INTO system.%s (key, tokens) VALUES ('%s', ?)";
        QueryProcessor.executeInternal(String.format(req, LOCAL, LOCAL), SystemKeyspace.tokensAsSet(tokens));
        SystemKeyspace.forceBlockingFlush(LOCAL);
    }

    public static synchronized Collection<Token> updateLocalTokens(Collection<Token> addTokens, Collection<Token> rmTokens) {
        Collection<Token> tokens = SystemKeyspace.getSavedTokens();
        tokens.removeAll(rmTokens);
        tokens.addAll(addTokens);
        SystemKeyspace.updateTokens(tokens);
        return tokens;
    }

    public static void forceBlockingFlush(String cfname) {
        if (!Boolean.getBoolean("cassandra.unsafesystem")) {
            FBUtilities.waitOnFuture(Keyspace.open(NAME).getColumnFamilyStore(cfname).forceFlush());
        }
    }

    public static SetMultimap<InetAddress, Token> loadTokens() {
        HashMultimap tokenMap = HashMultimap.create();
        for (UntypedResultSet.Row row : QueryProcessor.executeInternal("SELECT peer, tokens FROM system.peers", new Object[0])) {
            InetAddress peer = row.getInetAddress("peer");
            if (!row.has("tokens")) continue;
            tokenMap.putAll((Object)peer, SystemKeyspace.deserializeTokens(row.getSet("tokens", UTF8Type.instance)));
        }
        return tokenMap;
    }

    public static Map<InetAddress, UUID> loadHostIds() {
        HashMap<InetAddress, UUID> hostIdMap = new HashMap<InetAddress, UUID>();
        for (UntypedResultSet.Row row : QueryProcessor.executeInternal("SELECT peer, host_id FROM system.peers", new Object[0])) {
            InetAddress peer = row.getInetAddress("peer");
            if (!row.has("host_id")) continue;
            hostIdMap.put(peer, row.getUUID("host_id"));
        }
        return hostIdMap;
    }

    public static InetAddress getPreferredIP(InetAddress ep) {
        String req = "SELECT preferred_ip FROM system.%s WHERE peer=?";
        UntypedResultSet result = QueryProcessor.executeInternal(String.format(req, PEERS), ep);
        if (!result.isEmpty() && result.one().has("preferred_ip")) {
            return result.one().getInetAddress("preferred_ip");
        }
        return ep;
    }

    public static Map<InetAddress, Map<String, String>> loadDcRackInfo() {
        HashMap<InetAddress, Map<String, String>> result = new HashMap<InetAddress, Map<String, String>>();
        for (UntypedResultSet.Row row : QueryProcessor.executeInternal("SELECT peer, data_center, rack from system.peers", new Object[0])) {
            InetAddress peer = row.getInetAddress("peer");
            if (!row.has("data_center") || !row.has("rack")) continue;
            HashMap<String, String> dcRack = new HashMap<String, String>();
            dcRack.put("data_center", row.getString("data_center"));
            dcRack.put("rack", row.getString("rack"));
            result.put(peer, dcRack);
        }
        return result;
    }

    public static SemanticVersion getReleaseVersion(InetAddress ep) {
        try {
            if (FBUtilities.getBroadcastAddress().equals(ep)) {
                return new SemanticVersion(FBUtilities.getReleaseVersionString());
            }
            String req = "SELECT release_version FROM system.%s WHERE peer=?";
            UntypedResultSet result = QueryProcessor.executeInternal(String.format(req, PEERS), ep);
            if (result != null && result.one().has("release_version")) {
                return new SemanticVersion(result.one().getString("release_version"));
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static void checkHealth() throws ConfigurationException {
        Keyspace keyspace;
        try {
            keyspace = Keyspace.open(NAME);
        }
        catch (AssertionError err) {
            ConfigurationException ex = new ConfigurationException("Could not read system keyspace!");
            ex.initCause((Throwable)((Object)err));
            throw ex;
        }
        ColumnFamilyStore cfs = keyspace.getColumnFamilyStore(LOCAL);
        String req = "SELECT cluster_name FROM system.%s WHERE key='%s'";
        UntypedResultSet result = QueryProcessor.executeInternal(String.format(req, LOCAL, LOCAL), new Object[0]);
        if (result.isEmpty() || !result.one().has("cluster_name")) {
            if (!cfs.getSSTables().isEmpty()) {
                throw new ConfigurationException("Found system keyspace files, but they couldn't be loaded!");
            }
            return;
        }
        String savedClusterName = result.one().getString("cluster_name");
        if (!DatabaseDescriptor.getClusterName().equals(savedClusterName)) {
            throw new ConfigurationException("Saved cluster name " + savedClusterName + " != configured name " + DatabaseDescriptor.getClusterName());
        }
    }

    public static Collection<Token> getSavedTokens() {
        String req = "SELECT tokens FROM system.%s WHERE key='%s'";
        UntypedResultSet result = QueryProcessor.executeInternal(String.format(req, LOCAL, LOCAL), new Object[0]);
        return result.isEmpty() || !result.one().has("tokens") ? Collections.emptyList() : SystemKeyspace.deserializeTokens(result.one().getSet("tokens", UTF8Type.instance));
    }

    public static int incrementAndGetGeneration() {
        int generation;
        String req = "SELECT gossip_generation FROM system.%s WHERE key='%s'";
        UntypedResultSet result = QueryProcessor.executeInternal(String.format(req, LOCAL, LOCAL), new Object[0]);
        if (result.isEmpty() || !result.one().has("gossip_generation")) {
            generation = (int)(System.currentTimeMillis() / 1000L);
        } else {
            int now;
            int storedGeneration = result.one().getInt("gossip_generation") + 1;
            if (storedGeneration >= (now = (int)(System.currentTimeMillis() / 1000L))) {
                logger.warn("Using stored Gossip Generation {} as it is greater than current system time {}.  See CASSANDRA-3654 if you experience problems", (Object)storedGeneration, (Object)now);
                generation = storedGeneration;
            } else {
                generation = now;
            }
        }
        req = "INSERT INTO system.%s (key, gossip_generation) VALUES ('%s', ?)";
        QueryProcessor.executeInternal(String.format(req, LOCAL, LOCAL), generation);
        SystemKeyspace.forceBlockingFlush(LOCAL);
        return generation;
    }

    public static BootstrapState getBootstrapState() {
        String req = "SELECT bootstrapped FROM system.%s WHERE key='%s'";
        UntypedResultSet result = QueryProcessor.executeInternal(String.format(req, LOCAL, LOCAL), new Object[0]);
        if (result.isEmpty() || !result.one().has("bootstrapped")) {
            return BootstrapState.NEEDS_BOOTSTRAP;
        }
        return BootstrapState.valueOf(result.one().getString("bootstrapped"));
    }

    public static boolean bootstrapComplete() {
        return SystemKeyspace.getBootstrapState() == BootstrapState.COMPLETED;
    }

    public static boolean bootstrapInProgress() {
        return SystemKeyspace.getBootstrapState() == BootstrapState.IN_PROGRESS;
    }

    public static void setBootstrapState(BootstrapState state) {
        String req = "INSERT INTO system.%s (key, bootstrapped) VALUES ('%s', ?)";
        QueryProcessor.executeInternal(String.format(req, LOCAL, LOCAL), state.name());
        SystemKeyspace.forceBlockingFlush(LOCAL);
    }

    public static boolean isIndexBuilt(String keyspaceName, String indexName) {
        ColumnFamilyStore cfs = Keyspace.open(NAME).getColumnFamilyStore(BUILT_INDEXES);
        QueryFilter filter = QueryFilter.getNamesFilter(SystemKeyspace.decorate(ByteBufferUtil.bytes(keyspaceName)), BUILT_INDEXES, FBUtilities.singleton(cfs.getComparator().makeCellName(indexName), cfs.getComparator()), System.currentTimeMillis());
        return ColumnFamilyStore.removeDeleted(cfs.getColumnFamily(filter), Integer.MAX_VALUE) != null;
    }

    public static void setIndexBuilt(String keyspaceName, String indexName) {
        ArrayBackedSortedColumns cf = ArrayBackedSortedColumns.factory.create(NAME, BUILT_INDEXES);
        ((ColumnFamily)cf).addColumn(new BufferCell(cf.getComparator().makeCellName(indexName), ByteBufferUtil.EMPTY_BYTE_BUFFER, FBUtilities.timestampMicros()));
        new Mutation(NAME, ByteBufferUtil.bytes(keyspaceName), cf).apply();
        SystemKeyspace.forceBlockingFlush(BUILT_INDEXES);
    }

    public static void setIndexRemoved(String keyspaceName, String indexName) {
        Mutation mutation = new Mutation(NAME, ByteBufferUtil.bytes(keyspaceName));
        mutation.delete(BUILT_INDEXES, SystemKeyspace.BuiltIndexes.comparator.makeCellName(indexName), FBUtilities.timestampMicros());
        mutation.apply();
        SystemKeyspace.forceBlockingFlush(BUILT_INDEXES);
    }

    public static UUID getLocalHostId() {
        String req = "SELECT host_id FROM system.%s WHERE key='%s'";
        UntypedResultSet result = QueryProcessor.executeInternal(String.format(req, LOCAL, LOCAL), new Object[0]);
        if (!result.isEmpty() && result.one().has("host_id")) {
            return result.one().getUUID("host_id");
        }
        UUID hostId = UUID.randomUUID();
        logger.warn("No host ID found, created {} (Note: This should happen exactly once per node).", (Object)hostId);
        return SystemKeyspace.setLocalHostId(hostId);
    }

    public static UUID setLocalHostId(UUID hostId) {
        String req = "INSERT INTO system.%s (key, host_id) VALUES ('%s', ?)";
        QueryProcessor.executeInternal(String.format(req, LOCAL, LOCAL), hostId);
        return hostId;
    }

    public static PaxosState loadPaxosState(ByteBuffer key, CFMetaData metadata) {
        String req = "SELECT * FROM system.%s WHERE row_key = ? AND cf_id = ?";
        UntypedResultSet results = QueryProcessor.executeInternal(String.format(req, PAXOS), key, metadata.cfId);
        if (results.isEmpty()) {
            return new PaxosState(key, metadata);
        }
        UntypedResultSet.Row row = results.one();
        Commit promised = row.has("in_progress_ballot") ? new Commit(key, row.getUUID("in_progress_ballot"), ArrayBackedSortedColumns.factory.create(metadata)) : Commit.emptyCommit(key, metadata);
        Commit accepted = row.has("proposal") ? new Commit(key, row.getUUID("proposal_ballot"), ColumnFamily.fromBytes(row.getBytes("proposal"))) : Commit.emptyCommit(key, metadata);
        Commit mostRecent = row.has("most_recent_commit") ? new Commit(key, row.getUUID("most_recent_commit_at"), ColumnFamily.fromBytes(row.getBytes("most_recent_commit"))) : Commit.emptyCommit(key, metadata);
        return new PaxosState(promised, accepted, mostRecent);
    }

    public static void savePaxosPromise(Commit promise) {
        String req = "UPDATE system.%s USING TIMESTAMP ? AND TTL ? SET in_progress_ballot = ? WHERE row_key = ? AND cf_id = ?";
        QueryProcessor.executeInternal(String.format(req, PAXOS), UUIDGen.microsTimestamp(promise.ballot), SystemKeyspace.paxosTtl(promise.update.metadata), promise.ballot, promise.key, promise.update.id());
    }

    public static void savePaxosProposal(Commit proposal) {
        QueryProcessor.executeInternal(String.format("UPDATE system.%s USING TIMESTAMP ? AND TTL ? SET proposal_ballot = ?, proposal = ? WHERE row_key = ? AND cf_id = ?", PAXOS), UUIDGen.microsTimestamp(proposal.ballot), SystemKeyspace.paxosTtl(proposal.update.metadata), proposal.ballot, proposal.update.toBytes(), proposal.key, proposal.update.id());
    }

    private static int paxosTtl(CFMetaData metadata) {
        return Math.max(10800, metadata.getGcGraceSeconds());
    }

    public static void savePaxosCommit(Commit commit) {
        String cql = "UPDATE system.%s USING TIMESTAMP ? AND TTL ? SET proposal_ballot = null, proposal = null, most_recent_commit_at = ?, most_recent_commit = ? WHERE row_key = ? AND cf_id = ?";
        QueryProcessor.executeInternal(String.format(cql, PAXOS), UUIDGen.microsTimestamp(commit.ballot), SystemKeyspace.paxosTtl(commit.update.metadata), commit.ballot, commit.update.toBytes(), commit.key, commit.update.id());
    }

    public static RestorableMeter getSSTableReadMeter(String keyspace, String table, int generation) {
        String cql = "SELECT * FROM system.%s WHERE keyspace_name=? and columnfamily_name=? and generation=?";
        UntypedResultSet results = QueryProcessor.executeInternal(String.format(cql, SSTABLE_ACTIVITY), keyspace, table, generation);
        if (results.isEmpty()) {
            return new RestorableMeter();
        }
        UntypedResultSet.Row row = results.one();
        double m15rate = row.getDouble("rate_15m");
        double m120rate = row.getDouble("rate_120m");
        return new RestorableMeter(m15rate, m120rate);
    }

    public static void persistSSTableReadMeter(String keyspace, String table, int generation, RestorableMeter meter) {
        String cql = "INSERT INTO system.%s (keyspace_name, columnfamily_name, generation, rate_15m, rate_120m) VALUES (?, ?, ?, ?, ?) USING TTL 864000";
        QueryProcessor.executeInternal(String.format(cql, SSTABLE_ACTIVITY), keyspace, table, generation, meter.fifteenMinuteRate(), meter.twoHourRate());
    }

    public static void clearSSTableReadMeter(String keyspace, String table, int generation) {
        String cql = "DELETE FROM system.%s WHERE keyspace_name=? AND columnfamily_name=? and generation=?";
        QueryProcessor.executeInternal(String.format(cql, SSTABLE_ACTIVITY), keyspace, table, generation);
    }

    public static void updateSizeEstimates(String keyspace, String table, Map<Range<Token>, Pair<Long, Long>> estimates) {
        long timestamp = FBUtilities.timestampMicros();
        Mutation mutation = new Mutation(NAME, UTF8Type.instance.decompose(keyspace));
        mutation.deleteRange(SIZE_ESTIMATES, SystemKeyspace.SizeEstimates.comparator.make(table).start(), SystemKeyspace.SizeEstimates.comparator.make(table).end(), timestamp - 1L);
        ColumnFamily cells = mutation.addOrGet(SizeEstimates);
        for (Map.Entry<Range<Token>, Pair<Long, Long>> entry : estimates.entrySet()) {
            Range<Token> range = entry.getKey();
            Pair<Long, Long> values = entry.getValue();
            Composite prefix = SystemKeyspace.SizeEstimates.comparator.make(table, ((Token)range.left).toString(), ((Token)range.right).toString());
            CFRowAdder adder = new CFRowAdder(cells, prefix, timestamp);
            adder.add("partitions_count", values.left).add("mean_partition_size", values.right);
        }
        mutation.apply();
    }

    public static void clearSizeEstimates(String keyspace, String table) {
        String cql = String.format("DELETE FROM %s.%s WHERE keyspace_name = ? AND table_name = ?", NAME, SIZE_ESTIMATES);
        QueryProcessor.executeInternal(cql, keyspace, table);
    }

    public static synchronized void updateAvailableRanges(String keyspace, Collection<Range<Token>> completedRanges) {
        String cql = "UPDATE system.%s SET ranges = ranges + ? WHERE keyspace_name = ?";
        HashSet<ByteBuffer> rangesToUpdate = new HashSet<ByteBuffer>(completedRanges.size());
        for (Range<Token> range : completedRanges) {
            rangesToUpdate.add(SystemKeyspace.rangeToBytes(range));
        }
        QueryProcessor.executeInternal(String.format(cql, AVAILABLE_RANGES), rangesToUpdate, keyspace);
    }

    public static synchronized Set<Range<Token>> getAvailableRanges(String keyspace, IPartitioner partitioner) {
        HashSet<Range<Token>> result = new HashSet<Range<Token>>();
        String query = "SELECT * FROM system.%s WHERE keyspace_name=?";
        UntypedResultSet rs = QueryProcessor.executeInternal(String.format(query, AVAILABLE_RANGES), keyspace);
        for (UntypedResultSet.Row row : rs) {
            Set<ByteBuffer> rawRanges = row.getSet("ranges", BytesType.instance);
            for (ByteBuffer rawRange : rawRanges) {
                result.add(SystemKeyspace.byteBufferToRange(rawRange, partitioner));
            }
        }
        return ImmutableSet.copyOf(result);
    }

    public static void resetAvailableRanges() {
        ColumnFamilyStore availableRanges = Keyspace.open(NAME).getColumnFamilyStore(AVAILABLE_RANGES);
        availableRanges.truncateBlocking();
    }

    public static void snapshotOnVersionChange() throws IOException {
        String previous = SystemKeyspace.getPreviousVersionString();
        String next = FBUtilities.getReleaseVersionString();
        if (!previous.equals(NULL_VERSION.toString()) && !previous.equals(next)) {
            logger.info("Detected version upgrade from {} to {}, snapshotting system keyspace", (Object)previous, (Object)next);
            String snapshotName = Keyspace.getTimestampedSnapshotName(String.format("upgrade-%s-%s", previous, next));
            Keyspace systemKs = Keyspace.open(NAME);
            systemKs.snapshot(snapshotName, null);
        }
    }

    private static String getPreviousVersionString() {
        String req = "SELECT release_version FROM system.%s WHERE key='%s'";
        UntypedResultSet result = QueryProcessor.executeInternal(String.format(req, LOCAL, LOCAL), new Object[0]);
        if (result.isEmpty() || !result.one().has("release_version")) {
            for (File dataDirectory : Directories.getKSChildDirectories(NAME)) {
                if (!dataDirectory.getName().equals("Versions") || dataDirectory.listFiles().length <= 0) continue;
                logger.debug("Found unreadable versions info in pre 1.2 system.Versions table");
                return UNREADABLE_VERSION.toString();
            }
            return NULL_VERSION.toString();
        }
        return result.one().getString("release_version");
    }

    private static ByteBuffer rangeToBytes(Range<Token> range) {
        try {
            DataOutputBuffer out = new DataOutputBuffer();
            Range.tokenSerializer.serialize(range, out, 9);
            return out.buffer();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    private static Range<Token> byteBufferToRange(ByteBuffer rawRange, IPartitioner partitioner) {
        try {
            return (Range)Range.tokenSerializer.deserialize((DataInput)ByteStreams.newDataInput((byte[])ByteBufferUtil.getArray(rawRange)), partitioner, 9);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public static enum BootstrapState {
        NEEDS_BOOTSTRAP,
        COMPLETED,
        IN_PROGRESS;

    }
}

