/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.cql3.AssignmentTestable;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Lists;
import org.apache.cassandra.cql3.Maps;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Sets;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.Terms;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.functions.FromJsonFct;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.Functions;
import org.apache.cassandra.cql3.functions.ScalarFunction;
import org.apache.cassandra.cql3.statements.RequestValidations;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;

public class FunctionCall
extends Term.NonTerminal {
    private final ScalarFunction fun;
    private final List<Term> terms;

    private FunctionCall(ScalarFunction fun, List<Term> terms) {
        this.fun = fun;
        this.terms = terms;
    }

    @Override
    public Iterable<Function> getFunctions() {
        return Iterables.concat(Terms.getFunctions(this.terms), this.fun.getFunctions());
    }

    @Override
    public void collectMarkerSpecification(VariableSpecifications boundNames) {
        for (Term t : this.terms) {
            t.collectMarkerSpecification(boundNames);
        }
    }

    @Override
    public Term.Terminal bind(QueryOptions options) throws InvalidRequestException {
        return FunctionCall.makeTerminal(this.fun, this.bindAndGet(options), options.getProtocolVersion());
    }

    @Override
    public ByteBuffer bindAndGet(QueryOptions options) throws InvalidRequestException {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(this.terms.size());
        for (Term t : this.terms) {
            ByteBuffer functionArg = t.bindAndGet(options);
            RequestValidations.checkBindValueSet(functionArg, "Invalid unset value for argument in call to function %s", this.fun.name().name);
            buffers.add(functionArg);
        }
        return FunctionCall.executeInternal(options.getProtocolVersion(), this.fun, buffers);
    }

    private static ByteBuffer executeInternal(int protocolVersion, ScalarFunction fun, List<ByteBuffer> params) throws InvalidRequestException {
        ByteBuffer result = fun.execute(protocolVersion, params);
        try {
            if (result != null) {
                fun.returnType().validate(result);
            }
            return result;
        }
        catch (MarshalException e) {
            throw new RuntimeException(String.format("Return of function %s (%s) is not a valid value for its declared return type %s", fun, ByteBufferUtil.bytesToHex(result), fun.returnType().asCQL3Type()), e);
        }
    }

    @Override
    public boolean containsBindMarker() {
        for (Term t : this.terms) {
            if (!t.containsBindMarker()) continue;
            return true;
        }
        return false;
    }

    private static Term.Terminal makeTerminal(Function fun, ByteBuffer result, int version) throws InvalidRequestException {
        if (!(fun.returnType() instanceof CollectionType)) {
            return new Constants.Value(result);
        }
        switch (((CollectionType)fun.returnType()).kind) {
            case LIST: {
                return Lists.Value.fromSerialized(result, (ListType)fun.returnType(), version);
            }
            case SET: {
                return Sets.Value.fromSerialized(result, (SetType)fun.returnType(), version);
            }
            case MAP: {
                return Maps.Value.fromSerialized(result, (MapType)fun.returnType(), version);
            }
        }
        throw new AssertionError();
    }

    public static class Raw
    implements Term.Raw {
        private FunctionName name;
        private final List<Term.Raw> terms;

        public Raw(FunctionName name, List<Term.Raw> terms) {
            this.name = name;
            this.terms = terms;
        }

        @Override
        public Term prepare(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
            Function fun = Functions.get(keyspace, this.name, this.terms, receiver.ksName, receiver.cfName, receiver.type);
            if (fun == null) {
                throw new InvalidRequestException(String.format("Unknown function %s called", this.name));
            }
            if (fun.isAggregate()) {
                throw new InvalidRequestException("Aggregation function are not supported in the where clause");
            }
            ScalarFunction scalarFun = (ScalarFunction)fun;
            if (!receiver.type.isValueCompatibleWith(scalarFun.returnType())) {
                throw new InvalidRequestException(String.format("Type error: cannot assign result of function %s (type %s) to %s (type %s)", scalarFun.name(), scalarFun.returnType().asCQL3Type(), receiver.name, receiver.type.asCQL3Type()));
            }
            if (fun.argTypes().size() != this.terms.size()) {
                throw new InvalidRequestException(String.format("Incorrect number of arguments specified for function %s (expected %d, found %d)", fun, fun.argTypes().size(), this.terms.size()));
            }
            ArrayList<Term> parameters = new ArrayList<Term>(this.terms.size());
            for (int i = 0; i < this.terms.size(); ++i) {
                Term t = this.terms.get(i).prepare(keyspace, Functions.makeArgSpec(receiver.ksName, receiver.cfName, scalarFun, i));
                parameters.add(t);
            }
            return new FunctionCall(scalarFun, parameters);
        }

        @Override
        public AssignmentTestable.TestResult testAssignment(String keyspace, ColumnSpecification receiver) {
            try {
                Function fun = Functions.get(keyspace, this.name, this.terms, receiver.ksName, receiver.cfName, receiver.type);
                if (fun != null && fun.name().equals(FromJsonFct.NAME)) {
                    return AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
                }
                if (fun != null && receiver.type.equals(fun.returnType())) {
                    return AssignmentTestable.TestResult.EXACT_MATCH;
                }
                if (fun == null || receiver.type.isValueCompatibleWith(fun.returnType())) {
                    return AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
                }
                return AssignmentTestable.TestResult.NOT_ASSIGNABLE;
            }
            catch (InvalidRequestException e) {
                return AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.name).append("(");
            for (int i = 0; i < this.terms.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.terms.get(i));
            }
            return sb.append(")").toString();
        }
    }
}

