/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.UUID;
import org.apache.cassandra.cache.CacheKey;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.ObjectSizes;

public class RowCacheKey
implements CacheKey,
Comparable<RowCacheKey> {
    public final UUID cfId;
    public final byte[] key;
    private static final long EMPTY_SIZE = ObjectSizes.measure(new RowCacheKey(null, ByteBufferUtil.EMPTY_BYTE_BUFFER));

    public RowCacheKey(UUID cfId, byte[] key) {
        this.cfId = cfId;
        this.key = key;
    }

    public RowCacheKey(UUID cfId, DecoratedKey key) {
        this(cfId, key.getKey());
    }

    public RowCacheKey(UUID cfId, ByteBuffer key) {
        this.cfId = cfId;
        this.key = ByteBufferUtil.getArray(key);
        assert (this.key != null);
    }

    @Override
    public UUID getCFId() {
        return this.cfId;
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE + ObjectSizes.sizeOfArray(this.key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowCacheKey that = (RowCacheKey)o;
        return this.cfId.equals(that.cfId) && Arrays.equals(this.key, that.key);
    }

    public int hashCode() {
        int result = this.cfId.hashCode();
        result = 31 * result + (this.key != null ? Arrays.hashCode(this.key) : 0);
        return result;
    }

    @Override
    public int compareTo(RowCacheKey otherKey) {
        return this.cfId.compareTo(otherKey.cfId) < 0 ? -1 : (this.cfId.equals(otherKey.cfId) ? FBUtilities.compareUnsigned(this.key, otherKey.key, 0, 0, this.key.length, otherKey.key.length) : 1);
    }

    public String toString() {
        return String.format("RowCacheKey(cfId:%s, key:%s)", this.cfId, Arrays.toString(this.key));
    }
}

