/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.apache.cassandra.io.util.DataOutputStreamPlus;

public class DataOutputStreamAndChannel
extends DataOutputStreamPlus {
    private final WritableByteChannel channel;

    public DataOutputStreamAndChannel(OutputStream os, WritableByteChannel channel) {
        super(os);
        this.channel = channel;
    }

    public DataOutputStreamAndChannel(WritableByteChannel channel) {
        this(Channels.newOutputStream(channel), channel);
    }

    public DataOutputStreamAndChannel(FileOutputStream fos) {
        this(fos, fos.getChannel());
    }

    @Override
    public void write(ByteBuffer buffer) throws IOException {
        buffer = buffer.duplicate();
        while (buffer.remaining() > 0) {
            this.channel.write(buffer);
        }
    }

    public WritableByteChannel getChannel() {
        return this.channel;
    }
}

