/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.utils.BloomFilter;
import org.apache.cassandra.utils.BloomFilterSerializer;
import org.apache.cassandra.utils.IFilter;
import org.apache.cassandra.utils.MurmurHash;
import org.apache.cassandra.utils.obs.IBitSet;

public class Murmur3BloomFilter
extends BloomFilter {
    public static final Murmur3BloomFilterSerializer serializer = new Murmur3BloomFilterSerializer();

    public Murmur3BloomFilter(int hashCount, IBitSet bs) {
        super(hashCount, bs);
    }

    protected Murmur3BloomFilter(Murmur3BloomFilter copy) {
        super(copy);
    }

    @Override
    public long serializedSize() {
        return serializer.serializedSize(this, TypeSizes.NATIVE);
    }

    @Override
    public IFilter sharedCopy() {
        return new Murmur3BloomFilter(this);
    }

    @Override
    public long offHeapSize() {
        return this.bitset.offHeapSize();
    }

    @Override
    protected void hash(ByteBuffer b, int position, int remaining, long seed, long[] result) {
        MurmurHash.hash3_x64_128(b, b.position(), b.remaining(), seed, result);
    }

    public static class Murmur3BloomFilterSerializer
    extends BloomFilterSerializer {
        @Override
        protected BloomFilter createFilter(int hashes, IBitSet bs) {
            return new Murmur3BloomFilter(hashes, bs);
        }
    }
}

