/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.io.DataInput;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.ExcludingBounds;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.IncludingExcludingBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.RingPosition;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.Pair;

public abstract class AbstractBounds<T extends RingPosition<T>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final AbstractBoundsSerializer serializer = new AbstractBoundsSerializer();
    public final T left;
    public final T right;
    protected final transient IPartitioner partitioner;

    public AbstractBounds(T left, T right, IPartitioner partitioner) {
        this.left = left;
        this.right = right;
        this.partitioner = partitioner;
    }

    public abstract Pair<AbstractBounds<T>, AbstractBounds<T>> split(T var1);

    public abstract boolean inclusiveLeft();

    public abstract boolean inclusiveRight();

    public int hashCode() {
        return 31 * this.left.hashCode() + this.right.hashCode();
    }

    public boolean intersects(Iterable<Range<T>> ranges) {
        for (Range<T> range2 : ranges) {
            if (!range2.intersects(this)) continue;
            return true;
        }
        return false;
    }

    public abstract boolean contains(T var1);

    public abstract List<? extends AbstractBounds<T>> unwrap();

    public String getString(AbstractType<?> keyValidator) {
        return this.getOpeningString() + this.format(this.left, keyValidator) + ", " + this.format(this.right, keyValidator) + this.getClosingString();
    }

    private String format(T value, AbstractType<?> keyValidator) {
        if (value instanceof DecoratedKey) {
            return keyValidator.getString(((DecoratedKey)value).getKey());
        }
        return value.toString();
    }

    protected abstract String getOpeningString();

    protected abstract String getClosingString();

    public abstract AbstractBounds<RowPosition> toRowBounds();

    public abstract AbstractBounds<Token> toTokenBounds();

    public abstract AbstractBounds<T> withNewRight(T var1);

    public static <T extends RingPosition<T>> AbstractBounds<T> bounds(Boundary<T> min, Boundary<T> max) {
        return AbstractBounds.bounds(min.boundary, min.inclusive, max.boundary, max.inclusive);
    }

    public static <T extends RingPosition<T>> AbstractBounds<T> bounds(T min, boolean inclusiveMin, T max, boolean inclusiveMax) {
        if (inclusiveMin && inclusiveMax) {
            return new Bounds<T>(min, max);
        }
        if (inclusiveMax) {
            return new Range<T>(min, max);
        }
        if (inclusiveMin) {
            return new IncludingExcludingBounds<T>(min, max);
        }
        return new ExcludingBounds<T>(min, max);
    }

    public Boundary<T> leftBoundary() {
        return new Boundary<T>(this.left, this.inclusiveLeft());
    }

    public Boundary<T> rightBoundary() {
        return new Boundary<T>(this.right, this.inclusiveRight());
    }

    public static <T extends RingPosition<T>> boolean isEmpty(Boundary<T> left, Boundary<T> right) {
        int c = left.boundary.compareTo(right.boundary);
        return c > 0 || c == 0 && (!left.inclusive || !right.inclusive);
    }

    public static <T extends RingPosition<T>> Boundary<T> minRight(Boundary<T> right1, T right2, boolean isInclusiveRight2) {
        return AbstractBounds.minRight(right1, new Boundary<T>(right2, isInclusiveRight2));
    }

    public static <T extends RingPosition<T>> Boundary<T> minRight(Boundary<T> right1, Boundary<T> right2) {
        int c = right1.boundary.compareTo(right2.boundary);
        if (c != 0) {
            return c < 0 ? right1 : right2;
        }
        return right2.inclusive ? right1 : right2;
    }

    public static <T extends RingPosition<T>> Boundary<T> maxLeft(Boundary<T> left1, T left2, boolean isInclusiveLeft2) {
        return AbstractBounds.maxLeft(left1, new Boundary<T>(left2, isInclusiveLeft2));
    }

    public static <T extends RingPosition<T>> Boundary<T> maxLeft(Boundary<T> left1, Boundary<T> left2) {
        int c = left1.boundary.compareTo(left2.boundary);
        if (c != 0) {
            return c > 0 ? left1 : left2;
        }
        return left2.inclusive ? left1 : left2;
    }

    public static class Boundary<T extends RingPosition<T>> {
        public final T boundary;
        public final boolean inclusive;

        public Boundary(T boundary, boolean inclusive) {
            this.boundary = boundary;
            this.inclusive = inclusive;
        }
    }

    public static class AbstractBoundsSerializer
    implements IVersionedSerializer<AbstractBounds<?>> {
        @Override
        public void serialize(AbstractBounds<?> range, DataOutputPlus out, int version) throws IOException {
            out.writeInt(this.kindInt(range));
            if (range.left instanceof Token) {
                Token.serializer.serialize((Token)range.left, out);
                Token.serializer.serialize((Token)range.right, out);
            } else {
                RowPosition.serializer.serialize((RowPosition)range.left, out);
                RowPosition.serializer.serialize((RowPosition)range.right, out);
            }
        }

        private int kindInt(AbstractBounds<?> ab) {
            int kind;
            int n = kind = ab instanceof Range ? Type.RANGE.ordinal() : Type.BOUNDS.ordinal();
            if (!(ab.left instanceof Token)) {
                kind = -(kind + 1);
            }
            return kind;
        }

        @Override
        public AbstractBounds<?> deserialize(DataInput in, int version) throws IOException {
            RingPosition<Token> right;
            RingPosition<Token> left;
            boolean isToken;
            int kind = in.readInt();
            boolean bl = isToken = kind >= 0;
            if (!isToken) {
                kind = -(kind + 1);
            }
            if (isToken) {
                left = Token.serializer.deserialize(in);
                right = Token.serializer.deserialize(in);
            } else {
                left = RowPosition.serializer.deserialize(in);
                right = RowPosition.serializer.deserialize(in);
            }
            if (kind == Type.RANGE.ordinal()) {
                return new Range<Token>((Token)left, (Token)right);
            }
            return new Bounds<Token>((Token)left, (Token)right);
        }

        @Override
        public long serializedSize(AbstractBounds<?> ab, int version) {
            int size = TypeSizes.NATIVE.sizeof(this.kindInt(ab));
            if (ab.left instanceof Token) {
                size = (int)((long)size + Token.serializer.serializedSize((Token)ab.left, TypeSizes.NATIVE));
                size = (int)((long)size + Token.serializer.serializedSize((Token)ab.right, TypeSizes.NATIVE));
            } else {
                size = (int)((long)size + RowPosition.serializer.serializedSize((RowPosition)ab.left, TypeSizes.NATIVE));
                size = (int)((long)size + RowPosition.serializer.serializedSize((RowPosition)ab.right, TypeSizes.NATIVE));
            }
            return size;
        }
    }

    private static enum Type {
        RANGE,
        BOUNDS;

    }
}

