/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql.AbstractModification;
import org.apache.cassandra.cql.Attributes;
import org.apache.cassandra.cql.QueryProcessor;
import org.apache.cassandra.cql.Term;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.thrift.ThriftClientState;
import org.apache.cassandra.thrift.ThriftValidation;

public class DeleteStatement
extends AbstractModification {
    private List<Term> columns;
    private List<Term> keys;

    public DeleteStatement(List<Term> columns, String keyspace, String columnFamily, String keyName, List<Term> keys, Attributes attrs) {
        super(keyspace, columnFamily, keyName, attrs);
        this.columns = columns;
        this.keys = keys;
    }

    public List<Term> getColumns() {
        return this.columns;
    }

    public List<Term> getKeys() {
        return this.keys;
    }

    @Override
    public List<IMutation> prepareRowMutations(String keyspace, ThriftClientState clientState, List<ByteBuffer> variables) throws InvalidRequestException, UnauthorizedException {
        return this.prepareRowMutations(keyspace, clientState, null, variables);
    }

    @Override
    public List<IMutation> prepareRowMutations(String keyspace, ThriftClientState clientState, Long timestamp, List<ByteBuffer> variables) throws InvalidRequestException, UnauthorizedException {
        CFMetaData metadata = ThriftValidation.validateColumnFamily(keyspace, this.columnFamily);
        clientState.hasColumnFamilyAccess(keyspace, this.columnFamily, Permission.MODIFY);
        AbstractType<?> keyType = Schema.instance.getCFMetaData(keyspace, this.columnFamily).getKeyValidator();
        ArrayList<IMutation> mutations = new ArrayList<IMutation>(this.keys.size());
        for (Term key : this.keys) {
            mutations.add(this.mutationForKey(key.getByteBuffer(keyType, variables), keyspace, timestamp, clientState, variables, metadata));
        }
        return mutations;
    }

    public Mutation mutationForKey(ByteBuffer key, String keyspace, Long timestamp, ThriftClientState clientState, List<ByteBuffer> variables, CFMetaData metadata) throws InvalidRequestException {
        Mutation mutation = new Mutation(keyspace, key);
        QueryProcessor.validateKeyAlias(metadata, this.keyName);
        if (this.columns.size() < 1) {
            mutation.delete(this.columnFamily, timestamp == null ? this.getTimestamp(clientState) : timestamp.longValue());
        } else {
            AbstractType<?> at = metadata.comparator.asAbstractType();
            for (Term column : this.columns) {
                CellName columnName = metadata.comparator.cellFromByteBuffer(column.getByteBuffer(at, variables));
                QueryProcessor.validateColumnName(columnName);
                mutation.delete(this.columnFamily, columnName, timestamp == null ? this.getTimestamp(clientState) : timestamp.longValue());
            }
        }
        return mutation;
    }

    public String toString() {
        return String.format("DeleteStatement(columns=%s, keyspace=%s, columnFamily=%s, consistency=%s keys=%s)", new Object[]{this.columns, this.keyspace, this.columnFamily, this.cLevel, this.keys});
    }
}

