/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.nio.ByteBuffer;
import org.apache.cassandra.dht.AbstractByteOrderedPartitioner;
import org.apache.cassandra.dht.BytesToken;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.utils.ObjectSizes;

public class ByteOrderedPartitioner
extends AbstractByteOrderedPartitioner {
    private static final long EMPTY_SIZE = ObjectSizes.measure(MINIMUM);

    @Override
    public BytesToken getToken(ByteBuffer key) {
        if (key.remaining() == 0) {
            return MINIMUM;
        }
        return new BytesToken(key);
    }

    @Override
    public long getHeapSizeOf(Token token) {
        return EMPTY_SIZE + ObjectSizes.sizeOfArray(((BytesToken)token).token);
    }
}

