/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.File;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.util.DataIntegrityMetadata;
import org.apache.cassandra.io.util.SequentialWriter;

public class ChecksummedSequentialWriter
extends SequentialWriter {
    private final SequentialWriter crcWriter;
    private final DataIntegrityMetadata.ChecksumWriter crcMetadata;

    public ChecksummedSequentialWriter(File file, int bufferSize, File crcPath) {
        super(file, bufferSize);
        this.crcWriter = new SequentialWriter(crcPath, 8192);
        this.crcMetadata = new DataIntegrityMetadata.ChecksumWriter(this.crcWriter.stream);
        this.crcMetadata.writeChunkSize(this.buffer.length);
    }

    @Override
    protected void flushData() {
        super.flushData();
        this.crcMetadata.append(this.buffer, 0, this.validBufferBytes, false);
    }

    @Override
    public void writeFullChecksum(Descriptor descriptor) {
        this.crcMetadata.writeFullChecksum(descriptor);
    }

    @Override
    public void close() {
        super.close();
        this.crcWriter.close();
    }

    @Override
    public void abort() {
        super.abort();
        this.crcWriter.abort();
    }
}

