/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import com.google.common.collect.ArrayListMultimap;
import java.util.List;
import org.apache.cassandra.cql3.AssignementTestable;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.functions.AbstractFunction;
import org.apache.cassandra.cql3.functions.BytesConversionFcts;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.TimeuuidFcts;
import org.apache.cassandra.cql3.functions.TokenFct;
import org.apache.cassandra.cql3.functions.UuidFcts;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;

public abstract class Functions {
    private static final ArrayListMultimap<String, Function.Factory> declared = ArrayListMultimap.create();

    private Functions() {
    }

    public static AbstractType<?> getReturnType(String functionName, String ksName, String cfName) {
        List factories = declared.get((Object)functionName.toLowerCase());
        return factories.isEmpty() ? null : ((Function.Factory)factories.get(0)).create(ksName, cfName).returnType();
    }

    public static ColumnSpecification makeArgSpec(ColumnSpecification receiver, Function fun, int i) {
        return new ColumnSpecification(receiver.ksName, receiver.cfName, new ColumnIdentifier("arg" + i + "(" + fun.name() + ")", true), fun.argsType().get(i));
    }

    public static Function get(String keyspace, String name, List<? extends AssignementTestable> providedArgs, ColumnSpecification receiver) throws InvalidRequestException {
        List factories = declared.get((Object)name.toLowerCase());
        if (factories.isEmpty()) {
            throw new InvalidRequestException(String.format("Unknown CQL3 function %s called", name));
        }
        if (factories.size() == 1) {
            Function fun = ((Function.Factory)factories.get(0)).create(receiver.ksName, receiver.cfName);
            Functions.validateTypes(keyspace, fun, providedArgs, receiver);
            return fun;
        }
        Function candidate = null;
        for (Function.Factory factory : factories) {
            Function toTest = factory.create(receiver.ksName, receiver.cfName);
            if (!Functions.isValidType(keyspace, toTest, providedArgs, receiver)) continue;
            if (candidate == null) {
                candidate = toTest;
                continue;
            }
            throw new InvalidRequestException(String.format("Ambiguous call to function %s (can match both type signature %s and %s): use type casts to disambiguate", name, Functions.signature(candidate), Functions.signature(toTest)));
        }
        if (candidate == null) {
            throw new InvalidRequestException(String.format("Invalid call to function %s, none of its type signature matches (known type signatures: %s)", name, Functions.signatures(factories, receiver)));
        }
        return candidate;
    }

    private static void validateTypes(String keyspace, Function fun, List<? extends AssignementTestable> providedArgs, ColumnSpecification receiver) throws InvalidRequestException {
        if (!receiver.type.isValueCompatibleWith(fun.returnType())) {
            throw new InvalidRequestException(String.format("Type error: cannot assign result of function %s (type %s) to %s (type %s)", fun.name(), fun.returnType().asCQL3Type(), receiver, receiver.type.asCQL3Type()));
        }
        if (providedArgs.size() != fun.argsType().size()) {
            throw new InvalidRequestException(String.format("Invalid number of arguments in call to function %s: %d required but %d provided", fun.name(), fun.argsType().size(), providedArgs.size()));
        }
        for (int i = 0; i < providedArgs.size(); ++i) {
            ColumnSpecification expected;
            AssignementTestable provided = providedArgs.get(i);
            if (provided == null || provided.isAssignableTo(keyspace, expected = Functions.makeArgSpec(receiver, fun, i))) continue;
            throw new InvalidRequestException(String.format("Type error: %s cannot be passed as argument %d of function %s of type %s", provided, i, fun.name(), expected.type.asCQL3Type()));
        }
    }

    private static boolean isValidType(String keyspace, Function fun, List<? extends AssignementTestable> providedArgs, ColumnSpecification receiver) throws InvalidRequestException {
        if (!receiver.type.isValueCompatibleWith(fun.returnType())) {
            return false;
        }
        if (providedArgs.size() != fun.argsType().size()) {
            return false;
        }
        for (int i = 0; i < providedArgs.size(); ++i) {
            ColumnSpecification expected;
            AssignementTestable provided = providedArgs.get(i);
            if (provided == null || provided.isAssignableTo(keyspace, expected = Functions.makeArgSpec(receiver, fun, i))) continue;
            return false;
        }
        return true;
    }

    private static String signature(Function fun) {
        List<AbstractType<?>> args = fun.argsType();
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int i = 0; i < args.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(args.get(i).asCQL3Type());
        }
        sb.append(") -> ");
        sb.append(fun.returnType().asCQL3Type());
        return sb.toString();
    }

    private static String signatures(List<Function.Factory> factories, ColumnSpecification receiver) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < factories.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(Functions.signature(factories.get(i).create(receiver.ksName, receiver.cfName)));
        }
        return sb.toString();
    }

    static {
        declared.put((Object)"token", (Object)TokenFct.factory);
        declared.put((Object)"now", (Object)AbstractFunction.factory(TimeuuidFcts.nowFct));
        declared.put((Object)"mintimeuuid", (Object)AbstractFunction.factory(TimeuuidFcts.minTimeuuidFct));
        declared.put((Object)"maxtimeuuid", (Object)AbstractFunction.factory(TimeuuidFcts.maxTimeuuidFct));
        declared.put((Object)"dateof", (Object)AbstractFunction.factory(TimeuuidFcts.dateOfFct));
        declared.put((Object)"unixtimestampof", (Object)AbstractFunction.factory(TimeuuidFcts.unixTimestampOfFct));
        declared.put((Object)"uuid", (Object)AbstractFunction.factory(UuidFcts.uuidFct));
        for (CQL3Type.Native type : CQL3Type.Native.values()) {
            if (type == CQL3Type.Native.VARCHAR || type == CQL3Type.Native.BLOB) continue;
            Function toBlob = BytesConversionFcts.makeToBlobFunction(type.getType());
            Function fromBlob = BytesConversionFcts.makeFromBlobFunction(type.getType());
            declared.put((Object)toBlob.name(), (Object)AbstractFunction.factory(toBlob));
            declared.put((Object)fromBlob.name(), (Object)AbstractFunction.factory(fromBlob));
        }
        declared.put((Object)"varcharasblob", (Object)AbstractFunction.factory(BytesConversionFcts.VarcharAsBlobFct));
        declared.put((Object)"blobasvarchar", (Object)AbstractFunction.factory(BytesConversionFcts.BlobAsVarcharFact));
    }
}

