/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.yammer.metrics.stats.ExponentiallyDecayingSample;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.locator.AbstractEndpointSnitch;
import org.apache.cassandra.locator.DynamicEndpointSnitchMBean;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.ILatencySubscriber;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;

public class DynamicEndpointSnitch
extends AbstractEndpointSnitch
implements ILatencySubscriber,
DynamicEndpointSnitchMBean {
    private static final double ALPHA = 0.75;
    private static final int WINDOW_SIZE = 100;
    private final int UPDATE_INTERVAL_IN_MS = DatabaseDescriptor.getDynamicUpdateInterval();
    private final int RESET_INTERVAL_IN_MS = DatabaseDescriptor.getDynamicResetInterval();
    private final double BADNESS_THRESHOLD = DatabaseDescriptor.getDynamicBadnessThreshold();
    private double RANGE_MERGING_PREFERENCE = 1.5;
    private String mbeanName = "org.apache.cassandra.db:type=DynamicEndpointSnitch";
    private boolean registered = false;
    private volatile HashMap<InetAddress, Double> scores = new HashMap();
    private final ConcurrentHashMap<InetAddress, ExponentiallyDecayingSample> samples = new ConcurrentHashMap();
    public final IEndpointSnitch subsnitch;

    public DynamicEndpointSnitch(IEndpointSnitch snitch) {
        this(snitch, null);
    }

    public DynamicEndpointSnitch(IEndpointSnitch snitch, String instance) {
        if (instance != null) {
            this.mbeanName = this.mbeanName + ",instance=" + instance;
        }
        this.subsnitch = snitch;
        Runnable update = new Runnable(){

            @Override
            public void run() {
                DynamicEndpointSnitch.this.updateScores();
            }
        };
        Runnable reset = new Runnable(){

            @Override
            public void run() {
                DynamicEndpointSnitch.this.reset();
            }
        };
        ScheduledExecutors.scheduledTasks.scheduleWithFixedDelay(update, this.UPDATE_INTERVAL_IN_MS, this.UPDATE_INTERVAL_IN_MS, TimeUnit.MILLISECONDS);
        ScheduledExecutors.scheduledTasks.scheduleWithFixedDelay(reset, this.RESET_INTERVAL_IN_MS, this.RESET_INTERVAL_IN_MS, TimeUnit.MILLISECONDS);
        this.registerMBean();
    }

    private void registerMBean() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(this, new ObjectName(this.mbeanName));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void unregisterMBean() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.unregisterMBean(new ObjectName(this.mbeanName));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void gossiperStarting() {
        this.subsnitch.gossiperStarting();
    }

    @Override
    public String getRack(InetAddress endpoint) {
        return this.subsnitch.getRack(endpoint);
    }

    @Override
    public String getDatacenter(InetAddress endpoint) {
        return this.subsnitch.getDatacenter(endpoint);
    }

    @Override
    public List<InetAddress> getSortedListByProximity(InetAddress address, Collection<InetAddress> addresses) {
        ArrayList<InetAddress> list = new ArrayList<InetAddress>(addresses);
        this.sortByProximity(address, list);
        return list;
    }

    @Override
    public void sortByProximity(InetAddress address, List<InetAddress> addresses) {
        assert (address.equals(FBUtilities.getBroadcastAddress()));
        if (this.BADNESS_THRESHOLD == 0.0) {
            this.sortByProximityWithScore(address, addresses);
        } else {
            this.sortByProximityWithBadness(address, addresses);
        }
    }

    private void sortByProximityWithScore(final InetAddress address, List<InetAddress> addresses) {
        final HashMap<InetAddress, Double> scores = this.scores;
        Collections.sort(addresses, new Comparator<InetAddress>(){

            @Override
            public int compare(InetAddress a1, InetAddress a2) {
                return DynamicEndpointSnitch.this.compareEndpoints(address, a1, a2, scores);
            }
        });
    }

    private void sortByProximityWithBadness(InetAddress address, List<InetAddress> addresses) {
        if (addresses.size() < 2) {
            return;
        }
        this.subsnitch.sortByProximity(address, addresses);
        HashMap<InetAddress, Double> scores = this.scores;
        ArrayList<Double> subsnitchOrderedScores = new ArrayList<Double>(addresses.size());
        for (InetAddress inet : addresses) {
            Double score = scores.get(inet);
            if (score == null) {
                return;
            }
            subsnitchOrderedScores.add(score);
        }
        ArrayList sortedScores = new ArrayList(subsnitchOrderedScores);
        Collections.sort(sortedScores);
        Iterator sortedScoreIterator = sortedScores.iterator();
        for (Double subsnitchScore : subsnitchOrderedScores) {
            if (!(subsnitchScore > (Double)sortedScoreIterator.next() * (1.0 + this.BADNESS_THRESHOLD))) continue;
            this.sortByProximityWithScore(address, addresses);
            return;
        }
    }

    private int compareEndpoints(InetAddress target, InetAddress a1, InetAddress a2, Map<InetAddress, Double> scores) {
        Double scored1 = scores.get(a1);
        Double scored2 = scores.get(a2);
        if (scored1 == null) {
            scored1 = 0.0;
            this.receiveTiming(a1, 0L);
        }
        if (scored2 == null) {
            scored2 = 0.0;
            this.receiveTiming(a2, 0L);
        }
        if (scored1.equals(scored2)) {
            return this.subsnitch.compareEndpoints(target, a1, a2);
        }
        if (scored1 < scored2) {
            return -1;
        }
        return 1;
    }

    @Override
    public int compareEndpoints(InetAddress target, InetAddress a1, InetAddress a2) {
        throw new UnsupportedOperationException("You shouldn't wrap the DynamicEndpointSnitch (within itself or otherwise)");
    }

    @Override
    public void receiveTiming(InetAddress host, long latency) {
        ExponentiallyDecayingSample maybeNewSample;
        ExponentiallyDecayingSample sample = this.samples.get(host);
        if (sample == null && (sample = this.samples.putIfAbsent(host, maybeNewSample = new ExponentiallyDecayingSample(100, 0.75))) == null) {
            sample = maybeNewSample;
        }
        sample.update(latency);
    }

    private void updateScores() {
        if (!StorageService.instance.isInitialized()) {
            return;
        }
        if (!this.registered && MessagingService.instance() != null) {
            MessagingService.instance().register(this);
            this.registered = true;
        }
        double maxLatency = 1.0;
        HashMap<InetAddress, Double> newScores = new HashMap<InetAddress, Double>();
        for (Map.Entry<InetAddress, ExponentiallyDecayingSample> entry : this.samples.entrySet()) {
            double mean = entry.getValue().getSnapshot().getMedian();
            if (!(mean > maxLatency)) continue;
            maxLatency = mean;
        }
        for (Map.Entry<InetAddress, ExponentiallyDecayingSample> entry : this.samples.entrySet()) {
            double score = entry.getValue().getSnapshot().getMedian() / maxLatency;
            newScores.put(entry.getKey(), score += StorageService.instance.getSeverity(entry.getKey()));
        }
        this.scores = newScores;
    }

    private void reset() {
        for (ExponentiallyDecayingSample sample : this.samples.values()) {
            sample.clear();
        }
    }

    @Override
    public Map<InetAddress, Double> getScores() {
        return this.scores;
    }

    @Override
    public int getUpdateInterval() {
        return this.UPDATE_INTERVAL_IN_MS;
    }

    @Override
    public int getResetInterval() {
        return this.RESET_INTERVAL_IN_MS;
    }

    @Override
    public double getBadnessThreshold() {
        return this.BADNESS_THRESHOLD;
    }

    @Override
    public String getSubsnitchClassName() {
        return this.subsnitch.getClass().getName();
    }

    @Override
    public List<Double> dumpTimings(String hostname) throws UnknownHostException {
        InetAddress host = InetAddress.getByName(hostname);
        ArrayList<Double> timings = new ArrayList<Double>();
        ExponentiallyDecayingSample sample = this.samples.get(host);
        if (sample != null) {
            for (double time : sample.getSnapshot().getValues()) {
                timings.add(time);
            }
        }
        return timings;
    }

    @Override
    public void setSeverity(double severity) {
        StorageService.instance.reportManualSeverity(severity);
    }

    @Override
    public double getSeverity() {
        return StorageService.instance.getSeverity(FBUtilities.getBroadcastAddress());
    }

    @Override
    public boolean isWorthMergingForRangeQuery(List<InetAddress> merged, List<InetAddress> l1, List<InetAddress> l2) {
        if (!this.subsnitch.isWorthMergingForRangeQuery(merged, l1, l2)) {
            return false;
        }
        if (l1.size() == 1 && l2.size() == 1 && l1.get(0).equals(l2.get(0))) {
            return true;
        }
        double maxMerged = this.maxScore(merged);
        double maxL1 = this.maxScore(l1);
        double maxL2 = this.maxScore(l2);
        if (maxMerged < 0.0 || maxL1 < 0.0 || maxL2 < 0.0) {
            return true;
        }
        return maxMerged <= (maxL1 + maxL2) * this.RANGE_MERGING_PREFERENCE;
    }

    private double maxScore(List<InetAddress> endpoints) {
        double maxScore = -1.0;
        for (InetAddress endpoint : endpoints) {
            Double score = this.scores.get(endpoint);
            if (score == null || !(score > maxScore)) continue;
            maxScore = score;
        }
        return maxScore;
    }
}

