/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.jpountz.lz4.LZ4Decompressor;
import net.jpountz.lz4.LZ4Factory;
import org.apache.cassandra.transport.CBUtil;
import org.apache.cassandra.transport.Frame;
import org.apache.cassandra.transport.ProtocolException;
import org.xerial.snappy.Snappy;
import org.xerial.snappy.SnappyError;

public interface FrameCompressor {
    public Frame compress(Frame var1) throws IOException;

    public Frame decompress(Frame var1) throws IOException;

    public static class LZ4Compressor
    implements FrameCompressor {
        public static final LZ4Compressor instance = new LZ4Compressor();
        private static final int INTEGER_BYTES = 4;
        private final net.jpountz.lz4.LZ4Compressor compressor;
        private final LZ4Decompressor decompressor;

        private LZ4Compressor() {
            LZ4Factory lz4Factory = LZ4Factory.fastestInstance();
            this.compressor = lz4Factory.fastCompressor();
            this.decompressor = lz4Factory.decompressor();
        }

        @Override
        public Frame compress(Frame frame) throws IOException {
            byte[] input = CBUtil.readRawBytes(frame.body);
            int maxCompressedLength = this.compressor.maxCompressedLength(input.length);
            ByteBuf outputBuf = CBUtil.allocator.heapBuffer(4 + maxCompressedLength);
            byte[] output = outputBuf.array();
            int outputOffset = outputBuf.arrayOffset();
            output[outputOffset + 0] = (byte)(input.length >>> 24);
            output[outputOffset + 1] = (byte)(input.length >>> 16);
            output[outputOffset + 2] = (byte)(input.length >>> 8);
            output[outputOffset + 3] = (byte)input.length;
            try {
                int written = this.compressor.compress(input, 0, input.length, output, outputOffset + 4, maxCompressedLength);
                outputBuf.writerIndex(4 + written);
                Frame frame2 = frame.with(outputBuf);
                return frame2;
            }
            catch (Throwable e) {
                outputBuf.release();
                throw e;
            }
            finally {
                frame.release();
            }
        }

        @Override
        public Frame decompress(Frame frame) throws IOException {
            byte[] input = CBUtil.readRawBytes(frame.body);
            int uncompressedLength = (input[0] & 0xFF) << 24 | (input[1] & 0xFF) << 16 | (input[2] & 0xFF) << 8 | input[3] & 0xFF;
            ByteBuf output = CBUtil.allocator.heapBuffer(uncompressedLength);
            try {
                int read = this.decompressor.decompress(input, 4, output.array(), output.arrayOffset(), uncompressedLength);
                if (read != input.length - 4) {
                    throw new IOException("Compressed lengths mismatch");
                }
                output.writerIndex(uncompressedLength);
                Frame frame2 = frame.with(output);
                return frame2;
            }
            catch (Throwable e) {
                output.release();
                throw e;
            }
            finally {
                frame.release();
            }
        }
    }

    public static class SnappyCompressor
    implements FrameCompressor {
        public static final SnappyCompressor instance;

        private SnappyCompressor() {
            Snappy.getNativeLibraryVersion();
        }

        @Override
        public Frame compress(Frame frame) throws IOException {
            byte[] input = CBUtil.readRawBytes(frame.body);
            ByteBuf output = CBUtil.allocator.heapBuffer(Snappy.maxCompressedLength((int)input.length));
            try {
                int written = Snappy.compress((byte[])input, (int)0, (int)input.length, (byte[])output.array(), (int)output.arrayOffset());
                output.writerIndex(written);
            }
            catch (Throwable e) {
                output.release();
                throw e;
            }
            finally {
                frame.release();
            }
            return frame.with(output);
        }

        @Override
        public Frame decompress(Frame frame) throws IOException {
            byte[] input = CBUtil.readRawBytes(frame.body);
            if (!Snappy.isValidCompressedBuffer((byte[])input, (int)0, (int)input.length)) {
                throw new ProtocolException("Provided frame does not appear to be Snappy compressed");
            }
            ByteBuf output = CBUtil.allocator.heapBuffer(Snappy.uncompressedLength((byte[])input));
            try {
                int size = Snappy.uncompress((byte[])input, (int)0, (int)input.length, (byte[])output.array(), (int)output.arrayOffset());
                output.writerIndex(size);
            }
            catch (Throwable e) {
                output.release();
                throw e;
            }
            finally {
                frame.release();
            }
            return frame.with(output);
        }

        static {
            SnappyCompressor i;
            try {
                i = new SnappyCompressor();
            }
            catch (Exception e) {
                i = null;
            }
            catch (NoClassDefFoundError e) {
                i = null;
            }
            catch (SnappyError e) {
                i = null;
            }
            catch (UnsatisfiedLinkError e) {
                i = null;
            }
            instance = i;
        }
    }
}

