/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.io.util.AbstractDataOutput;
import org.apache.cassandra.utils.ByteBufferUtil;

public final class DataOutputByteBuffer
extends AbstractDataOutput {
    final ByteBuffer buffer;

    public DataOutputByteBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public void write(int b) {
        this.buffer.put((byte)b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.buffer.put(b, off, len);
    }

    @Override
    public void write(ByteBuffer buffer) throws IOException {
        int len = buffer.remaining();
        ByteBufferUtil.arrayCopy(buffer, buffer.position(), this.buffer, this.buffer.position(), len);
        this.buffer.position(this.buffer.position() + len);
    }
}

