/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.composites;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.composites.CBuilder;
import org.apache.cassandra.db.composites.CType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.db.marshal.AbstractCompositeType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.sstable.IndexHelper;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class AbstractCType
implements CType {
    private final Comparator<Composite> reverseComparator = new Comparator<Composite>(){

        @Override
        public int compare(Composite c1, Composite c2) {
            if (c1.isEmpty()) {
                return c2.isEmpty() ? 0 : -1;
            }
            if (c2.isEmpty()) {
                return 1;
            }
            return AbstractCType.this.compare(c2, c1);
        }
    };
    private final Comparator<IndexHelper.IndexInfo> indexComparator = new Comparator<IndexHelper.IndexInfo>(){

        @Override
        public int compare(IndexHelper.IndexInfo o1, IndexHelper.IndexInfo o2) {
            return AbstractCType.this.compare(o1.lastName, o2.lastName);
        }
    };
    private final Comparator<IndexHelper.IndexInfo> indexReverseComparator = new Comparator<IndexHelper.IndexInfo>(){

        @Override
        public int compare(IndexHelper.IndexInfo o1, IndexHelper.IndexInfo o2) {
            return AbstractCType.this.compare(o1.firstName, o2.firstName);
        }
    };
    private final Serializer serializer = new Serializer(this);
    private final ISerializer<IndexHelper.IndexInfo> indexSerializer = new IndexHelper.IndexInfo.Serializer(this);
    private final IVersionedSerializer<ColumnSlice> sliceSerializer = new ColumnSlice.Serializer(this);
    private final IVersionedSerializer<SliceQueryFilter> sliceQueryFilterSerializer = new SliceQueryFilter.Serializer(this);
    private final DeletionInfo.Serializer deletionInfoSerializer = new DeletionInfo.Serializer(this);
    private final RangeTombstone.Serializer rangeTombstoneSerializer = new RangeTombstone.Serializer(this);
    private final RowIndexEntry.Serializer rowIndexEntrySerializer = new RowIndexEntry.Serializer(this);
    protected final boolean isByteOrderComparable;

    protected AbstractCType(boolean isByteOrderComparable) {
        this.isByteOrderComparable = isByteOrderComparable;
    }

    protected static boolean isByteOrderComparable(Iterable<AbstractType<?>> types) {
        boolean isByteOrderComparable = true;
        for (AbstractType<?> type : types) {
            isByteOrderComparable &= type.isByteOrderComparable();
        }
        return isByteOrderComparable;
    }

    @Override
    public int compare(Composite c1, Composite c2) {
        int s1 = c1.size();
        int s2 = c2.size();
        int minSize = Math.min(s1, s2);
        if (this.isByteOrderComparable) {
            for (int i = 0; i < minSize; ++i) {
                int cmp = ByteBufferUtil.compareUnsigned(c1.get(i), c2.get(i));
                if (cmp == 0) continue;
                return cmp;
            }
        } else {
            for (int i = 0; i < minSize; ++i) {
                AbstractType<?> comparator = this.subtype(i);
                int cmp = comparator.compare(c1.get(i), c2.get(i));
                if (cmp == 0) continue;
                return cmp;
            }
        }
        if (s1 == s2) {
            return c1.eoc().compareTo(c2.eoc());
        }
        return s1 < s2 ? c1.eoc().prefixComparisonResult : -c2.eoc().prefixComparisonResult;
    }

    @Override
    public void validate(Composite name) {
        ByteBuffer previous = null;
        for (int i = 0; i < name.size(); ++i) {
            AbstractType<?> comparator = this.subtype(i);
            ByteBuffer value = name.get(i);
            comparator.validateCollectionMember(value, previous);
            previous = value;
        }
    }

    @Override
    public boolean isCompatibleWith(CType previous) {
        if (this == previous) {
            return true;
        }
        if (this.size() < previous.size()) {
            return false;
        }
        for (int i = 0; i < previous.size(); ++i) {
            AbstractType<?> tprev = previous.subtype(i);
            AbstractType<?> tnew = this.subtype(i);
            if (tnew.isCompatibleWith(tprev)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getString(Composite c) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < c.size(); ++i) {
            if (i > 0) {
                sb.append(":");
            }
            sb.append(AbstractCompositeType.escape(this.subtype(i).getString(c.get(i))));
        }
        switch (c.eoc()) {
            case START: {
                sb.append(":_");
                break;
            }
            case END: {
                sb.append(":!");
            }
        }
        return sb.toString();
    }

    @Override
    public Composite make(Object ... components) {
        if (components.length > this.size()) {
            throw new IllegalArgumentException("Too many components, max is " + this.size());
        }
        CBuilder builder = this.builder();
        for (int i = 0; i < components.length; ++i) {
            Object obj = components[i];
            if (obj instanceof ByteBuffer) {
                builder.add((ByteBuffer)obj);
                continue;
            }
            builder.add(obj);
        }
        return builder.build();
    }

    @Override
    public CType.Serializer serializer() {
        return this.serializer;
    }

    @Override
    public Comparator<Composite> reverseComparator() {
        return this.reverseComparator;
    }

    @Override
    public Comparator<IndexHelper.IndexInfo> indexComparator() {
        return this.indexComparator;
    }

    @Override
    public Comparator<IndexHelper.IndexInfo> indexReverseComparator() {
        return this.indexReverseComparator;
    }

    @Override
    public ISerializer<IndexHelper.IndexInfo> indexSerializer() {
        return this.indexSerializer;
    }

    @Override
    public IVersionedSerializer<ColumnSlice> sliceSerializer() {
        return this.sliceSerializer;
    }

    @Override
    public IVersionedSerializer<SliceQueryFilter> sliceQueryFilterSerializer() {
        return this.sliceQueryFilterSerializer;
    }

    @Override
    public DeletionInfo.Serializer deletionInfoSerializer() {
        return this.deletionInfoSerializer;
    }

    @Override
    public RangeTombstone.Serializer rangeTombstoneSerializer() {
        return this.rangeTombstoneSerializer;
    }

    @Override
    public RowIndexEntry.Serializer rowIndexEntrySerializer() {
        return this.rowIndexEntrySerializer;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        CType c = (CType)o;
        if (this.size() != c.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.subtype(i).equals(c.subtype(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 31;
        for (int i = 0; i < this.size(); ++i) {
            h += this.subtype(i).hashCode();
        }
        return h + this.getClass().hashCode();
    }

    public String toString() {
        return this.asAbstractType().toString();
    }

    protected static ByteBuffer sliceBytes(ByteBuffer bb, int offs, int length) {
        ByteBuffer copy = bb.duplicate();
        copy.position(offs);
        copy.limit(offs + length);
        return copy;
    }

    protected static void checkRemaining(ByteBuffer bb, int offs, int length) {
        if (offs + length > bb.limit()) {
            throw new IllegalArgumentException("Not enough bytes");
        }
    }

    private static class Serializer
    implements CType.Serializer {
        private final CType type;

        public Serializer(CType type) {
            this.type = type;
        }

        @Override
        public void serialize(Composite c, DataOutputPlus out) throws IOException {
            ByteBufferUtil.writeWithShortLength(c.toByteBuffer(), out);
        }

        @Override
        public Composite deserialize(DataInput in) throws IOException {
            return this.type.fromByteBuffer(ByteBufferUtil.readWithShortLength(in));
        }

        @Override
        public long serializedSize(Composite c, TypeSizes type) {
            return type.sizeofWithShortLength(c.toByteBuffer());
        }

        @Override
        public void skip(DataInput in) throws IOException {
            ByteBufferUtil.skipShortLength(in);
        }
    }
}

