/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ColumnIndex;
import org.apache.cassandra.db.CounterCell;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.io.sstable.ColumnNameHelper;
import org.apache.cassandra.io.sstable.ColumnStats;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.MergeIterator;
import org.apache.cassandra.utils.StreamingHistogram;

public class LazilyCompactedRow
extends AbstractCompactedRow {
    private final List<? extends OnDiskAtomIterator> rows;
    private final CompactionController controller;
    private final long maxPurgeableTimestamp;
    private final ColumnFamily emptyColumnFamily;
    private ColumnStats columnStats;
    private boolean closed;
    private ColumnIndex.Builder indexBuilder;
    private final SecondaryIndexManager.Updater indexer;
    private final Reducer reducer;
    private final Iterator<OnDiskAtom> merger;
    private DeletionTime maxRowTombstone;

    public LazilyCompactedRow(CompactionController controller, List<? extends OnDiskAtomIterator> rows) {
        super(rows.get(0).getKey());
        this.rows = rows;
        this.controller = controller;
        this.indexer = controller.cfs.indexManager.gcUpdaterFor(this.key);
        this.maxRowTombstone = DeletionTime.LIVE;
        for (OnDiskAtomIterator onDiskAtomIterator : rows) {
            DeletionTime rowTombstone = onDiskAtomIterator.getColumnFamily().deletionInfo().getTopLevelDeletion();
            if (this.maxRowTombstone.compareTo(rowTombstone) >= 0) continue;
            this.maxRowTombstone = rowTombstone;
        }
        this.maxPurgeableTimestamp = controller.maxPurgeableTimestamp(this.key);
        this.emptyColumnFamily = ArrayBackedSortedColumns.factory.create(controller.cfs.metadata);
        this.emptyColumnFamily.delete(this.maxRowTombstone);
        if (this.maxRowTombstone.markedForDeleteAt < this.maxPurgeableTimestamp) {
            this.emptyColumnFamily.purgeTombstones(controller.gcBefore);
        }
        this.reducer = new Reducer();
        this.merger = Iterators.filter(MergeIterator.get(rows, this.emptyColumnFamily.getComparator().onDiskAtomComparator(), this.reducer), (Predicate)Predicates.notNull());
    }

    private static void removeDeleted(ColumnFamily cf, boolean shouldPurge, DecoratedKey key, CompactionController controller) {
        int overriddenGCBefore = shouldPurge ? controller.gcBefore : Integer.MIN_VALUE;
        ColumnFamilyStore.removeDeletedColumnsOnly(cf, overriddenGCBefore, controller.cfs.indexManager.gcUpdaterFor(key));
    }

    @Override
    public RowIndexEntry write(long currentPosition, DataOutputPlus out) throws IOException {
        ColumnIndex columnsIndex;
        assert (!this.closed);
        try {
            this.indexBuilder = new ColumnIndex.Builder(this.emptyColumnFamily, this.key.getKey(), out);
            columnsIndex = this.indexBuilder.buildForCompaction(this.merger);
            if (columnsIndex.columnsIndex.isEmpty() && !this.emptyColumnFamily.isMarkedForDelete()) {
                return null;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.columnStats = new ColumnStats(this.reducer.columns, this.reducer.minTimestampSeen, Math.max(this.emptyColumnFamily.deletionInfo().maxTimestamp(), this.reducer.maxTimestampSeen), this.reducer.maxLocalDeletionTimeSeen, this.reducer.tombstones, this.reducer.minColumnNameSeen, this.reducer.maxColumnNameSeen, this.reducer.hasLegacyCounterShards);
        this.indexBuilder.maybeWriteEmptyRowHeader();
        out.writeShort(0);
        this.close();
        return RowIndexEntry.create(currentPosition, this.emptyColumnFamily.deletionInfo().getTopLevelDeletion(), columnsIndex);
    }

    @Override
    public void update(MessageDigest digest) {
        assert (!this.closed);
        DataOutputBuffer out = new DataOutputBuffer();
        try {
            DeletionTime.serializer.serialize(this.emptyColumnFamily.deletionInfo().getTopLevelDeletion(), (DataOutputPlus)out);
            digest.update(out.getData(), 0, out.getLength());
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        this.indexBuilder = new ColumnIndex.Builder(this.emptyColumnFamily, this.key.getKey(), out);
        while (this.merger.hasNext()) {
            this.merger.next().updateDigest(digest);
        }
        this.close();
    }

    @Override
    public ColumnStats columnStats() {
        return this.columnStats;
    }

    @Override
    public void close() {
        for (OnDiskAtomIterator onDiskAtomIterator : this.rows) {
            try {
                onDiskAtomIterator.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.closed = true;
    }

    private class Reducer
    extends MergeIterator.Reducer<OnDiskAtom, OnDiskAtom> {
        final ColumnFamily container;
        RangeTombstone tombstone;
        int columns;
        long minTimestampSeen;
        long maxTimestampSeen;
        int maxLocalDeletionTimeSeen;
        StreamingHistogram tombstones;
        List<ByteBuffer> minColumnNameSeen;
        List<ByteBuffer> maxColumnNameSeen;
        boolean hasLegacyCounterShards;

        private Reducer() {
            this.container = ArrayBackedSortedColumns.factory.create(LazilyCompactedRow.this.emptyColumnFamily.metadata());
            this.columns = 0;
            this.minTimestampSeen = Long.MAX_VALUE;
            this.maxTimestampSeen = Long.MIN_VALUE;
            this.maxLocalDeletionTimeSeen = Integer.MIN_VALUE;
            this.tombstones = new StreamingHistogram(100);
            this.minColumnNameSeen = Collections.emptyList();
            this.maxColumnNameSeen = Collections.emptyList();
            this.hasLegacyCounterShards = false;
        }

        @Override
        public void reduce(OnDiskAtom current) {
            if (current instanceof RangeTombstone) {
                if (this.tombstone == null || current.timestamp() >= this.tombstone.timestamp()) {
                    this.tombstone = (RangeTombstone)current;
                }
            } else {
                Cell cell = (Cell)current;
                this.container.addColumn(cell);
                if (LazilyCompactedRow.this.indexer == SecondaryIndexManager.nullUpdater) {
                    return;
                }
                if (cell.isLive() && !this.container.getColumn(cell.name()).equals(cell)) {
                    LazilyCompactedRow.this.indexer.remove(cell);
                }
            }
        }

        @Override
        protected OnDiskAtom getReduced() {
            if (this.tombstone != null) {
                RangeTombstone t = this.tombstone;
                this.tombstone = null;
                if (((DeletionTime)t.data).isGcAble(((LazilyCompactedRow)LazilyCompactedRow.this).controller.gcBefore)) {
                    return null;
                }
                this.tombstones.update(t.getLocalDeletionTime());
                this.minTimestampSeen = Math.min(this.minTimestampSeen, t.timestamp());
                this.maxTimestampSeen = Math.max(this.maxTimestampSeen, t.timestamp());
                this.minColumnNameSeen = ColumnNameHelper.minComponents(this.minColumnNameSeen, (Composite)t.min, ((LazilyCompactedRow)LazilyCompactedRow.this).controller.cfs.metadata.comparator);
                this.maxColumnNameSeen = ColumnNameHelper.maxComponents(this.maxColumnNameSeen, (Composite)t.max, ((LazilyCompactedRow)LazilyCompactedRow.this).controller.cfs.metadata.comparator);
                return t;
            }
            boolean shouldPurge = this.container.getSortedColumns().iterator().next().timestamp() < LazilyCompactedRow.this.maxPurgeableTimestamp;
            this.container.delete(LazilyCompactedRow.this.maxRowTombstone);
            LazilyCompactedRow.removeDeleted(this.container, shouldPurge, LazilyCompactedRow.this.key, LazilyCompactedRow.this.controller);
            Iterator<Cell> iter = this.container.iterator();
            if (!iter.hasNext()) {
                this.container.clear();
                return null;
            }
            int localDeletionTime = this.container.deletionInfo().getTopLevelDeletion().localDeletionTime;
            if (localDeletionTime < Integer.MAX_VALUE) {
                this.tombstones.update(localDeletionTime);
            }
            Cell reduced = iter.next();
            this.container.clear();
            if (LazilyCompactedRow.this.indexBuilder.tombstoneTracker().isDeleted(reduced)) {
                LazilyCompactedRow.this.indexer.remove(reduced);
                return null;
            }
            ++this.columns;
            this.minTimestampSeen = Math.min(this.minTimestampSeen, reduced.timestamp());
            this.maxTimestampSeen = Math.max(this.maxTimestampSeen, reduced.timestamp());
            this.maxLocalDeletionTimeSeen = Math.max(this.maxLocalDeletionTimeSeen, reduced.getLocalDeletionTime());
            this.minColumnNameSeen = ColumnNameHelper.minComponents(this.minColumnNameSeen, reduced.name(), ((LazilyCompactedRow)LazilyCompactedRow.this).controller.cfs.metadata.comparator);
            this.maxColumnNameSeen = ColumnNameHelper.maxComponents(this.maxColumnNameSeen, reduced.name(), ((LazilyCompactedRow)LazilyCompactedRow.this).controller.cfs.metadata.comparator);
            int deletionTime = reduced.getLocalDeletionTime();
            if (deletionTime < Integer.MAX_VALUE) {
                this.tombstones.update(deletionTime);
            }
            if (reduced instanceof CounterCell) {
                this.hasLegacyCounterShards = this.hasLegacyCounterShards || ((CounterCell)reduced).hasLegacyShards();
            }
            return reduced;
        }
    }
}

