/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ConcurrentHashMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.RateLimiter;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import org.apache.cassandra.cache.AutoSavingCache;
import org.apache.cassandra.concurrent.DebuggableThreadPoolExecutor;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutor;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.AbstractCompactionTask;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionInterruptedException;
import org.apache.cassandra.db.compaction.CompactionIterable;
import org.apache.cassandra.db.compaction.CompactionManagerMBean;
import org.apache.cassandra.db.compaction.ICompactionScanner;
import org.apache.cassandra.db.compaction.LazilyCompactedRow;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.compaction.Scrubber;
import org.apache.cassandra.db.index.SecondaryIndexBuilder;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableRewriter;
import org.apache.cassandra.io.sstable.SSTableWriter;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.metrics.CompactionMetrics;
import org.apache.cassandra.repair.Validator;
import org.apache.cassandra.service.ActiveRepairService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.WrappedRunnable;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionManager
implements CompactionManagerMBean {
    public static final String MBEAN_OBJECT_NAME = "org.apache.cassandra.db:type=CompactionManager";
    private static final Logger logger = LoggerFactory.getLogger(CompactionManager.class);
    public static final CompactionManager instance;
    public static final int NO_GC = Integer.MIN_VALUE;
    public static final int GC_ALL = Integer.MAX_VALUE;
    public static final ThreadLocal<Boolean> isCompactionManager;
    private final CompactionExecutor executor = new CompactionExecutor();
    private final CompactionExecutor validationExecutor = new ValidationExecutor();
    private static final CompactionExecutor cacheCleanupExecutor;
    private final CompactionMetrics metrics = new CompactionMetrics(this.executor, this.validationExecutor);
    private final Multiset<ColumnFamilyStore> compactingCF = ConcurrentHashMultiset.create();
    private final RateLimiter compactionRateLimiter = RateLimiter.create((double)Double.MAX_VALUE);

    public RateLimiter getRateLimiter() {
        double currentThroughput = (double)DatabaseDescriptor.getCompactionThroughputMbPerSec() * 1024.0 * 1024.0;
        if (currentThroughput == 0.0 || StorageService.instance.isBootstrapMode()) {
            currentThroughput = Double.MAX_VALUE;
        }
        if (this.compactionRateLimiter.getRate() != currentThroughput) {
            this.compactionRateLimiter.setRate(currentThroughput);
        }
        return this.compactionRateLimiter;
    }

    public List<Future<?>> submitBackground(ColumnFamilyStore cfs) {
        if (cfs.isAutoCompactionDisabled()) {
            logger.debug("Autocompaction is disabled");
            return Collections.emptyList();
        }
        int count = this.compactingCF.count((Object)cfs);
        if (count > 0 && this.executor.getActiveCount() >= this.executor.getMaximumPoolSize()) {
            logger.debug("Background compaction is still running for {}.{} ({} remaining). Skipping", new Object[]{cfs.keyspace.getName(), cfs.name, count});
            return Collections.emptyList();
        }
        logger.debug("Scheduling a background task check for {}.{} with {}", new Object[]{cfs.keyspace.getName(), cfs.name, cfs.getCompactionStrategy().getClass().getSimpleName()});
        ArrayList futures = new ArrayList();
        do {
            this.compactingCF.add((Object)cfs);
            futures.add(this.executor.submit(new BackgroundCompactionTask(cfs)));
        } while (this.executor.getActiveCount() + futures.size() < this.executor.getMaximumPoolSize());
        return futures;
    }

    public boolean isCompacting(Iterable<ColumnFamilyStore> cfses) {
        for (ColumnFamilyStore cfs : cfses) {
            if (cfs.getDataTracker().getCompacting().isEmpty()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AllSSTableOpStatus parallelAllSSTableOperation(ColumnFamilyStore cfs, final OneSSTableOperation operation) throws ExecutionException, InterruptedException {
        Iterable<SSTableReader> compactingSSTables = cfs.markAllCompacting();
        if (compactingSSTables == null) {
            logger.info("Aborting operation on {}.{} after failing to interrupt other compaction operations", (Object)cfs.keyspace.getName(), (Object)cfs.name);
            return AllSSTableOpStatus.ABORTED;
        }
        if (Iterables.isEmpty(compactingSSTables)) {
            logger.info("No sstables for {}.{}", (Object)cfs.keyspace.getName(), (Object)cfs.name);
            return AllSSTableOpStatus.SUCCESSFUL;
        }
        try {
            Iterable<SSTableReader> sstables = operation.filterSSTables(compactingSSTables);
            ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
            for (final SSTableReader sSTableReader : sstables) {
                futures.add(this.executor.submit(new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        operation.execute(sSTableReader);
                        return this;
                    }
                }));
            }
            for (Future future : futures) {
                future.get();
            }
        }
        finally {
            cfs.getDataTracker().unmarkCompacting(compactingSSTables);
        }
        return AllSSTableOpStatus.SUCCESSFUL;
    }

    public AllSSTableOpStatus performScrub(final ColumnFamilyStore cfs, final boolean skipCorrupted) throws InterruptedException, ExecutionException {
        assert (!cfs.isIndex());
        return this.parallelAllSSTableOperation(cfs, new OneSSTableOperation(){

            @Override
            public Iterable<SSTableReader> filterSSTables(Iterable<SSTableReader> input) {
                return input;
            }

            @Override
            public void execute(SSTableReader input) throws IOException {
                CompactionManager.this.scrubOne(cfs, input, skipCorrupted);
            }
        });
    }

    public AllSSTableOpStatus performSSTableRewrite(final ColumnFamilyStore cfs, final boolean excludeCurrentVersion) throws InterruptedException, ExecutionException {
        return this.parallelAllSSTableOperation(cfs, new OneSSTableOperation(){

            @Override
            public Iterable<SSTableReader> filterSSTables(Iterable<SSTableReader> input) {
                return Iterables.filter(input, (Predicate)new Predicate<SSTableReader>(){

                    public boolean apply(SSTableReader sstable) {
                        return !excludeCurrentVersion || !sstable.descriptor.version.equals(Descriptor.Version.CURRENT);
                    }
                });
            }

            @Override
            public void execute(SSTableReader input) throws IOException {
                AbstractCompactionTask task = cfs.getCompactionStrategy().getCompactionTask(Collections.singleton(input), Integer.MIN_VALUE, Long.MAX_VALUE);
                task.setUserDefined(true);
                task.setCompactionType(OperationType.UPGRADE_SSTABLES);
                task.execute(CompactionManager.this.metrics);
            }
        });
    }

    public AllSSTableOpStatus performCleanup(final ColumnFamilyStore cfStore) throws InterruptedException, ExecutionException {
        assert (!cfStore.isIndex());
        Keyspace keyspace = cfStore.keyspace;
        final Collection<Range<Token>> ranges = StorageService.instance.getLocalRanges(keyspace.getName());
        if (ranges.isEmpty()) {
            logger.info("Cleanup cannot run before a node has joined the ring");
            return AllSSTableOpStatus.ABORTED;
        }
        final boolean hasIndexes = cfStore.indexManager.hasIndexes();
        final CleanupStrategy cleanupStrategy = CleanupStrategy.get(cfStore, ranges);
        return this.parallelAllSSTableOperation(cfStore, new OneSSTableOperation(){

            @Override
            public Iterable<SSTableReader> filterSSTables(Iterable<SSTableReader> input) {
                ArrayList sortedSSTables = Lists.newArrayList(input);
                Collections.sort(sortedSSTables, new SSTableReader.SizeComparator());
                return sortedSSTables;
            }

            @Override
            public void execute(SSTableReader input) throws IOException {
                CompactionManager.this.doCleanupOne(cfStore, input, cleanupStrategy, ranges, hasIndexes);
            }
        });
    }

    public Future<?> submitAntiCompaction(final ColumnFamilyStore cfs, final Collection<Range<Token>> ranges, final Collection<SSTableReader> validatedForRepair, final long repairedAt) {
        WrappedRunnable runnable = new WrappedRunnable(){

            @Override
            public void runMayThrow() throws Exception {
                CompactionManager.this.performAnticompaction(cfs, ranges, validatedForRepair, repairedAt);
            }
        };
        return this.executor.submit(runnable);
    }

    public void performAnticompaction(ColumnFamilyStore cfs, Collection<Range<Token>> ranges, Collection<SSTableReader> validatedForRepair, long repairedAt) throws InterruptedException, ExecutionException, IOException {
        logger.info("Starting anticompaction");
        logger.debug("Starting anticompaction for ranges {}", ranges);
        HashSet<SSTableReader> sstables = new HashSet<SSTableReader>(validatedForRepair);
        HashSet<SSTableReader> mutatedRepairStatuses = new HashSet<SSTableReader>();
        HashSet<SSTableReader> nonAnticompacting = new HashSet<SSTableReader>();
        Iterator sstableIterator = sstables.iterator();
        block0: while (sstableIterator.hasNext()) {
            SSTableReader sstable = (SSTableReader)sstableIterator.next();
            for (Range<Range<Token>> range : Range.normalize(ranges)) {
                Range<Token> sstableRange;
                if (range.contains(sstableRange = new Range<Token>(sstable.first.getToken(), sstable.last.getToken(), sstable.partitioner))) {
                    logger.info("SSTable {} fully contained in range {}, mutating repairedAt instead of anticompacting", (Object)sstable, range);
                    sstable.descriptor.getMetadataSerializer().mutateRepairedAt(sstable.descriptor, repairedAt);
                    sstable.reloadSSTableMetadata();
                    mutatedRepairStatuses.add(sstable);
                    sstableIterator.remove();
                    continue block0;
                }
                if (!sstableRange.intersects(range)) {
                    logger.info("SSTable {} ({}) does not intersect repaired range {}, not touching repairedAt.", new Object[]{sstable, sstableRange, range});
                    nonAnticompacting.add(sstable);
                    sstableIterator.remove();
                    continue;
                }
                logger.info("SSTable {} ({}) will be anticompacted on range {}", new Object[]{sstable, sstableRange, range});
            }
        }
        cfs.getDataTracker().notifySSTableRepairedStatusChanged(mutatedRepairStatuses);
        cfs.getDataTracker().unmarkCompacting((Iterable<SSTableReader>)Sets.union(nonAnticompacting, mutatedRepairStatuses));
        if (!sstables.isEmpty()) {
            this.doAntiCompaction(cfs, ranges, sstables, repairedAt);
        }
        SSTableReader.releaseReferences(sstables);
        cfs.getDataTracker().unmarkCompacting(sstables);
        logger.info(String.format("Completed anticompaction successfully", new Object[0]));
    }

    public void performMaximal(ColumnFamilyStore cfStore) throws InterruptedException, ExecutionException {
        this.submitMaximal(cfStore, CompactionManager.getDefaultGcBefore(cfStore)).get();
    }

    public Future<?> submitMaximal(ColumnFamilyStore cfStore, int gcBefore) {
        final Collection<AbstractCompactionTask> tasks = cfStore.getCompactionStrategy().getMaximalTask(gcBefore);
        WrappedRunnable runnable = new WrappedRunnable(){

            @Override
            protected void runMayThrow() throws IOException {
                if (tasks == null) {
                    return;
                }
                for (AbstractCompactionTask task : tasks) {
                    task.execute(CompactionManager.this.metrics);
                }
            }
        };
        return this.executor.submit(runnable);
    }

    @Override
    public void forceUserDefinedCompaction(String dataFiles) {
        String[] filenames = dataFiles.split(",");
        ArrayListMultimap descriptors = ArrayListMultimap.create();
        for (String filename : filenames) {
            Descriptor desc = Descriptor.fromFilename(filename.trim());
            if (Schema.instance.getCFMetaData(desc) == null) {
                logger.warn("Schema does not exist for file {}. Skipping.", (Object)filename);
                continue;
            }
            ColumnFamilyStore cfs = Keyspace.open(desc.ksname).getColumnFamilyStore(desc.cfname);
            descriptors.put((Object)cfs, (Object)cfs.directories.find(filename.trim()));
        }
        ArrayList futures = new ArrayList();
        for (ColumnFamilyStore cfs : descriptors.keySet()) {
            futures.add(this.submitUserDefined(cfs, descriptors.get((Object)cfs), CompactionManager.getDefaultGcBefore(cfs)));
        }
        FBUtilities.waitOnFutures(futures);
    }

    public Future<?> submitUserDefined(final ColumnFamilyStore cfs, final Collection<Descriptor> dataFiles, final int gcBefore) {
        WrappedRunnable runnable = new WrappedRunnable(){

            @Override
            protected void runMayThrow() throws IOException {
                ArrayList<SSTableReader> sstables = new ArrayList<SSTableReader>(dataFiles.size());
                for (Descriptor desc : dataFiles) {
                    SSTableReader sstable = CompactionManager.this.lookupSSTable(cfs, desc);
                    if (sstable == null) {
                        logger.info("Will not compact {}: it is not an active sstable", (Object)desc);
                        continue;
                    }
                    sstables.add(sstable);
                }
                if (sstables.isEmpty()) {
                    logger.info("No files to compact for user defined compaction");
                } else {
                    AbstractCompactionTask task = cfs.getCompactionStrategy().getUserDefinedTask(sstables, gcBefore);
                    if (task != null) {
                        task.execute(CompactionManager.this.metrics);
                    }
                }
            }
        };
        return this.executor.submit(runnable);
    }

    private SSTableReader lookupSSTable(ColumnFamilyStore cfs, Descriptor descriptor) {
        for (SSTableReader sstable : cfs.getSSTables()) {
            if (!sstable.descriptor.equals(descriptor)) continue;
            return sstable;
        }
        return null;
    }

    public Future<Object> submitValidation(final ColumnFamilyStore cfStore, final Validator validator) {
        Callable<Object> callable = new Callable<Object>(){

            @Override
            public Object call() throws IOException {
                try {
                    CompactionManager.this.doValidationCompaction(cfStore, validator);
                }
                catch (Throwable e) {
                    validator.fail();
                    throw e;
                }
                return this;
            }
        };
        return this.validationExecutor.submit(callable);
    }

    public void disableAutoCompaction() {
        for (String ksname : Schema.instance.getNonSystemKeyspaces()) {
            for (ColumnFamilyStore cfs : Keyspace.open(ksname).getColumnFamilyStores()) {
                cfs.disableAutoCompaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scrubOne(ColumnFamilyStore cfs, SSTableReader sstable, boolean skipCorrupted) throws IOException {
        Scrubber scrubber = new Scrubber(cfs, sstable, skipCorrupted, false);
        CompactionInfo.Holder scrubInfo = scrubber.getScrubInfo();
        this.metrics.beginCompaction(scrubInfo);
        try {
            scrubber.scrub();
        }
        finally {
            scrubber.close();
            this.metrics.finishCompaction(scrubInfo);
        }
    }

    static boolean needsCleanup(SSTableReader sstable, Collection<Range<Token>> ownedRanges) {
        assert (!ownedRanges.isEmpty());
        List sortedRanges = Range.normalize(ownedRanges);
        Range firstRange = sortedRanges.get(0);
        if (sstable.first.getToken().compareTo((Token)firstRange.left) <= 0) {
            return true;
        }
        for (int i = 0; i < sortedRanges.size(); ++i) {
            Range range = sortedRanges.get(i);
            if (((Token)range.right).isMinimum()) {
                return false;
            }
            DecoratedKey firstBeyondRange = sstable.firstKeyBeyond(((Token)range.right).maxKeyBound());
            if (firstBeyondRange == null) {
                return false;
            }
            if (i == sortedRanges.size() - 1) {
                return true;
            }
            Range<Token> nextRange = sortedRanges.get(i + 1);
            if (nextRange.contains(firstBeyondRange.getToken())) continue;
            return true;
        }
        return false;
    }

    private void doCleanupOne(ColumnFamilyStore cfs, SSTableReader sstable, CleanupStrategy cleanupStrategy, Collection<Range<Token>> ranges, boolean hasIndexes) throws IOException {
        assert (!cfs.isIndex());
        if (!hasIndexes && !((AbstractBounds)new Bounds<Token>(sstable.first.getToken(), sstable.last.getToken())).intersects(ranges)) {
            cfs.getDataTracker().markCompactedSSTablesReplaced(Arrays.asList(sstable), Collections.emptyList(), OperationType.CLEANUP);
            return;
        }
        if (!CompactionManager.needsCleanup(sstable, ranges)) {
            logger.debug("Skipping {} for cleanup; all rows should be kept", (Object)sstable);
            return;
        }
        long start = System.nanoTime();
        long totalkeysWritten = 0L;
        int expectedBloomFilterSize = Math.max(cfs.metadata.getMinIndexInterval(), (int)SSTableReader.getApproximateKeyCount(Arrays.asList(sstable)));
        if (logger.isDebugEnabled()) {
            logger.debug("Expected bloom filter size : {}", (Object)expectedBloomFilterSize);
        }
        logger.info("Cleaning up {}", (Object)sstable);
        File compactionFileLocation = cfs.directories.getDirectoryForNewSSTables();
        if (compactionFileLocation == null) {
            throw new IOException("disk full");
        }
        ICompactionScanner scanner = cleanupStrategy.getScanner(sstable, this.getRateLimiter());
        CleanupInfo ci = new CleanupInfo(sstable, scanner);
        this.metrics.beginCompaction(ci);
        SSTableRewriter writer = new SSTableRewriter(cfs, new HashSet<SSTableReader>((Collection<SSTableReader>)ImmutableSet.of((Object)sstable)), sstable.maxDataAge, OperationType.CLEANUP, false);
        try (CompactionController controller = new CompactionController(cfs, Collections.singleton(sstable), CompactionManager.getDefaultGcBefore(cfs));){
            writer.switchWriter(CompactionManager.createWriter(cfs, compactionFileLocation, expectedBloomFilterSize, sstable.getSSTableMetadata().repairedAt, sstable));
            while (scanner.hasNext()) {
                LazilyCompactedRow compactedRow;
                if (ci.isStopRequested()) {
                    throw new CompactionInterruptedException(ci.getCompactionInfo());
                }
                SSTableIdentityIterator row = (SSTableIdentityIterator)scanner.next();
                if ((row = cleanupStrategy.cleanup(row)) == null || writer.append(compactedRow = new LazilyCompactedRow(controller, Collections.singletonList(row))) == null) continue;
                ++totalkeysWritten;
            }
            cfs.indexManager.flushIndexesBlocking();
            writer.finish();
        }
        catch (Throwable e) {
            writer.abort();
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            scanner.close();
            this.metrics.finishCompaction(ci);
        }
        List<SSTableReader> results = writer.finished();
        if (!results.isEmpty()) {
            String format = "Cleaned up to %s.  %,d to %,d (~%d%% of original) bytes for %,d keys.  Time: %,dms.";
            long dTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
            long startsize = sstable.onDiskLength();
            long endsize = 0L;
            for (SSTableReader newSstable : results) {
                endsize += newSstable.onDiskLength();
            }
            double ratio = (double)endsize / (double)startsize;
            logger.info(String.format(format, results.get(0).getFilename(), startsize, endsize, (int)(ratio * 100.0), totalkeysWritten, dTime));
        }
    }

    public static SSTableWriter createWriter(ColumnFamilyStore cfs, File compactionFileLocation, int expectedBloomFilterSize, long repairedAt, SSTableReader sstable) {
        FileUtils.createDirectory(compactionFileLocation);
        return new SSTableWriter(cfs.getTempSSTablePath(compactionFileLocation), expectedBloomFilterSize, repairedAt, cfs.metadata, cfs.partitioner, new MetadataCollector(Collections.singleton(sstable), cfs.metadata.comparator, sstable.getSSTableLevel()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doValidationCompaction(ColumnFamilyStore cfs, Validator validator) throws IOException {
        int gcBefore;
        Collection<SSTableReader> sstables;
        if (!cfs.isValid()) {
            return;
        }
        String snapshotName = validator.desc.sessionId.toString();
        boolean isSnapshotValidation = cfs.snapshotExists(snapshotName);
        if (isSnapshotValidation) {
            sstables = cfs.getSnapshotSSTableReader(snapshotName);
            gcBefore = cfs.gcBefore(cfs.getSnapshotCreationTime(snapshotName));
        } else {
            StorageService.instance.forceKeyspaceFlush(cfs.keyspace.getName(), cfs.name);
            sstables = validator.desc.parentSessionId == null || ActiveRepairService.instance.getParentRepairSession(validator.desc.parentSessionId) == null ? cfs.markCurrentSSTablesReferenced() : ActiveRepairService.instance.getParentRepairSession(validator.desc.parentSessionId).getAndReferenceSSTables(cfs.metadata.cfId);
            gcBefore = validator.gcBefore > 0 ? validator.gcBefore : CompactionManager.getDefaultGcBefore(cfs);
        }
        ValidationCompactionIterable ci = new ValidationCompactionIterable(cfs, sstables, validator.desc.range, gcBefore);
        Iterator iter = ci.iterator();
        this.metrics.beginCompaction(ci);
        try {
            validator.prepare(cfs);
            while (iter.hasNext()) {
                if (ci.isStopRequested()) {
                    throw new CompactionInterruptedException(ci.getCompactionInfo());
                }
                AbstractCompactedRow row = (AbstractCompactedRow)iter.next();
                validator.add(row);
            }
            validator.complete();
        }
        finally {
            iter.close();
            SSTableReader.releaseReferences(sstables);
            if (isSnapshotValidation) {
                cfs.clearSnapshot(snapshotName);
            }
            this.metrics.finishCompaction(ci);
        }
    }

    private Collection<SSTableReader> doAntiCompaction(ColumnFamilyStore cfs, Collection<Range<Token>> ranges, Collection<SSTableReader> repairedSSTables, long repairedAt) {
        ArrayList<SSTableReader> anticompactedSSTables = new ArrayList<SSTableReader>();
        int repairedKeyCount = 0;
        int unrepairedKeyCount = 0;
        int expectedBloomFilterSize = Math.max(cfs.metadata.getMinIndexInterval(), (int)SSTableReader.getApproximateKeyCount(repairedSSTables));
        logger.info("Performing anticompaction on {} sstables", (Object)repairedSSTables.size());
        for (SSTableReader sstable : repairedSSTables) {
            if (!new File(sstable.getFilename()).exists()) {
                logger.info("Skipping anticompaction for {}, required sstable was compacted and is no longer available.", (Object)sstable);
                continue;
            }
            logger.info("Anticompacting {}", (Object)sstable);
            HashSet<SSTableReader> sstableAsSet = new HashSet<SSTableReader>();
            sstableAsSet.add(sstable);
            File destination = cfs.directories.getDirectoryForNewSSTables();
            SSTableRewriter repairedSSTableWriter = new SSTableRewriter(cfs, sstableAsSet, sstable.maxDataAge, OperationType.ANTICOMPACTION, false);
            SSTableRewriter unRepairedSSTableWriter = new SSTableRewriter(cfs, sstableAsSet, sstable.maxDataAge, OperationType.ANTICOMPACTION, false);
            AbstractCompactionStrategy strategy = cfs.getCompactionStrategy();
            List<ICompactionScanner> scanners = strategy.getScanners(Arrays.asList(sstable));
            try {
                CompactionController controller = new CompactionController(cfs, new HashSet<SSTableReader>(Collections.singleton(sstable)), 864000);
                Throwable throwable = null;
                try {
                    repairedSSTableWriter.switchWriter(CompactionManager.createWriter(cfs, destination, expectedBloomFilterSize, repairedAt, sstable));
                    unRepairedSSTableWriter.switchWriter(CompactionManager.createWriter(cfs, destination, expectedBloomFilterSize, 0L, sstable));
                    CompactionIterable ci = new CompactionIterable(OperationType.ANTICOMPACTION, scanners, controller);
                    try (Iterator iter = ci.iterator();){
                        while (iter.hasNext()) {
                            AbstractCompactedRow row = (AbstractCompactedRow)iter.next();
                            if (Range.isInRanges(row.key.getToken(), ranges)) {
                                repairedSSTableWriter.append(row);
                                ++repairedKeyCount;
                                continue;
                            }
                            unRepairedSSTableWriter.append(row);
                            ++unrepairedKeyCount;
                        }
                    }
                    repairedSSTableWriter.finish(false, repairedAt);
                    unRepairedSSTableWriter.finish(0L);
                    anticompactedSSTables.addAll(repairedSSTableWriter.finished());
                    anticompactedSSTables.addAll(unRepairedSSTableWriter.finished());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (controller == null) continue;
                    if (throwable != null) {
                        try {
                            controller.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    controller.close();
                }
            }
            catch (Throwable e) {
                logger.error("Error anticompacting " + sstable, e);
                repairedSSTableWriter.abort();
                unRepairedSSTableWriter.abort();
            }
        }
        String format = "Repaired {} keys of {} for {}/{}";
        logger.debug(format, new Object[]{repairedKeyCount, repairedKeyCount + unrepairedKeyCount, cfs.keyspace, cfs.getColumnFamilyName()});
        String format2 = "Anticompaction completed successfully, anticompacted from {} to {} sstable(s).";
        logger.info(format2, (Object)repairedSSTables.size(), (Object)anticompactedSSTables.size());
        return anticompactedSSTables;
    }

    public Future<?> submitIndexBuild(final SecondaryIndexBuilder builder) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CompactionManager.this.metrics.beginCompaction(builder);
                try {
                    builder.build();
                }
                finally {
                    CompactionManager.this.metrics.finishCompaction(builder);
                }
            }
        };
        return this.executor.submit(runnable);
    }

    public Future<?> submitCacheWrite(final AutoSavingCache.Writer writer) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!AutoSavingCache.flushInProgress.add(writer.cacheType())) {
                    logger.debug("Cache flushing was already in progress: skipping {}", (Object)writer.getCompactionInfo());
                    return;
                }
                try {
                    CompactionManager.this.metrics.beginCompaction(writer);
                    try {
                        writer.saveCache();
                    }
                    finally {
                        CompactionManager.this.metrics.finishCompaction(writer);
                    }
                }
                finally {
                    AutoSavingCache.flushInProgress.remove((Object)writer.cacheType());
                }
            }
        };
        return this.executor.submit(runnable);
    }

    static int getDefaultGcBefore(ColumnFamilyStore cfs) {
        return cfs.isIndex() ? (int)(System.currentTimeMillis() / 1000L) : cfs.gcBefore(System.currentTimeMillis());
    }

    public int getActiveCompactions() {
        return CompactionMetrics.getCompactions().size();
    }

    @Override
    public List<Map<String, String>> getCompactions() {
        List<CompactionInfo.Holder> compactionHolders = CompactionMetrics.getCompactions();
        ArrayList<Map<String, String>> out = new ArrayList<Map<String, String>>(compactionHolders.size());
        for (CompactionInfo.Holder ci : compactionHolders) {
            out.add(ci.getCompactionInfo().asMap());
        }
        return out;
    }

    @Override
    public List<String> getCompactionSummary() {
        List<CompactionInfo.Holder> compactionHolders = CompactionMetrics.getCompactions();
        ArrayList<String> out = new ArrayList<String>(compactionHolders.size());
        for (CompactionInfo.Holder ci : compactionHolders) {
            out.add(ci.getCompactionInfo().toString());
        }
        return out;
    }

    @Override
    public TabularData getCompactionHistory() {
        try {
            return SystemKeyspace.getCompactionHistory();
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getTotalBytesCompacted() {
        return this.metrics.bytesCompacted.count();
    }

    @Override
    public long getTotalCompactionsCompleted() {
        return this.metrics.totalCompactionsCompleted.count();
    }

    @Override
    public int getPendingTasks() {
        return (Integer)this.metrics.pendingTasks.value();
    }

    @Override
    public long getCompletedTasks() {
        return (Long)this.metrics.completedTasks.value();
    }

    @Override
    public void stopCompaction(String type) {
        OperationType operation = OperationType.valueOf(type);
        for (CompactionInfo.Holder holder : CompactionMetrics.getCompactions()) {
            if (holder.getCompactionInfo().getTaskType() != operation) continue;
            holder.stop();
        }
    }

    @Override
    public int getCoreCompactorThreads() {
        return this.executor.getCorePoolSize();
    }

    @Override
    public void setCoreCompactorThreads(int number) {
        this.executor.setCorePoolSize(number);
    }

    @Override
    public int getMaximumCompactorThreads() {
        return this.executor.getMaximumPoolSize();
    }

    @Override
    public void setMaximumCompactorThreads(int number) {
        this.executor.setMaximumPoolSize(number);
    }

    @Override
    public int getCoreValidationThreads() {
        return this.validationExecutor.getCorePoolSize();
    }

    @Override
    public void setCoreValidationThreads(int number) {
        this.validationExecutor.setCorePoolSize(number);
    }

    @Override
    public int getMaximumValidatorThreads() {
        return this.validationExecutor.getMaximumPoolSize();
    }

    @Override
    public void setMaximumValidatorThreads(int number) {
        this.validationExecutor.setMaximumPoolSize(number);
    }

    public void interruptCompactionFor(Iterable<CFMetaData> columnFamilies, boolean interruptValidation) {
        assert (columnFamilies != null);
        for (CompactionInfo.Holder compactionHolder : CompactionMetrics.getCompactions()) {
            CompactionInfo info = compactionHolder.getCompactionInfo();
            if (info.getTaskType() == OperationType.VALIDATION && !interruptValidation || !Iterables.contains(columnFamilies, (Object)info.getCFMetaData())) continue;
            compactionHolder.stop();
        }
    }

    static {
        isCompactionManager = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return false;
            }
        };
        instance = new CompactionManager();
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(instance, new ObjectName(MBEAN_OBJECT_NAME));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        cacheCleanupExecutor = new CacheCleanupExecutor();
    }

    private static class CleanupInfo
    extends CompactionInfo.Holder {
        private final SSTableReader sstable;
        private final ICompactionScanner scanner;

        public CleanupInfo(SSTableReader sstable, ICompactionScanner scanner) {
            this.sstable = sstable;
            this.scanner = scanner;
        }

        @Override
        public CompactionInfo getCompactionInfo() {
            try {
                return new CompactionInfo(this.sstable.metadata, OperationType.CLEANUP, this.scanner.getCurrentPosition(), this.scanner.getLengthInBytes());
            }
            catch (Exception e) {
                throw new RuntimeException();
            }
        }
    }

    public static interface CompactionExecutorStatsCollector {
        public void beginCompaction(CompactionInfo.Holder var1);

        public void finishCompaction(CompactionInfo.Holder var1);
    }

    private static class CacheCleanupExecutor
    extends CompactionExecutor {
        public CacheCleanupExecutor() {
            super(1, "CacheCleanupExecutor");
        }
    }

    private static class ValidationExecutor
    extends CompactionExecutor {
        public ValidationExecutor() {
            super(1, Integer.MAX_VALUE, "ValidationExecutor", new SynchronousQueue<Runnable>());
        }
    }

    private static class CompactionExecutor
    extends JMXEnabledThreadPoolExecutor {
        protected CompactionExecutor(int minThreads, int maxThreads, String name, BlockingQueue<Runnable> queue) {
            super(minThreads, maxThreads, 60L, TimeUnit.SECONDS, queue, new NamedThreadFactory(name, 1), "internal");
        }

        private CompactionExecutor(int threadCount, String name) {
            this(threadCount, threadCount, name, new LinkedBlockingQueue<Runnable>());
        }

        public CompactionExecutor() {
            this(Math.max(1, DatabaseDescriptor.getConcurrentCompactors()), "CompactionExecutor");
        }

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            isCompactionManager.set(true);
            super.beforeExecute(t, r);
        }

        @Override
        public void afterExecute(Runnable r, Throwable t) {
            DebuggableThreadPoolExecutor.maybeResetTraceSessionWrapper(r);
            if (t == null) {
                t = DebuggableThreadPoolExecutor.extractThrowable(r);
            }
            if (t != null) {
                if (t instanceof CompactionInterruptedException) {
                    logger.info(t.getMessage());
                    logger.debug("Full interruption stack trace:", t);
                } else {
                    DebuggableThreadPoolExecutor.handleOrLog(t);
                }
            }
        }
    }

    private static class ValidationCompactionController
    extends CompactionController {
        public ValidationCompactionController(ColumnFamilyStore cfs, int gcBefore) {
            super(cfs, gcBefore);
        }

        @Override
        public long maxPurgeableTimestamp(DecoratedKey key) {
            return Long.MAX_VALUE;
        }
    }

    private static class ValidationCompactionIterable
    extends CompactionIterable {
        public ValidationCompactionIterable(ColumnFamilyStore cfs, Collection<SSTableReader> sstables, Range<Token> range, int gcBefore) {
            super(OperationType.VALIDATION, cfs.getCompactionStrategy().getScanners(sstables, range), new ValidationCompactionController(cfs, gcBefore));
        }
    }

    private static abstract class CleanupStrategy {
        private CleanupStrategy() {
        }

        public static CleanupStrategy get(ColumnFamilyStore cfs, Collection<Range<Token>> ranges) {
            return cfs.indexManager.hasIndexes() ? new Full(cfs, ranges) : new Bounded(cfs, ranges);
        }

        public abstract ICompactionScanner getScanner(SSTableReader var1, RateLimiter var2);

        public abstract SSTableIdentityIterator cleanup(SSTableIdentityIterator var1);

        private static final class Full
        extends CleanupStrategy {
            private final Collection<Range<Token>> ranges;
            private final ColumnFamilyStore cfs;
            private List<Cell> indexedColumnsInRow;

            public Full(ColumnFamilyStore cfs, Collection<Range<Token>> ranges) {
                this.cfs = cfs;
                this.ranges = ranges;
                this.indexedColumnsInRow = null;
            }

            @Override
            public ICompactionScanner getScanner(SSTableReader sstable, RateLimiter limiter) {
                return sstable.getScanner(limiter);
            }

            @Override
            public SSTableIdentityIterator cleanup(SSTableIdentityIterator row) {
                if (Range.isInRanges(row.getKey().getToken(), this.ranges)) {
                    return row;
                }
                this.cfs.invalidateCachedRow(row.getKey());
                if (this.indexedColumnsInRow != null) {
                    this.indexedColumnsInRow.clear();
                }
                while (row.hasNext()) {
                    OnDiskAtom column = row.next();
                    if (!(column instanceof Cell) || !this.cfs.indexManager.indexes((Cell)column)) continue;
                    if (this.indexedColumnsInRow == null) {
                        this.indexedColumnsInRow = new ArrayList<Cell>();
                    }
                    this.indexedColumnsInRow.add((Cell)column);
                }
                if (this.indexedColumnsInRow != null && !this.indexedColumnsInRow.isEmpty()) {
                    try (OpOrder.Group opGroup = this.cfs.keyspace.writeOrder.start();){
                        this.cfs.indexManager.deleteFromIndexes(row.getKey(), this.indexedColumnsInRow, opGroup);
                    }
                }
                return null;
            }
        }

        private static final class Bounded
        extends CleanupStrategy {
            private final Collection<Range<Token>> ranges;

            public Bounded(final ColumnFamilyStore cfs, Collection<Range<Token>> ranges) {
                this.ranges = ranges;
                cacheCleanupExecutor.submit(new Runnable(){

                    @Override
                    public void run() {
                        cfs.cleanupCache();
                    }
                });
            }

            @Override
            public ICompactionScanner getScanner(SSTableReader sstable, RateLimiter limiter) {
                return sstable.getScanner(this.ranges, limiter);
            }

            @Override
            public SSTableIdentityIterator cleanup(SSTableIdentityIterator row) {
                return row;
            }
        }
    }

    public static enum AllSSTableOpStatus {
        ABORTED,
        SUCCESSFUL;

    }

    private static interface OneSSTableOperation {
        public Iterable<SSTableReader> filterSSTables(Iterable<SSTableReader> var1);

        public void execute(SSTableReader var1) throws IOException;
    }

    class BackgroundCompactionTask
    implements Runnable {
        private final ColumnFamilyStore cfs;

        BackgroundCompactionTask(ColumnFamilyStore cfs) {
            this.cfs = cfs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                logger.debug("Checking {}.{}", (Object)this.cfs.keyspace.getName(), (Object)this.cfs.name);
                if (!this.cfs.isValid()) {
                    logger.debug("Aborting compaction for dropped CF");
                    return;
                }
                AbstractCompactionStrategy strategy = this.cfs.getCompactionStrategy();
                AbstractCompactionTask task = strategy.getNextBackgroundTask(CompactionManager.getDefaultGcBefore(this.cfs));
                if (task == null) {
                    logger.debug("No tasks available");
                    return;
                }
                task.execute(CompactionManager.this.metrics);
            }
            finally {
                CompactionManager.this.compactingCF.remove((Object)this.cfs);
            }
            CompactionManager.this.submitBackground(this.cfs);
        }
    }
}

