/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.Collections;
import java.util.List;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.exceptions.RequestValidationException;

public abstract class ParsedStatement {
    private VariableSpecifications variables;

    public VariableSpecifications getBoundVariables() {
        return this.variables;
    }

    public void setBoundVariables(List<ColumnIdentifier> boundNames) {
        this.variables = new VariableSpecifications(boundNames);
    }

    public abstract Prepared prepare() throws RequestValidationException;

    public static class Prepared {
        public final CQLStatement statement;
        public final List<ColumnSpecification> boundNames;

        public Prepared(CQLStatement statement, List<ColumnSpecification> boundNames) {
            this.statement = statement;
            this.boundNames = boundNames;
        }

        public Prepared(CQLStatement statement, VariableSpecifications names) {
            this(statement, names.getSpecifications());
        }

        public Prepared(CQLStatement statement) {
            this(statement, Collections.emptyList());
        }
    }
}

