/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.EmptyType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.serializers.SetSerializer;

public class SetType<T>
extends CollectionType<Set<T>> {
    private static final Map<AbstractType<?>, SetType> instances = new HashMap();
    public final AbstractType<T> elements;
    private final SetSerializer<T> serializer;

    public static SetType<?> getInstance(TypeParser parser) throws ConfigurationException, SyntaxException {
        List<AbstractType<?>> l = parser.getTypeParameters();
        if (l.size() != 1) {
            throw new ConfigurationException("SetType takes exactly 1 type parameter");
        }
        return SetType.getInstance(l.get(0));
    }

    public static synchronized <T> SetType<T> getInstance(AbstractType<T> elements) {
        SetType<T> t = instances.get(elements);
        if (t == null) {
            t = new SetType<T>(elements);
            instances.put(elements, t);
        }
        return t;
    }

    public SetType(AbstractType<T> elements) {
        super(CollectionType.Kind.SET);
        this.elements = elements;
        this.serializer = SetSerializer.getInstance(elements.getSerializer());
    }

    @Override
    public AbstractType<T> nameComparator() {
        return this.elements;
    }

    @Override
    public AbstractType<?> valueComparator() {
        return EmptyType.instance;
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        return ListType.compareListOrSet(this.elements, o1, o2);
    }

    @Override
    public SetSerializer<T> getSerializer() {
        return this.serializer;
    }

    @Override
    public boolean isByteOrderComparable() {
        return this.elements.isByteOrderComparable();
    }

    @Override
    protected void appendToStringBuilder(StringBuilder sb) {
        sb.append(this.getClass().getName()).append(TypeParser.stringifyTypeParameters(Collections.singletonList(this.elements)));
    }

    @Override
    public List<ByteBuffer> serializedValues(List<Cell> cells) {
        ArrayList<ByteBuffer> bbs = new ArrayList<ByteBuffer>(cells.size());
        for (Cell c : cells) {
            bbs.add(c.name().collectionElement());
        }
        return bbs;
    }
}

