/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.index;

import com.google.common.util.concurrent.ListenableFuture;
import java.nio.ByteBuffer;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.ArrayBackedSortedColumns;
import org.apache.cassandra.db.BufferCell;
import org.apache.cassandra.db.BufferDecoratedKey;
import org.apache.cassandra.db.BufferExpiringCell;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DataTracker;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.ExpiringCell;
import org.apache.cassandra.db.IndexExpression;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.index.PerColumnSecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.index.SecondaryIndexManager;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.dht.LocalToken;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.concurrent.OpOrder;

public abstract class AbstractSimplePerColumnSecondaryIndex
extends PerColumnSecondaryIndex {
    protected ColumnFamilyStore indexCfs;
    protected ColumnDefinition columnDef;

    @Override
    public void init() {
        assert (this.baseCfs != null && this.columnDefs != null && this.columnDefs.size() == 1);
        this.columnDef = (ColumnDefinition)this.columnDefs.iterator().next();
        CellNameType indexComparator = SecondaryIndex.getIndexComparator(this.baseCfs.metadata, this.columnDef);
        CFMetaData indexedCfMetadata = CFMetaData.newIndexMetadata(this.baseCfs.metadata, this.columnDef, indexComparator);
        this.indexCfs = ColumnFamilyStore.createColumnFamilyStore(this.baseCfs.keyspace, indexedCfMetadata.cfName, new LocalPartitioner(this.getIndexKeyComparator()), indexedCfMetadata);
    }

    protected AbstractType<?> getIndexKeyComparator() {
        return this.columnDef.type;
    }

    @Override
    public DecoratedKey getIndexKeyFor(ByteBuffer value) {
        return new BufferDecoratedKey(new LocalToken(this.getIndexKeyComparator(), value), value);
    }

    protected abstract CellName makeIndexColumnName(ByteBuffer var1, Cell var2);

    protected abstract ByteBuffer getIndexedValue(ByteBuffer var1, Cell var2);

    protected abstract AbstractType getExpressionComparator();

    public String expressionString(IndexExpression expr) {
        return String.format("'%s.%s %s %s'", new Object[]{this.baseCfs.name, this.getExpressionComparator().getString(expr.column), expr.operator, this.baseCfs.metadata.getColumnDefinition((ByteBuffer)expr.column).type.getString(expr.value)});
    }

    @Override
    public void delete(ByteBuffer rowKey, Cell cell, OpOrder.Group opGroup) {
        if (!cell.isLive()) {
            return;
        }
        DecoratedKey valueKey = this.getIndexKeyFor(this.getIndexedValue(rowKey, cell));
        int localDeletionTime = (int)(System.currentTimeMillis() / 1000L);
        ArrayBackedSortedColumns cfi = ArrayBackedSortedColumns.factory.create(this.indexCfs.metadata, false, 1);
        cfi.addTombstone(this.makeIndexColumnName(rowKey, cell), localDeletionTime, cell.timestamp());
        this.indexCfs.apply(valueKey, cfi, SecondaryIndexManager.nullUpdater, opGroup, null);
        if (logger.isDebugEnabled()) {
            logger.debug("removed index entry for cleaned-up value {}:{}", (Object)valueKey, (Object)cfi);
        }
    }

    @Override
    public void insert(ByteBuffer rowKey, Cell cell, OpOrder.Group opGroup) {
        DecoratedKey valueKey = this.getIndexKeyFor(this.getIndexedValue(rowKey, cell));
        ArrayBackedSortedColumns cfi = ArrayBackedSortedColumns.factory.create(this.indexCfs.metadata, false, 1);
        CellName name = this.makeIndexColumnName(rowKey, cell);
        if (cell instanceof ExpiringCell) {
            ExpiringCell ec = (ExpiringCell)cell;
            ((ColumnFamily)cfi).addColumn(new BufferExpiringCell(name, ByteBufferUtil.EMPTY_BYTE_BUFFER, ec.timestamp(), ec.getTimeToLive(), ec.getLocalDeletionTime()));
        } else {
            ((ColumnFamily)cfi).addColumn(new BufferCell(name, ByteBufferUtil.EMPTY_BYTE_BUFFER, cell.timestamp()));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("applying index row {} in {}", (Object)this.indexCfs.metadata.getKeyValidator().getString(valueKey.getKey()), (Object)cfi);
        }
        this.indexCfs.apply(valueKey, cfi, SecondaryIndexManager.nullUpdater, opGroup, null);
    }

    @Override
    public void update(ByteBuffer rowKey, Cell oldCol, Cell col, OpOrder.Group opGroup) {
        this.insert(rowKey, col, opGroup);
        if (SecondaryIndexManager.shouldCleanupOldValue(oldCol, col)) {
            this.delete(rowKey, oldCol, opGroup);
        }
    }

    @Override
    public void removeIndex(ByteBuffer columnName) {
        this.indexCfs.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceBlockingFlush() {
        ListenableFuture<?> wait;
        DataTracker dataTracker = this.baseCfs.getDataTracker();
        synchronized (dataTracker) {
            wait = this.indexCfs.forceFlush();
        }
        FBUtilities.waitOnFuture(wait);
    }

    @Override
    public void invalidate() {
        this.indexCfs.invalidate();
    }

    @Override
    public void truncateBlocking(long truncatedAt) {
        this.indexCfs.discardSSTables(truncatedAt);
    }

    @Override
    public ColumnFamilyStore getIndexCfs() {
        return this.indexCfs;
    }

    @Override
    public String getIndexName() {
        return this.indexCfs.name;
    }

    @Override
    public void reload() {
        this.indexCfs.metadata.reloadSecondaryIndexMetadata(this.baseCfs.metadata);
        this.indexCfs.reload();
    }

    @Override
    public long estimateResultRows() {
        return this.getIndexCfs().getMeanColumns();
    }
}

