/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.util.List;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.IndexExpression;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.service.IReadCommand;

public abstract class AbstractRangeCommand
implements IReadCommand {
    public final String keyspace;
    public final String columnFamily;
    public final long timestamp;
    public final AbstractBounds<RowPosition> keyRange;
    public final IDiskAtomFilter predicate;
    public final List<IndexExpression> rowFilter;

    public AbstractRangeCommand(String keyspace, String columnFamily, long timestamp, AbstractBounds<RowPosition> keyRange, IDiskAtomFilter predicate, List<IndexExpression> rowFilter) {
        this.keyspace = keyspace;
        this.columnFamily = columnFamily;
        this.timestamp = timestamp;
        this.keyRange = keyRange;
        this.predicate = predicate;
        this.rowFilter = rowFilter;
    }

    @Override
    public String getKeyspace() {
        return this.keyspace;
    }

    public abstract MessageOut<? extends AbstractRangeCommand> createMessage();

    public abstract AbstractRangeCommand forSubRange(AbstractBounds<RowPosition> var1);

    public abstract AbstractRangeCommand withUpdatedLimit(int var1);

    public abstract int limit();

    public abstract boolean countCQL3Rows();

    public abstract List<Row> executeLocally();

    @Override
    public long getTimeout() {
        return DatabaseDescriptor.getRangeRpcTimeout();
    }
}

