/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.collect.AbstractIterator;
import java.io.DataInput;
import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Iterator;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.BufferCell;
import org.apache.cassandra.db.BufferCounterCell;
import org.apache.cassandra.db.BufferExpiringCell;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnSerializer;
import org.apache.cassandra.db.CounterCell;
import org.apache.cassandra.db.DeletedCell;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.FBUtilities;

public abstract class AbstractCell
implements Cell {
    public static Iterator<OnDiskAtom> onDiskIterator(final DataInput in, final ColumnSerializer.Flag flag, final int expireBefore, final Descriptor.Version version, final CellNameType type) {
        return new AbstractIterator<OnDiskAtom>(){

            protected OnDiskAtom computeNext() {
                OnDiskAtom atom;
                try {
                    atom = type.onDiskAtomSerializer().deserializeFromSSTable(in, flag, expireBefore, version);
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
                if (atom == null) {
                    return (OnDiskAtom)this.endOfData();
                }
                return atom;
            }
        };
    }

    @Override
    public boolean isLive() {
        return true;
    }

    @Override
    public boolean isLive(long now) {
        return true;
    }

    @Override
    public int cellDataSize() {
        return this.name().dataSize() + this.value().remaining() + TypeSizes.NATIVE.sizeof(this.timestamp());
    }

    @Override
    public int serializedSize(CellNameType type, TypeSizes typeSizes) {
        int valueSize = this.value().remaining();
        return (int)type.cellSerializer().serializedSize(this.name(), typeSizes) + 1 + typeSizes.sizeof(this.timestamp()) + typeSizes.sizeof(valueSize) + valueSize;
    }

    @Override
    public int serializationFlags() {
        return 0;
    }

    @Override
    public Cell diff(Cell cell) {
        if (this.timestamp() < cell.timestamp()) {
            return cell;
        }
        return null;
    }

    @Override
    public void updateDigest(MessageDigest digest) {
        digest.update(this.name().toByteBuffer().duplicate());
        digest.update(this.value().duplicate());
        FBUtilities.updateWithLong(digest, this.timestamp());
        FBUtilities.updateWithByte(digest, this.serializationFlags());
    }

    @Override
    public int getLocalDeletionTime() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Cell reconcile(Cell cell) {
        long ts2;
        long ts1 = this.timestamp();
        if (ts1 != (ts2 = cell.timestamp())) {
            return ts1 < ts2 ? cell : this;
        }
        if (this.isLive() != cell.isLive()) {
            return this.isLive() ? cell : this;
        }
        return this.value().compareTo(cell.value()) < 0 ? cell : this;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Cell && this.equals((Cell)o);
    }

    public boolean equals(Cell cell) {
        return this.timestamp() == cell.timestamp() && this.name().equals(cell.name()) && this.value().equals(cell.value());
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getString(CellNameType comparator) {
        return String.format("%s:%b:%d@%d", comparator.getString(this.name()), !this.isLive(), this.value().remaining(), this.timestamp());
    }

    public void validateName(CFMetaData metadata) throws MarshalException {
        metadata.comparator.validate(this.name());
    }

    @Override
    public void validateFields(CFMetaData metadata) throws MarshalException {
        this.validateName(metadata);
        AbstractType<?> valueValidator = metadata.getValueValidator(this.name());
        if (valueValidator != null) {
            valueValidator.validate(this.value());
        }
    }

    public static Cell create(CellName name, ByteBuffer value, long timestamp, int ttl, CFMetaData metadata) {
        if (ttl <= 0) {
            ttl = metadata.getDefaultTimeToLive();
        }
        return ttl > 0 ? new BufferExpiringCell(name, value, timestamp, ttl) : new BufferCell(name, value, timestamp);
    }

    public Cell diffCounter(Cell cell) {
        assert (this instanceof CounterCell) : "Wrong class type: " + this.getClass();
        if (this.timestamp() < cell.timestamp()) {
            return cell;
        }
        assert (cell instanceof CounterCell) : "Wrong class type: " + cell.getClass();
        if (((CounterCell)((Object)this)).timestampOfLastDelete() < ((CounterCell)cell).timestampOfLastDelete()) {
            return cell;
        }
        CounterContext.Relationship rel = CounterCell.contextManager.diff(cell.value(), this.value());
        return rel == CounterContext.Relationship.GREATER_THAN || rel == CounterContext.Relationship.DISJOINT ? cell : null;
    }

    public Cell reconcileCounter(Cell cell) {
        assert (this instanceof CounterCell) : "Wrong class type: " + this.getClass();
        if (cell instanceof DeletedCell) {
            return cell;
        }
        assert (cell instanceof CounterCell) : "Wrong class type: " + cell.getClass();
        if (this.timestamp() < ((CounterCell)cell).timestampOfLastDelete()) {
            return cell;
        }
        long timestampOfLastDelete = ((CounterCell)((Object)this)).timestampOfLastDelete();
        if (timestampOfLastDelete > cell.timestamp()) {
            return this;
        }
        ByteBuffer context = CounterCell.contextManager.merge(this.value(), cell.value());
        if (context == this.value() && this.timestamp() >= cell.timestamp() && timestampOfLastDelete >= ((CounterCell)cell).timestampOfLastDelete()) {
            return this;
        }
        if (context == cell.value() && cell.timestamp() >= this.timestamp() && ((CounterCell)cell).timestampOfLastDelete() >= timestampOfLastDelete) {
            return cell;
        }
        return new BufferCounterCell(this.name(), context, Math.max(this.timestamp(), cell.timestamp()), Math.max(timestampOfLastDelete, ((CounterCell)cell).timestampOfLastDelete()));
    }
}

