/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.util.List;
import org.apache.cassandra.cql3.AbstractMarker;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.Term;

public class SingleColumnRelation
extends Relation {
    private final ColumnIdentifier entity;
    private final Term.Raw value;
    private final List<Term.Raw> inValues;
    public final boolean onToken;

    private SingleColumnRelation(ColumnIdentifier entity, Relation.Type type, Term.Raw value, List<Term.Raw> inValues, boolean onToken) {
        this.entity = entity;
        this.relationType = type;
        this.value = value;
        this.inValues = inValues;
        this.onToken = onToken;
    }

    public SingleColumnRelation(ColumnIdentifier entity, Relation.Type type, Term.Raw value) {
        this(entity, type, value, null, false);
    }

    public SingleColumnRelation(ColumnIdentifier entity, Relation.Type type, Term.Raw value, boolean onToken) {
        this(entity, type, value, null, onToken);
    }

    public static SingleColumnRelation createInRelation(ColumnIdentifier entity, List<Term.Raw> inValues) {
        return new SingleColumnRelation(entity, Relation.Type.IN, null, inValues, false);
    }

    public ColumnIdentifier getEntity() {
        return this.entity;
    }

    public Term.Raw getValue() {
        assert (this.relationType != Relation.Type.IN || this.value == null || this.value instanceof AbstractMarker.INRaw);
        return this.value;
    }

    public List<Term.Raw> getInValues() {
        assert (this.relationType == Relation.Type.IN);
        return this.inValues;
    }

    @Override
    public boolean isMultiColumn() {
        return false;
    }

    public SingleColumnRelation withNonStrictOperator() {
        switch (this.relationType) {
            case GT: {
                return new SingleColumnRelation(this.entity, Relation.Type.GTE, this.value);
            }
            case LT: {
                return new SingleColumnRelation(this.entity, Relation.Type.LTE, this.value);
            }
        }
        return this;
    }

    public String toString() {
        if (this.relationType == Relation.Type.IN) {
            return String.format("%s IN %s", this.entity, this.inValues);
        }
        return String.format("%s %s %s", new Object[]{this.entity, this.relationType, this.value});
    }
}

