/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import java.util.UUID;
import org.apache.cassandra.cache.IMeasurableMemory;

public interface CacheKey
extends IMeasurableMemory {
    public PathInfo getPathInfo();

    public static class PathInfo {
        public final String keyspace;
        public final String columnFamily;
        public final UUID cfId;

        public PathInfo(String keyspace, String columnFamily, UUID cfId) {
            this.keyspace = keyspace;
            this.columnFamily = columnFamily;
            this.cfId = cfId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PathInfo pathInfo = (PathInfo)o;
            return (this.cfId != null ? this.cfId.equals(pathInfo.cfId) : pathInfo.cfId == null) && this.columnFamily.equals(pathInfo.columnFamily) && this.keyspace.equals(pathInfo.keyspace);
        }

        public int hashCode() {
            int result = this.keyspace.hashCode();
            result = 31 * result + this.columnFamily.hashCode();
            result = 31 * result + (this.cfId != null ? this.cfId.hashCode() : 0);
            return result;
        }
    }
}

