/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.btree;

import java.util.Comparator;
import java.util.Iterator;
import org.apache.cassandra.utils.btree.BTree;
import org.apache.cassandra.utils.btree.Path;

public final class Cursor<K, V extends K>
extends Path
implements Iterator<V> {
    private Object[] endNode;
    private byte endIndex;
    private boolean forwards;

    public void reset(Object[] btree, boolean forwards) {
        this._reset(btree, null, BTree.NEGATIVE_INFINITY, false, BTree.POSITIVE_INFINITY, false, forwards);
    }

    public void reset(Object[] btree, Comparator<K> comparator, K lowerBound, K upperBound, boolean forwards) {
        this._reset(btree, comparator, lowerBound, true, upperBound, false, forwards);
    }

    public void reset(Object[] btree, Comparator<K> comparator, K lowerBound, boolean inclusiveLowerBound, K upperBound, boolean inclusiveUpperBound, boolean forwards) {
        this._reset(btree, comparator, lowerBound, inclusiveLowerBound, upperBound, inclusiveUpperBound, forwards);
    }

    private void _reset(Object[] btree, Comparator<K> comparator, Object lowerBound, boolean inclusiveLowerBound, Object upperBound, boolean inclusiveUpperBound, boolean forwards) {
        this.ensureDepth(btree);
        if (lowerBound == null) {
            lowerBound = BTree.NEGATIVE_INFINITY;
        }
        if (upperBound == null) {
            upperBound = BTree.POSITIVE_INFINITY;
        }
        this.forwards = forwards;
        Path findLast = new Path(this.path.length);
        if (forwards) {
            findLast.find(btree, comparator, upperBound, inclusiveUpperBound ? Path.Op.HIGHER : Path.Op.CEIL, true);
            this.find(btree, comparator, lowerBound, inclusiveLowerBound ? Path.Op.CEIL : Path.Op.HIGHER, true);
        } else {
            findLast.find(btree, comparator, lowerBound, inclusiveLowerBound ? Path.Op.LOWER : Path.Op.FLOOR, false);
            this.find(btree, comparator, upperBound, inclusiveUpperBound ? Path.Op.FLOOR : Path.Op.LOWER, false);
        }
        int c = this.compareTo(findLast, forwards);
        if (forwards ? c > 0 : c < 0) {
            this.endNode = this.currentNode();
            this.endIndex = this.currentIndex();
        } else {
            this.endNode = findLast.currentNode();
            this.endIndex = findLast.currentIndex();
        }
    }

    @Override
    public boolean hasNext() {
        return this.path[this.depth] != this.endNode || this.indexes[this.depth] != this.endIndex;
    }

    @Override
    public V next() {
        Object r = this.currentKey();
        if (this.forwards) {
            this.successor();
        } else {
            this.predecessor();
        }
        return (V)r;
    }

    public int count() {
        int next;
        if (!this.forwards) {
            throw new IllegalStateException("Count can only be run on forward cursors");
        }
        int count = 0;
        while ((next = this.consumeNextLeaf()) >= 0) {
            count += next;
        }
        return count;
    }

    private int consumeNextLeaf() {
        Object[] node = this.currentNode();
        int r = 0;
        if (!BTree.isLeaf(node)) {
            byte i = this.currentIndex();
            if (node == this.endNode && i == this.endIndex) {
                return -1;
            }
            r = 1;
            this.successor();
            node = this.currentNode();
        }
        if (node == this.endNode) {
            if (this.currentIndex() == this.endIndex) {
                return r > 0 ? r : -1;
            }
            this.setIndex(this.endIndex);
            return r += this.endIndex - this.currentIndex();
        }
        int keyEnd = BTree.getLeafKeyEnd(node);
        this.setIndex(keyEnd);
        this.successor();
        return r += keyEnd - this.currentIndex();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

