/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos;

import com.google.common.util.concurrent.Striped;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.Lock;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.service.paxos.PrepareResponse;
import org.apache.cassandra.tracing.Tracing;

public class PaxosState {
    private static final Striped<Lock> LOCKS = Striped.lazyWeakLock((int)(DatabaseDescriptor.getConcurrentWriters() * 1024));
    private final Commit promised;
    private final Commit accepted;
    private final Commit mostRecentCommit;

    public PaxosState(ByteBuffer key, CFMetaData metadata) {
        this(Commit.emptyCommit(key, metadata), Commit.emptyCommit(key, metadata), Commit.emptyCommit(key, metadata));
    }

    public PaxosState(Commit promised, Commit accepted, Commit mostRecentCommit) {
        assert (promised.key == accepted.key && accepted.key == mostRecentCommit.key);
        assert (promised.update.metadata() == accepted.update.metadata() && accepted.update.metadata() == mostRecentCommit.update.metadata());
        this.promised = promised;
        this.accepted = accepted;
        this.mostRecentCommit = mostRecentCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrepareResponse prepare(Commit toPrepare) {
        Lock lock = (Lock)LOCKS.get((Object)toPrepare.key);
        lock.lock();
        try {
            PaxosState state = SystemKeyspace.loadPaxosState(toPrepare.key, toPrepare.update.metadata());
            if (toPrepare.isAfter(state.promised)) {
                Tracing.trace("Promising ballot {}", toPrepare.ballot);
                SystemKeyspace.savePaxosPromise(toPrepare);
                PrepareResponse prepareResponse = new PrepareResponse(true, state.accepted, state.mostRecentCommit);
                return prepareResponse;
            }
            Tracing.trace("Promise rejected; {} is not sufficiently newer than {}", toPrepare, state.promised);
            PrepareResponse prepareResponse = new PrepareResponse(false, state.promised, state.mostRecentCommit);
            return prepareResponse;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean propose(Commit proposal) {
        Lock lock = (Lock)LOCKS.get((Object)proposal.key);
        lock.lock();
        try {
            PaxosState state = SystemKeyspace.loadPaxosState(proposal.key, proposal.update.metadata());
            if (proposal.hasBallot(state.promised.ballot) || proposal.isAfter(state.promised)) {
                Tracing.trace("Accepting proposal {}", proposal);
                SystemKeyspace.savePaxosProposal(proposal);
                Boolean bl = true;
                return bl;
            }
            Tracing.trace("Rejecting proposal for {} because inProgress is now {}", proposal, state.promised);
            Boolean bl = false;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    public static void commit(Commit proposal) {
        Tracing.trace("Committing proposal {}", proposal);
        Mutation mutation = proposal.makeMutation();
        Keyspace.open(mutation.getKeyspaceName()).apply(mutation, true);
        SystemKeyspace.savePaxosCommit(proposal);
    }
}

