/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.metrics.ColumnFamilyMetrics;
import org.apache.cassandra.metrics.MetricNameFactory;

public class KeyspaceMetrics {
    public final Gauge<Long> memtableLiveDataSize;
    public final Gauge<Long> memtableOnHeapDataSize;
    public final Gauge<Long> memtableOffHeapDataSize;
    public final Gauge<Long> allMemtablesLiveDataSize;
    public final Gauge<Long> allMemtablesOnHeapDataSize;
    public final Gauge<Long> allMemtablesOffHeapDataSize;
    public final Gauge<Long> memtableColumnsCount;
    public final Gauge<Long> memtableSwitchCount;
    public final Gauge<Integer> pendingFlushes;
    public final Gauge<Integer> pendingCompactions;
    public final Gauge<Long> liveDiskSpaceUsed;
    public final Gauge<Long> totalDiskSpaceUsed;
    public final Gauge<Long> bloomFilterDiskSpaceUsed;
    private final MetricNameFactory factory;

    public KeyspaceMetrics(final Keyspace ks) {
        this.factory = new KeyspaceMetricNameFactory(ks);
        this.memtableColumnsCount = Metrics.newGauge((MetricName)this.factory.createMetricName("MemtableColumnsCount"), (Gauge)new Gauge<Long>(){

            public Long value() {
                long total = 0L;
                for (ColumnFamilyStore cf : ks.getColumnFamilyStores()) {
                    total += ((Long)cf.metric.memtableColumnsCount.value()).longValue();
                }
                return total;
            }
        });
        this.memtableLiveDataSize = Metrics.newGauge((MetricName)this.factory.createMetricName("MemtableLiveDataSize"), (Gauge)new Gauge<Long>(){

            public Long value() {
                long total = 0L;
                for (ColumnFamilyStore cf : ks.getColumnFamilyStores()) {
                    total += ((Long)cf.metric.memtableLiveDataSize.value()).longValue();
                }
                return total;
            }
        });
        this.memtableOnHeapDataSize = Metrics.newGauge((MetricName)this.factory.createMetricName("MemtableOnHeapDataSize"), (Gauge)new Gauge<Long>(){

            public Long value() {
                long total = 0L;
                for (ColumnFamilyStore cf : ks.getColumnFamilyStores()) {
                    total += ((Long)cf.metric.memtableOnHeapSize.value()).longValue();
                }
                return total;
            }
        });
        this.memtableOffHeapDataSize = Metrics.newGauge((MetricName)this.factory.createMetricName("MemtableOffHeapDataSize"), (Gauge)new Gauge<Long>(){

            public Long value() {
                long total = 0L;
                for (ColumnFamilyStore cf : ks.getColumnFamilyStores()) {
                    total += ((Long)cf.metric.memtableOffHeapSize.value()).longValue();
                }
                return total;
            }
        });
        this.allMemtablesLiveDataSize = Metrics.newGauge((MetricName)this.factory.createMetricName("AllMemtablesLiveDataSize"), (Gauge)new Gauge<Long>(){

            public Long value() {
                long total = 0L;
                for (ColumnFamilyStore cf : ks.getColumnFamilyStores()) {
                    total += ((Long)cf.metric.allMemtablesLiveDataSize.value()).longValue();
                }
                return total;
            }
        });
        this.allMemtablesOnHeapDataSize = Metrics.newGauge((MetricName)this.factory.createMetricName("AllMemtablesOnHeapDataSize"), (Gauge)new Gauge<Long>(){

            public Long value() {
                long total = 0L;
                for (ColumnFamilyStore cf : ks.getColumnFamilyStores()) {
                    total += ((Long)cf.metric.allMemtablesOnHeapSize.value()).longValue();
                }
                return total;
            }
        });
        this.allMemtablesOffHeapDataSize = Metrics.newGauge((MetricName)this.factory.createMetricName("AllMemtablesOffHeapDataSize"), (Gauge)new Gauge<Long>(){

            public Long value() {
                long total = 0L;
                for (ColumnFamilyStore cf : ks.getColumnFamilyStores()) {
                    total += ((Long)cf.metric.allMemtablesOffHeapSize.value()).longValue();
                }
                return total;
            }
        });
        this.memtableSwitchCount = Metrics.newGauge((MetricName)this.factory.createMetricName("MemtableSwitchCount"), (Gauge)new Gauge<Long>(){

            public Long value() {
                long sum = 0L;
                for (ColumnFamilyStore cf : ks.getColumnFamilyStores()) {
                    sum += cf.metric.memtableSwitchCount.count();
                }
                return sum;
            }
        });
        this.pendingCompactions = Metrics.newGauge((MetricName)this.factory.createMetricName("PendingCompactions"), (Gauge)new Gauge<Integer>(){

            public Integer value() {
                int sum = 0;
                for (ColumnFamilyStore cf : ks.getColumnFamilyStores()) {
                    sum += ((Integer)cf.metric.pendingCompactions.value()).intValue();
                }
                return sum;
            }
        });
        this.pendingFlushes = Metrics.newGauge((MetricName)this.factory.createMetricName("PendingFlushes"), (Gauge)new Gauge<Integer>(){

            public Integer value() {
                int sum = 0;
                for (ColumnFamilyStore cf : ks.getColumnFamilyStores()) {
                    sum = (int)((long)sum + cf.metric.pendingFlushes.count());
                }
                return sum;
            }
        });
        this.liveDiskSpaceUsed = Metrics.newGauge((MetricName)this.factory.createMetricName("LiveDiskSpaceUsed"), (Gauge)new Gauge<Long>(){

            public Long value() {
                long sum = 0L;
                for (ColumnFamilyStore cf : ks.getColumnFamilyStores()) {
                    sum += cf.metric.liveDiskSpaceUsed.count();
                }
                return sum;
            }
        });
        this.totalDiskSpaceUsed = Metrics.newGauge((MetricName)this.factory.createMetricName("TotalDiskSpaceUsed"), (Gauge)new Gauge<Long>(){

            public Long value() {
                long sum = 0L;
                for (ColumnFamilyStore cf : ks.getColumnFamilyStores()) {
                    sum += cf.metric.totalDiskSpaceUsed.count();
                }
                return sum;
            }
        });
        this.bloomFilterDiskSpaceUsed = Metrics.newGauge((MetricName)this.factory.createMetricName("BloomFilterDiskSpaceUsed"), (Gauge)new Gauge<Long>(){

            public Long value() {
                long total = 0L;
                for (ColumnFamilyStore cf : ks.getColumnFamilyStores()) {
                    total += ((Long)cf.metric.bloomFilterDiskSpaceUsed.value()).longValue();
                }
                return total;
            }
        });
    }

    public void release() {
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("AllMemtablesLiveDataSize"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("AllMemtablesOnHeapDataSize"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("AllMemtablesOffHeapDataSize"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("MemtableLiveDataSize"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("MemtableOnHeapDataSize"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("MemtableOffHeapDataSize"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("MemtableColumnsCount"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("MemtableSwitchCount"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("PendingFlushes"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("PendingCompactions"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("LiveDiskSpaceUsed"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("TotalDiskSpaceUsed"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("BloomFilterDiskSpaceUsed"));
    }

    class KeyspaceMetricNameFactory
    implements MetricNameFactory {
        private final String keyspaceName;

        KeyspaceMetricNameFactory(Keyspace ks) {
            this.keyspaceName = ks.getName();
        }

        @Override
        public MetricName createMetricName(String metricName) {
            String groupName = ColumnFamilyMetrics.class.getPackage().getName();
            StringBuilder mbeanName = new StringBuilder();
            mbeanName.append(groupName).append(":");
            mbeanName.append("type=Keyspace");
            mbeanName.append(",keyspace=").append(this.keyspaceName);
            mbeanName.append(",name=").append(metricName);
            return new MetricName(groupName, "keyspace", metricName, this.keyspaceName, mbeanName.toString());
        }
    }
}

