/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.util.RatioGauge;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.metrics.LatencyMetrics;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.apache.cassandra.utils.EstimatedHistogram;

public class ColumnFamilyMetrics {
    public final Gauge<Long> memtableOnHeapSize;
    public final Gauge<Long> memtableOffHeapSize;
    public final Gauge<Long> memtableLiveDataSize;
    public final Gauge<Long> allMemtablesOnHeapSize;
    public final Gauge<Long> allMemtablesOffHeapSize;
    public final Gauge<Long> allMemtablesLiveDataSize;
    public final Gauge<Long> memtableColumnsCount;
    public final Counter memtableSwitchCount;
    public final Gauge<Double> compressionRatio;
    public final Gauge<long[]> estimatedRowSizeHistogram;
    public final Gauge<long[]> estimatedColumnCountHistogram;
    public final Histogram sstablesPerReadHistogram;
    public final LatencyMetrics readLatency;
    public final LatencyMetrics rangeLatency;
    public final LatencyMetrics writeLatency;
    public final Counter pendingFlushes;
    public final Gauge<Integer> pendingCompactions;
    public final Gauge<Integer> liveSSTableCount;
    public final Counter liveDiskSpaceUsed;
    public final Counter totalDiskSpaceUsed;
    public final Gauge<Long> minRowSize;
    public final Gauge<Long> maxRowSize;
    public final Gauge<Long> meanRowSize;
    public final Gauge<Long> bloomFilterFalsePositives;
    public final Gauge<Long> recentBloomFilterFalsePositives;
    public final Gauge<Double> bloomFilterFalseRatio;
    public final Gauge<Double> recentBloomFilterFalseRatio;
    public final Gauge<Long> bloomFilterDiskSpaceUsed;
    public final Gauge<Double> keyCacheHitRate;
    public final Histogram tombstoneScannedHistogram;
    public final Histogram liveScannedHistogram;
    public final Gauge<Long> trueSnapshotsSize;
    public final Counter rowCacheHitOutOfRange;
    public final Counter rowCacheHit;
    public final Counter rowCacheMiss;
    public final Timer coordinatorReadLatency;
    public final Timer coordinatorScanLatency;
    public final Timer waitingOnFreeMemtableSpace;
    private final MetricNameFactory factory;
    public final Counter speculativeRetries;
    @Deprecated
    public final EstimatedHistogram sstablesPerRead = new EstimatedHistogram(35);
    @Deprecated
    public final EstimatedHistogram recentSSTablesPerRead = new EstimatedHistogram(35);

    public ColumnFamilyMetrics(final ColumnFamilyStore cfs) {
        this.factory = new ColumnFamilyMetricNameFactory(cfs);
        this.memtableColumnsCount = Metrics.newGauge((MetricName)this.factory.createMetricName("MemtableColumnsCount"), (Gauge)new Gauge<Long>(){

            public Long value() {
                return cfs.getDataTracker().getView().getCurrentMemtable().getOperations();
            }
        });
        this.memtableOnHeapSize = Metrics.newGauge((MetricName)this.factory.createMetricName("MemtableHeapSize"), (Gauge)new Gauge<Long>(){

            public Long value() {
                return cfs.getDataTracker().getView().getCurrentMemtable().getAllocator().onHeap().owns();
            }
        });
        this.memtableOffHeapSize = Metrics.newGauge((MetricName)this.factory.createMetricName("MemtableHeapSize"), (Gauge)new Gauge<Long>(){

            public Long value() {
                return cfs.getDataTracker().getView().getCurrentMemtable().getAllocator().offHeap().owns();
            }
        });
        this.memtableLiveDataSize = Metrics.newGauge((MetricName)this.factory.createMetricName("MemtableLiveDataSize"), (Gauge)new Gauge<Long>(){

            public Long value() {
                return cfs.getDataTracker().getView().getCurrentMemtable().getLiveDataSize();
            }
        });
        this.allMemtablesOnHeapSize = Metrics.newGauge((MetricName)this.factory.createMetricName("AllMemtablesHeapSize"), (Gauge)new Gauge<Long>(){

            public Long value() {
                long size = 0L;
                for (ColumnFamilyStore cfs2 : cfs.concatWithIndexes()) {
                    size += cfs2.getDataTracker().getView().getCurrentMemtable().getAllocator().onHeap().owns();
                }
                return size;
            }
        });
        this.allMemtablesOffHeapSize = Metrics.newGauge((MetricName)this.factory.createMetricName("AllMemtablesHeapSize"), (Gauge)new Gauge<Long>(){

            public Long value() {
                long size = 0L;
                for (ColumnFamilyStore cfs2 : cfs.concatWithIndexes()) {
                    size += cfs2.getDataTracker().getView().getCurrentMemtable().getAllocator().offHeap().owns();
                }
                return size;
            }
        });
        this.allMemtablesLiveDataSize = Metrics.newGauge((MetricName)this.factory.createMetricName("AllMemtablesLiveDataSize"), (Gauge)new Gauge<Long>(){

            public Long value() {
                long size = 0L;
                for (ColumnFamilyStore cfs2 : cfs.concatWithIndexes()) {
                    size += cfs2.getDataTracker().getView().getCurrentMemtable().getLiveDataSize();
                }
                return size;
            }
        });
        this.memtableSwitchCount = Metrics.newCounter((MetricName)this.factory.createMetricName("MemtableSwitchCount"));
        this.estimatedRowSizeHistogram = Metrics.newGauge((MetricName)this.factory.createMetricName("EstimatedRowSizeHistogram"), (Gauge)new Gauge<long[]>(){

            public long[] value() {
                long[] histogram = new long[90];
                for (SSTableReader sstable : cfs.getSSTables()) {
                    long[] rowSize = sstable.getEstimatedRowSize().getBuckets(false);
                    for (int i = 0; i < histogram.length; ++i) {
                        int n = i;
                        histogram[n] = histogram[n] + rowSize[i];
                    }
                }
                return histogram;
            }
        });
        this.estimatedColumnCountHistogram = Metrics.newGauge((MetricName)this.factory.createMetricName("EstimatedColumnCountHistogram"), (Gauge)new Gauge<long[]>(){

            public long[] value() {
                long[] histogram = new long[90];
                for (SSTableReader sstable : cfs.getSSTables()) {
                    long[] columnSize = sstable.getEstimatedColumnCount().getBuckets(false);
                    for (int i = 0; i < histogram.length; ++i) {
                        int n = i;
                        histogram[n] = histogram[n] + columnSize[i];
                    }
                }
                return histogram;
            }
        });
        this.sstablesPerReadHistogram = Metrics.newHistogram((MetricName)this.factory.createMetricName("SSTablesPerReadHistogram"), (boolean)true);
        this.compressionRatio = Metrics.newGauge((MetricName)this.factory.createMetricName("CompressionRatio"), (Gauge)new Gauge<Double>(){

            public Double value() {
                double sum = 0.0;
                int total = 0;
                for (SSTableReader sstable : cfs.getSSTables()) {
                    if (sstable.getCompressionRatio() == -1.0) continue;
                    sum += sstable.getCompressionRatio();
                    ++total;
                }
                return total != 0 ? sum / (double)total : 0.0;
            }
        });
        this.readLatency = new LatencyMetrics(this.factory, "Read");
        this.writeLatency = new LatencyMetrics(this.factory, "Write");
        this.rangeLatency = new LatencyMetrics(this.factory, "Range");
        this.pendingFlushes = Metrics.newCounter((MetricName)this.factory.createMetricName("PendingFlushes"));
        this.pendingCompactions = Metrics.newGauge((MetricName)this.factory.createMetricName("PendingCompactions"), (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return cfs.getCompactionStrategy().getEstimatedRemainingTasks();
            }
        });
        this.liveSSTableCount = Metrics.newGauge((MetricName)this.factory.createMetricName("LiveSSTableCount"), (Gauge)new Gauge<Integer>(){

            public Integer value() {
                return cfs.getDataTracker().getSSTables().size();
            }
        });
        this.liveDiskSpaceUsed = Metrics.newCounter((MetricName)this.factory.createMetricName("LiveDiskSpaceUsed"));
        this.totalDiskSpaceUsed = Metrics.newCounter((MetricName)this.factory.createMetricName("TotalDiskSpaceUsed"));
        this.minRowSize = Metrics.newGauge((MetricName)this.factory.createMetricName("MinRowSize"), (Gauge)new Gauge<Long>(){

            public Long value() {
                long min = 0L;
                for (SSTableReader sstable : cfs.getSSTables()) {
                    if (min != 0L && sstable.getEstimatedRowSize().min() >= min) continue;
                    min = sstable.getEstimatedRowSize().min();
                }
                return min;
            }
        });
        this.maxRowSize = Metrics.newGauge((MetricName)this.factory.createMetricName("MaxRowSize"), (Gauge)new Gauge<Long>(){

            public Long value() {
                long max = 0L;
                for (SSTableReader sstable : cfs.getSSTables()) {
                    if (sstable.getEstimatedRowSize().max() <= max) continue;
                    max = sstable.getEstimatedRowSize().max();
                }
                return max;
            }
        });
        this.meanRowSize = Metrics.newGauge((MetricName)this.factory.createMetricName("MeanRowSize"), (Gauge)new Gauge<Long>(){

            public Long value() {
                long sum = 0L;
                long count = 0L;
                for (SSTableReader sstable : cfs.getSSTables()) {
                    long n = sstable.getEstimatedRowSize().count();
                    sum += sstable.getEstimatedRowSize().mean() * n;
                    count += n;
                }
                return count > 0L ? sum / count : 0L;
            }
        });
        this.bloomFilterFalsePositives = Metrics.newGauge((MetricName)this.factory.createMetricName("BloomFilterFalsePositives"), (Gauge)new Gauge<Long>(){

            public Long value() {
                long count = 0L;
                for (SSTableReader sstable : cfs.getSSTables()) {
                    count += sstable.getBloomFilterFalsePositiveCount();
                }
                return count;
            }
        });
        this.recentBloomFilterFalsePositives = Metrics.newGauge((MetricName)this.factory.createMetricName("RecentBloomFilterFalsePositives"), (Gauge)new Gauge<Long>(){

            public Long value() {
                long count = 0L;
                for (SSTableReader sstable : cfs.getSSTables()) {
                    count += sstable.getRecentBloomFilterFalsePositiveCount();
                }
                return count;
            }
        });
        this.bloomFilterFalseRatio = Metrics.newGauge((MetricName)this.factory.createMetricName("BloomFilterFalseRatio"), (Gauge)new Gauge<Double>(){

            public Double value() {
                long falseCount = 0L;
                long trueCount = 0L;
                for (SSTableReader sstable : cfs.getSSTables()) {
                    falseCount += sstable.getBloomFilterFalsePositiveCount();
                    trueCount += sstable.getBloomFilterTruePositiveCount();
                }
                if (falseCount == 0L && trueCount == 0L) {
                    return 0.0;
                }
                return (double)falseCount / (double)(trueCount + falseCount);
            }
        });
        this.recentBloomFilterFalseRatio = Metrics.newGauge((MetricName)this.factory.createMetricName("RecentBloomFilterFalseRatio"), (Gauge)new Gauge<Double>(){

            public Double value() {
                long falseCount = 0L;
                long trueCount = 0L;
                for (SSTableReader sstable : cfs.getSSTables()) {
                    falseCount += sstable.getRecentBloomFilterFalsePositiveCount();
                    trueCount += sstable.getRecentBloomFilterTruePositiveCount();
                }
                if (falseCount == 0L && trueCount == 0L) {
                    return 0.0;
                }
                return (double)falseCount / (double)(trueCount + falseCount);
            }
        });
        this.bloomFilterDiskSpaceUsed = Metrics.newGauge((MetricName)this.factory.createMetricName("BloomFilterDiskSpaceUsed"), (Gauge)new Gauge<Long>(){

            public Long value() {
                long total = 0L;
                for (SSTableReader sst : cfs.getSSTables()) {
                    total += sst.getBloomFilterSerializedSize();
                }
                return total;
            }
        });
        this.speculativeRetries = Metrics.newCounter((MetricName)this.factory.createMetricName("SpeculativeRetries"));
        this.keyCacheHitRate = Metrics.newGauge((MetricName)this.factory.createMetricName("KeyCacheHitRate"), (Gauge)new RatioGauge(){

            protected double getNumerator() {
                long hits = 0L;
                for (SSTableReader sstable : cfs.getSSTables()) {
                    hits += sstable.getKeyCacheHit();
                }
                return hits;
            }

            protected double getDenominator() {
                long requests = 0L;
                for (SSTableReader sstable : cfs.getSSTables()) {
                    requests += sstable.getKeyCacheRequest();
                }
                return Math.max(requests, 1L);
            }
        });
        this.tombstoneScannedHistogram = Metrics.newHistogram((MetricName)this.factory.createMetricName("TombstoneScannedHistogram"), (boolean)true);
        this.liveScannedHistogram = Metrics.newHistogram((MetricName)this.factory.createMetricName("LiveScannedHistogram"), (boolean)true);
        this.coordinatorReadLatency = Metrics.newTimer((MetricName)this.factory.createMetricName("CoordinatorReadLatency"), (TimeUnit)TimeUnit.MICROSECONDS, (TimeUnit)TimeUnit.SECONDS);
        this.coordinatorScanLatency = Metrics.newTimer((MetricName)this.factory.createMetricName("CoordinatorScanLatency"), (TimeUnit)TimeUnit.MICROSECONDS, (TimeUnit)TimeUnit.SECONDS);
        this.waitingOnFreeMemtableSpace = Metrics.newTimer((MetricName)this.factory.createMetricName("WaitingOnFreeMemtableSpace"), (TimeUnit)TimeUnit.MICROSECONDS, (TimeUnit)TimeUnit.SECONDS);
        this.trueSnapshotsSize = Metrics.newGauge((MetricName)this.factory.createMetricName("SnapshotsSize"), (Gauge)new Gauge<Long>(){

            public Long value() {
                return cfs.trueSnapshotsSize();
            }
        });
        this.rowCacheHitOutOfRange = Metrics.newCounter((MetricName)this.factory.createMetricName("RowCacheHitOutOfRange"));
        this.rowCacheHit = Metrics.newCounter((MetricName)this.factory.createMetricName("RowCacheHit"));
        this.rowCacheMiss = Metrics.newCounter((MetricName)this.factory.createMetricName("RowCacheMiss"));
    }

    public void updateSSTableIterated(int count) {
        this.sstablesPerReadHistogram.update(count);
        this.recentSSTablesPerRead.add(count);
        this.sstablesPerRead.add(count);
    }

    public void release() {
        this.readLatency.release();
        this.writeLatency.release();
        this.rangeLatency.release();
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("AllMemtablesDataSize"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("MemtableColumnsCount"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("MemtableDataSize"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("MemtableSwitchCount"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("CompressionRatio"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("EstimatedRowSizeHistogram"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("EstimatedColumnCountHistogram"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("SSTablesPerReadHistogram"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("PendingFlushes"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("LiveSSTableCount"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("LiveDiskSpaceUsed"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("TotalDiskSpaceUsed"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("MinRowSize"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("MaxRowSize"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("MeanRowSize"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("BloomFilterFalsePositives"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("RecentBloomFilterFalsePositives"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("BloomFilterFalseRatio"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("RecentBloomFilterFalseRatio"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("BloomFilterDiskSpaceUsed"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("KeyCacheHitRate"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("SpeculativeRetries"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("TombstoneScannedHistogram"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("LiveScannedHistogram"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("CoordinatorReadLatency"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("CoordinatorScanLatency"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("SnapshotsSize"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("RowCacheHitOutOfRange"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("RowCacheHit"));
        Metrics.defaultRegistry().removeMetric(this.factory.createMetricName("RowCacheHitMiss"));
    }

    class ColumnFamilyMetricNameFactory
    implements MetricNameFactory {
        private final String keyspaceName;
        private final String columnFamilyName;
        private final boolean isIndex;

        ColumnFamilyMetricNameFactory(ColumnFamilyStore cfs) {
            this.keyspaceName = cfs.keyspace.getName();
            this.columnFamilyName = cfs.name;
            this.isIndex = cfs.isIndex();
        }

        @Override
        public MetricName createMetricName(String metricName) {
            String groupName = ColumnFamilyMetrics.class.getPackage().getName();
            String type = this.isIndex ? "IndexColumnFamily" : "ColumnFamily";
            StringBuilder mbeanName = new StringBuilder();
            mbeanName.append(groupName).append(":");
            mbeanName.append("type=").append(type);
            mbeanName.append(",keyspace=").append(this.keyspaceName);
            mbeanName.append(",scope=").append(this.columnFamilyName);
            mbeanName.append(",name=").append(metricName);
            return new MetricName(groupName, type, metricName, this.keyspaceName + "." + this.columnFamilyName, mbeanName.toString());
        }
    }
}

