/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.transport.Event;
import org.apache.cassandra.transport.messages.ResultMessage;

public abstract class SchemaAlteringStatement
extends CFStatement
implements CQLStatement {
    private final boolean isColumnFamilyLevel;

    protected SchemaAlteringStatement() {
        super(null);
        this.isColumnFamilyLevel = false;
    }

    protected SchemaAlteringStatement(CFName name) {
        super(name);
        this.isColumnFamilyLevel = true;
    }

    @Override
    public int getBoundTerms() {
        return 0;
    }

    @Override
    public void prepareKeyspace(ClientState state) throws InvalidRequestException {
        if (this.isColumnFamilyLevel) {
            super.prepareKeyspace(state);
        }
    }

    @Override
    public ParsedStatement.Prepared prepare() {
        return new ParsedStatement.Prepared(this);
    }

    public abstract Event.SchemaChange changeEvent();

    public abstract void announceMigration(boolean var1) throws RequestValidationException;

    @Override
    public ResultMessage execute(QueryState state, QueryOptions options) throws RequestValidationException {
        this.announceMigration(false);
        return new ResultMessage.SchemaChange(this.changeEvent());
    }

    @Override
    public ResultMessage executeInternal(QueryState state, QueryOptions options) {
        try {
            this.announceMigration(true);
            return new ResultMessage.SchemaChange(this.changeEvent());
        }
        catch (RequestValidationException e) {
            throw new RuntimeException(e);
        }
    }
}

