/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDGen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CounterId
implements Comparable<CounterId> {
    private static final Logger logger = LoggerFactory.getLogger(CounterId.class);
    public static final int LENGTH = 16;
    private final ByteBuffer id;

    private static LocalCounterIdHolder localId() {
        return LocalId.instance;
    }

    public static CounterId getLocalId() {
        return CounterId.localId().get();
    }

    public static synchronized void renewLocalId() {
        CounterId.localId().renew(FBUtilities.timestampMicros());
    }

    public static CounterId fromInt(int n) {
        long lowBits = 0xC000000000000000L | (long)n;
        return new CounterId(ByteBuffer.allocate(16).putLong(0, 0L).putLong(8, lowBits));
    }

    public static CounterId wrap(ByteBuffer id) {
        return new CounterId(id);
    }

    public static CounterId wrap(ByteBuffer bb, int offset) {
        ByteBuffer dup = bb.duplicate();
        dup.position(offset);
        dup.limit(dup.position() + 16);
        return CounterId.wrap(dup);
    }

    private CounterId(ByteBuffer id) {
        if (id.remaining() != 16) {
            throw new IllegalArgumentException("A CounterId representation is exactly 16 bytes");
        }
        this.id = id;
    }

    public static CounterId generate() {
        return new CounterId(ByteBuffer.wrap(UUIDGen.getTimeUUIDBytes()));
    }

    public ByteBuffer bytes() {
        return this.id;
    }

    public boolean isLocalId() {
        return this.equals(CounterId.getLocalId());
    }

    @Override
    public int compareTo(CounterId o) {
        return ByteBufferUtil.compareSubArrays(this.id, this.id.position(), o.id, o.id.position(), 16);
    }

    public String toString() {
        return UUIDGen.getUUID(this.id).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CounterId otherId = (CounterId)o;
        return this.id.equals(otherId.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    private static class LocalCounterIdHolder {
        private final AtomicReference<CounterId> current;

        LocalCounterIdHolder() {
            CounterId id = SystemKeyspace.getCurrentLocalCounterId();
            if (id == null) {
                id = CounterId.generate();
                logger.info("No saved local counter id, using newly generated: {}", (Object)id);
                SystemKeyspace.writeCurrentLocalCounterId(id, FBUtilities.timestampMicros());
            } else {
                logger.info("Using saved local counter id: {}", (Object)id);
            }
            this.current = new AtomicReference<CounterId>(id);
        }

        synchronized void renew(long now) {
            CounterId newCounterId = CounterId.generate();
            SystemKeyspace.writeCurrentLocalCounterId(newCounterId, now);
            this.current.set(newCounterId);
        }

        CounterId get() {
            return this.current.get();
        }
    }

    private static class LocalId {
        static final LocalCounterIdHolder instance = new LocalCounterIdHolder();

        private LocalId() {
        }
    }
}

