/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.serializers;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class CollectionSerializer<T>
implements TypeSerializer<T> {
    protected abstract List<ByteBuffer> serializeValues(T var1);

    protected abstract int getElementCount(T var1);

    public abstract T deserializeForNativeProtocol(ByteBuffer var1, int var2);

    public abstract void validateForNativeProtocol(ByteBuffer var1, int var2);

    @Override
    public ByteBuffer serialize(T value) {
        List<ByteBuffer> values = this.serializeValues(value);
        return CollectionSerializer.pack(values, this.getElementCount(value), 3);
    }

    @Override
    public T deserialize(ByteBuffer bytes) {
        return this.deserializeForNativeProtocol(bytes, 3);
    }

    @Override
    public void validate(ByteBuffer bytes) throws MarshalException {
        this.validateForNativeProtocol(bytes, 3);
    }

    public static ByteBuffer pack(List<ByteBuffer> buffers, int elements, int version) {
        int size = 0;
        for (ByteBuffer bb : buffers) {
            size += CollectionSerializer.sizeOfValue(bb, version);
        }
        ByteBuffer result = ByteBuffer.allocate(CollectionSerializer.sizeOfCollectionSize(elements, version) + size);
        CollectionSerializer.writeCollectionSize(result, elements, version);
        for (ByteBuffer bb : buffers) {
            CollectionSerializer.writeValue(result, bb, version);
        }
        return (ByteBuffer)result.flip();
    }

    protected static void writeCollectionSize(ByteBuffer output, int elements, int version) {
        if (version >= 3) {
            output.putInt(elements);
        } else {
            output.putShort((short)elements);
        }
    }

    public static int readCollectionSize(ByteBuffer input, int version) {
        return version >= 3 ? input.getInt() : ByteBufferUtil.readShortLength(input);
    }

    protected static int sizeOfCollectionSize(int elements, int version) {
        return version >= 3 ? 4 : 2;
    }

    protected static void writeValue(ByteBuffer output, ByteBuffer value, int version) {
        if (version >= 3) {
            if (value == null) {
                output.putInt(-1);
                return;
            }
            output.putInt(value.remaining());
            output.put(value.duplicate());
        } else {
            assert (value != null);
            output.putShort((short)value.remaining());
            output.put(value.duplicate());
        }
    }

    public static ByteBuffer readValue(ByteBuffer input, int version) {
        if (version >= 3) {
            int size = input.getInt();
            if (size < 0) {
                return null;
            }
            return ByteBufferUtil.readBytes(input, size);
        }
        return ByteBufferUtil.readBytesWithShortLength(input);
    }

    protected static int sizeOfValue(ByteBuffer value, int version) {
        if (version >= 3) {
            return value == null ? 4 : 4 + value.remaining();
        }
        assert (value != null);
        return 2 + value.remaining();
    }
}

