/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TimestampSerializer;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.serializers.UUIDSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.UUIDGen;

public class UUIDType
extends AbstractType<UUID> {
    public static final UUIDType instance = new UUIDType();

    UUIDType() {
    }

    @Override
    public int compare(ByteBuffer b1, ByteBuffer b2) {
        int c;
        int v2;
        if (b1 == null || b1.remaining() < 16) {
            return b2 == null || b2.remaining() < 16 ? 0 : -1;
        }
        if (b2 == null || b2.remaining() < 16) {
            return 1;
        }
        int s1 = b1.position();
        int s2 = b2.position();
        int v1 = b1.get(s1 + 6) >> 4 & 0xF;
        if (v1 != (v2 = b2.get(s2 + 6) >> 4 & 0xF)) {
            return v1 - v2;
        }
        if (v1 == 1 && (c = UUIDType.compareTimestampBytes(b1, b2)) != 0) {
            return c;
        }
        for (int i = 0; i < 16; ++i) {
            int c2 = (b1.get(s1 + i) & 0xFF) - (b2.get(s2 + i) & 0xFF);
            if (c2 == 0) continue;
            return c2;
        }
        return 0;
    }

    private static int compareTimestampBytes(ByteBuffer o1, ByteBuffer o2) {
        int o1Pos = o1.position();
        int o2Pos = o2.position();
        int d = (o1.get(o1Pos + 6) & 0xF) - (o2.get(o2Pos + 6) & 0xF);
        if (d != 0) {
            return d;
        }
        d = (o1.get(o1Pos + 7) & 0xFF) - (o2.get(o2Pos + 7) & 0xFF);
        if (d != 0) {
            return d;
        }
        d = (o1.get(o1Pos + 4) & 0xFF) - (o2.get(o2Pos + 4) & 0xFF);
        if (d != 0) {
            return d;
        }
        d = (o1.get(o1Pos + 5) & 0xFF) - (o2.get(o2Pos + 5) & 0xFF);
        if (d != 0) {
            return d;
        }
        d = (o1.get(o1Pos) & 0xFF) - (o2.get(o2Pos) & 0xFF);
        if (d != 0) {
            return d;
        }
        d = (o1.get(o1Pos + 1) & 0xFF) - (o2.get(o2Pos + 1) & 0xFF);
        if (d != 0) {
            return d;
        }
        d = (o1.get(o1Pos + 2) & 0xFF) - (o2.get(o2Pos + 2) & 0xFF);
        if (d != 0) {
            return d;
        }
        return (o1.get(o1Pos + 3) & 0xFF) - (o2.get(o2Pos + 3) & 0xFF);
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        if (source.isEmpty()) {
            return ByteBufferUtil.EMPTY_BYTE_BUFFER;
        }
        if (TimeUUIDType.regexPattern.matcher(source).matches()) {
            try {
                UUID uuid = UUID.fromString(source);
                return ByteBuffer.wrap(UUIDGen.decompose(uuid));
            }
            catch (IllegalArgumentException e) {
                throw new MarshalException(String.format("unable to make UUID from '%s'", source), e);
            }
        }
        try {
            return ByteBuffer.wrap(UUIDGen.getTimeUUIDBytes(TimestampSerializer.dateStringToTimestamp(source)));
        }
        catch (MarshalException e) {
            throw new MarshalException(String.format("unable to make version 1 UUID from '%s'", source), e);
        }
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.UUID;
    }

    @Override
    public TypeSerializer<UUID> getSerializer() {
        return UUIDSerializer.instance;
    }
}

