/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.db.marshal.AbstractCompositeType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicCompositeType
extends AbstractCompositeType {
    private static final Logger logger = LoggerFactory.getLogger(DynamicCompositeType.class);
    private final Map<Byte, AbstractType<?>> aliases;
    private static final Map<Map<Byte, AbstractType<?>>, DynamicCompositeType> instances = new HashMap();

    public static synchronized DynamicCompositeType getInstance(TypeParser parser) throws ConfigurationException, SyntaxException {
        return DynamicCompositeType.getInstance(parser.getAliasParameters());
    }

    public static synchronized DynamicCompositeType getInstance(Map<Byte, AbstractType<?>> aliases) {
        DynamicCompositeType dct = instances.get(aliases);
        if (dct == null) {
            dct = new DynamicCompositeType(aliases);
            instances.put(aliases, dct);
        }
        return dct;
    }

    private DynamicCompositeType(Map<Byte, AbstractType<?>> aliases) {
        this.aliases = aliases;
    }

    @Override
    protected boolean readIsStatic(ByteBuffer bb) {
        return false;
    }

    private AbstractType<?> getComparator(ByteBuffer bb) {
        try {
            int header = ByteBufferUtil.readShortLength(bb);
            if ((header & 0x8000) == 0) {
                String name = ByteBufferUtil.string(ByteBufferUtil.readBytes(bb, header));
                return TypeParser.parse(name);
            }
            return this.aliases.get((byte)(header & 0xFF));
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected AbstractType<?> getComparator(int i, ByteBuffer bb) {
        return this.getComparator(bb);
    }

    @Override
    protected AbstractType<?> getComparator(int i, ByteBuffer bb1, ByteBuffer bb2) {
        AbstractType<?> comp2;
        AbstractType<?> comp1 = this.getComparator(bb1);
        if (comp1 != (comp2 = this.getComparator(bb2))) {
            int cmp = comp1.getClass().getSimpleName().compareTo(comp2.getClass().getSimpleName());
            if (cmp != 0) {
                return cmp < 0 ? FixedValueComparator.alwaysLesserThan : FixedValueComparator.alwaysGreaterThan;
            }
            cmp = comp1.getClass().getName().compareTo(comp2.getClass().getName());
            if (cmp != 0) {
                return cmp < 0 ? FixedValueComparator.alwaysLesserThan : FixedValueComparator.alwaysGreaterThan;
            }
        }
        return comp1;
    }

    @Override
    protected AbstractType<?> getAndAppendComparator(int i, ByteBuffer bb, StringBuilder sb) {
        try {
            int header = ByteBufferUtil.readShortLength(bb);
            if ((header & 0x8000) == 0) {
                String name = ByteBufferUtil.string(ByteBufferUtil.readBytes(bb, header));
                sb.append(name).append("@");
                return TypeParser.parse(name);
            }
            sb.append((char)(header & 0xFF)).append("@");
            return this.aliases.get((byte)(header & 0xFF));
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected AbstractCompositeType.ParsedComparator parseComparator(int i, String part) {
        return new DynamicParsedComparator(part);
    }

    @Override
    protected AbstractType<?> validateComparator(int i, ByteBuffer bb) throws MarshalException {
        AbstractType<?> comparator = null;
        if (bb.remaining() < 2) {
            throw new MarshalException("Not enough bytes to header of the comparator part of component " + i);
        }
        int header = ByteBufferUtil.readShortLength(bb);
        if ((header & 0x8000) == 0) {
            if (bb.remaining() < header) {
                throw new MarshalException("Not enough bytes to read comparator name of component " + i);
            }
            ByteBuffer value = ByteBufferUtil.readBytes(bb, header);
            String valueStr = null;
            try {
                valueStr = ByteBufferUtil.string(value);
                comparator = TypeParser.parse(valueStr);
            }
            catch (CharacterCodingException ce) {
                logger.error("Failed with [{}] when decoding the byte buffer in ByteBufferUtil.string()", (Object)ce.toString());
            }
            catch (Exception e) {
                logger.error("Failed to parse value string \"{}\" with exception: [{}]", (Object)valueStr, (Object)e.toString());
            }
        } else {
            comparator = this.aliases.get((byte)(header & 0xFF));
        }
        if (comparator == null) {
            throw new MarshalException("Cannot find comparator for component " + i);
        }
        return comparator;
    }

    @Override
    public ByteBuffer decompose(Object ... objects) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCompatibleWith(AbstractType<?> previous) {
        if (this == previous) {
            return true;
        }
        if (!(previous instanceof DynamicCompositeType)) {
            return false;
        }
        DynamicCompositeType cp = (DynamicCompositeType)previous;
        if (this.aliases.size() < cp.aliases.size()) {
            return false;
        }
        for (Map.Entry<Byte, AbstractType<?>> entry : cp.aliases.entrySet()) {
            AbstractType<?> tprev = entry.getValue();
            AbstractType<?> tnew = this.aliases.get(entry.getKey());
            if (tnew != null && tnew == tprev) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + TypeParser.stringifyAliasesParameters(this.aliases);
    }

    private static class FixedValueComparator
    extends AbstractType<Void> {
        public static final FixedValueComparator alwaysLesserThan = new FixedValueComparator(-1);
        public static final FixedValueComparator alwaysGreaterThan = new FixedValueComparator(1);
        private final int cmp;

        public FixedValueComparator(int cmp) {
            this.cmp = cmp;
        }

        @Override
        public int compare(ByteBuffer v1, ByteBuffer v2) {
            return this.cmp;
        }

        @Override
        public Void compose(ByteBuffer bytes) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuffer decompose(Void value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getString(ByteBuffer bytes) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuffer fromString(String str) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void validate(ByteBuffer bytes) {
            throw new UnsupportedOperationException();
        }

        @Override
        public TypeSerializer<Void> getSerializer() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isByteOrderComparable() {
            return false;
        }
    }

    private class DynamicParsedComparator
    implements AbstractCompositeType.ParsedComparator {
        final AbstractType<?> type;
        final boolean isAlias;
        final String comparatorName;
        final String remainingPart;

        DynamicParsedComparator(String part) {
            String[] splits = part.split("@");
            if (splits.length != 2) {
                throw new IllegalArgumentException("Invalid component representation: " + part);
            }
            this.comparatorName = splits[0];
            this.remainingPart = splits[1];
            try {
                AbstractType<?> t = null;
                if (this.comparatorName.length() == 1) {
                    t = (AbstractType<?>)DynamicCompositeType.this.aliases.get((byte)this.comparatorName.charAt(0));
                }
                boolean bl = this.isAlias = t != null;
                if (!this.isAlias) {
                    t = TypeParser.parse(this.comparatorName);
                }
                this.type = t;
            }
            catch (SyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            catch (ConfigurationException e) {
                throw new IllegalArgumentException(e);
            }
        }

        @Override
        public AbstractType<?> getAbstractType() {
            return this.type;
        }

        @Override
        public String getRemainingPart() {
            return this.remainingPart;
        }

        @Override
        public int getComparatorSerializedSize() {
            return this.isAlias ? 2 : 2 + ByteBufferUtil.bytes(this.comparatorName).remaining();
        }

        @Override
        public void serializeComparator(ByteBuffer bb) {
            int header = 0;
            header = this.isAlias ? 0x8000 | (byte)this.comparatorName.charAt(0) & 0xFF : this.comparatorName.length();
            ByteBufferUtil.writeShortLength(bb, header);
            if (!this.isAlias) {
                bb.put(ByteBufferUtil.bytes(this.comparatorName));
            }
        }
    }
}

