/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.composites;

import java.nio.ByteBuffer;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.CompoundComposite;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.memory.AbstractAllocator;

public class CompoundSparseCellName
extends CompoundComposite
implements CellName {
    private static final ByteBuffer[] EMPTY_PREFIX = new ByteBuffer[0];
    private static final long HEAP_SIZE = ObjectSizes.measure(new CompoundSparseCellName(null, false));
    protected final ColumnIdentifier columnName;

    CompoundSparseCellName(ColumnIdentifier columnName, boolean isStatic) {
        this(EMPTY_PREFIX, columnName, isStatic);
    }

    CompoundSparseCellName(ByteBuffer[] elements, ColumnIdentifier columnName, boolean isStatic) {
        this(elements, elements.length, columnName, isStatic);
    }

    CompoundSparseCellName(ByteBuffer[] elements, int size, ColumnIdentifier columnName, boolean isStatic) {
        super(elements, size, isStatic);
        this.columnName = columnName;
    }

    @Override
    public int size() {
        return this.size + 1;
    }

    @Override
    public ByteBuffer get(int i) {
        return i == this.size ? this.columnName.bytes : this.elements[i];
    }

    @Override
    public int clusteringSize() {
        return this.size;
    }

    @Override
    public ColumnIdentifier cql3ColumnName(CFMetaData metadata) {
        return this.columnName;
    }

    @Override
    public ByteBuffer collectionElement() {
        return null;
    }

    @Override
    public boolean isCollectionCell() {
        return false;
    }

    @Override
    public boolean isSameCQL3RowAs(CellNameType type, CellName other) {
        if (this.clusteringSize() != other.clusteringSize() || other.isStatic() != this.isStatic()) {
            return false;
        }
        for (int i = 0; i < this.clusteringSize(); ++i) {
            if (type.subtype(i).compare(this.elements[i], other.get(i)) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public CellName copy(CFMetaData cfm, AbstractAllocator allocator) {
        if (this.elements.length == 0) {
            return this;
        }
        return new CompoundSparseCellName(this.elementsCopy(allocator), this.columnName, this.isStatic());
    }

    public static class WithCollection
    extends CompoundSparseCellName {
        private static final long HEAP_SIZE = ObjectSizes.measure(new WithCollection(null, ByteBufferUtil.EMPTY_BYTE_BUFFER, false));
        private final ByteBuffer collectionElement;

        WithCollection(ColumnIdentifier columnName, ByteBuffer collectionElement, boolean isStatic) {
            this(EMPTY_PREFIX, columnName, collectionElement, isStatic);
        }

        WithCollection(ByteBuffer[] elements, ColumnIdentifier columnName, ByteBuffer collectionElement, boolean isStatic) {
            this(elements, elements.length, columnName, collectionElement, isStatic);
        }

        WithCollection(ByteBuffer[] elements, int size, ColumnIdentifier columnName, ByteBuffer collectionElement, boolean isStatic) {
            super(elements, size, columnName, isStatic);
            this.collectionElement = collectionElement;
        }

        @Override
        public int size() {
            return this.size + 2;
        }

        @Override
        public ByteBuffer get(int i) {
            return i == this.size + 1 ? this.collectionElement : super.get(i);
        }

        @Override
        public ByteBuffer collectionElement() {
            return this.collectionElement;
        }

        @Override
        public boolean isCollectionCell() {
            return true;
        }

        @Override
        public CellName copy(CFMetaData cfm, AbstractAllocator allocator) {
            return new WithCollection(this.elements.length == 0 ? this.elements : this.elementsCopy(allocator), this.size, this.columnName, allocator.clone(this.collectionElement), this.isStatic());
        }

        @Override
        public long unsharedHeapSize() {
            return super.unsharedHeapSize() + ObjectSizes.sizeOnHeapOf(this.collectionElement);
        }

        @Override
        public long excessHeapSizeExcludingData() {
            return super.excessHeapSizeExcludingData() + ObjectSizes.sizeOnHeapExcludingData(this.collectionElement);
        }
    }
}

