/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.security.MessageDigest;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.BufferDeletedCell;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.DeletedCell;
import org.apache.cassandra.db.NativeCell;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.memory.AbstractAllocator;
import org.apache.cassandra.utils.memory.MemoryUtil;
import org.apache.cassandra.utils.memory.MemtableAllocator;
import org.apache.cassandra.utils.memory.NativeAllocator;

public class NativeDeletedCell
extends NativeCell
implements DeletedCell {
    private static final long SIZE = ObjectSizes.measure(new NativeDeletedCell());

    private NativeDeletedCell() {
    }

    public NativeDeletedCell(NativeAllocator allocator, OpOrder.Group writeOp, DeletedCell copyOf) {
        super(allocator, writeOp, copyOf);
    }

    @Override
    public Cell reconcile(Cell cell) {
        if (cell instanceof DeletedCell) {
            return super.reconcile(cell);
        }
        return cell.reconcile(this);
    }

    @Override
    public boolean isLive() {
        return false;
    }

    @Override
    public boolean isLive(long now) {
        return false;
    }

    @Override
    public int getLocalDeletionTime() {
        int v = this.getInt(this.valueStartOffset());
        return MemoryUtil.INVERTED_ORDER ? Integer.reverseBytes(v) : v;
    }

    @Override
    public int serializationFlags() {
        return 1;
    }

    @Override
    public void validateFields(CFMetaData metadata) throws MarshalException {
        this.validateName(metadata);
        if ((int)(this.internalSize() - (long)this.valueStartOffset()) != 4) {
            throw new MarshalException("A tombstone value should be 4 bytes long");
        }
        if (this.getLocalDeletionTime() < 0) {
            throw new MarshalException("The local deletion time should not be negative");
        }
    }

    @Override
    public void updateDigest(MessageDigest digest) {
        this.updateWithName(digest);
        FBUtilities.updateWithLong(digest, this.timestamp());
        FBUtilities.updateWithByte(digest, this.serializationFlags());
    }

    @Override
    public DeletedCell localCopy(CFMetaData metadata, AbstractAllocator allocator) {
        return new BufferDeletedCell(this.copy(metadata, allocator), allocator.clone(this.value()), this.timestamp());
    }

    @Override
    public DeletedCell localCopy(CFMetaData metadata, MemtableAllocator allocator, OpOrder.Group opGroup) {
        return allocator.clone(this, metadata, opGroup);
    }

    @Override
    public boolean equals(Cell cell) {
        return this.timestamp() == cell.timestamp() && this.getLocalDeletionTime() == cell.getLocalDeletionTime() && this.name().equals(cell.name());
    }

    @Override
    public long excessHeapSizeExcludingData() {
        return SIZE;
    }

    @Override
    public long unsharedHeapSize() {
        return SIZE;
    }
}

