/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.BufferCell;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.CounterUpdateCell;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.memory.AbstractAllocator;
import org.apache.cassandra.utils.memory.MemtableAllocator;

public class BufferCounterUpdateCell
extends BufferCell
implements CounterUpdateCell {
    public BufferCounterUpdateCell(CellName name, long value, long timestamp) {
        this(name, ByteBufferUtil.bytes(value), timestamp);
    }

    public BufferCounterUpdateCell(CellName name, ByteBuffer value, long timestamp) {
        super(name, value, timestamp);
    }

    @Override
    public long delta() {
        return this.value().getLong(this.value.position());
    }

    @Override
    public Cell diff(Cell cell) {
        throw new UnsupportedOperationException("This operation is unsupported on CounterUpdateCell.");
    }

    @Override
    public Cell reconcile(Cell cell) {
        if (!cell.isLive()) {
            return this.timestamp > cell.timestamp() ? this : cell;
        }
        assert (cell instanceof CounterUpdateCell) : "Wrong class type.";
        CounterUpdateCell c = (CounterUpdateCell)cell;
        return new BufferCounterUpdateCell(this.name, this.delta() + c.delta(), this.timestamp + c.timestamp());
    }

    @Override
    public int serializationFlags() {
        return 8;
    }

    @Override
    public Cell localCopy(CFMetaData metadata, AbstractAllocator allocator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Cell localCopy(CFMetaData metadata, MemtableAllocator allocator, OpOrder.Group opGroup) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getString(CellNameType comparator) {
        return String.format("%s:%s@%d", comparator.getString(this.name()), ByteBufferUtil.toLong(this.value), this.timestamp());
    }
}

