/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.UUID;
import org.apache.cassandra.cache.CacheKey;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNames;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.Pair;

public class CounterCacheKey
implements CacheKey {
    private static final long EMPTY_SIZE = ObjectSizes.measure(new CounterCacheKey(null, ByteBufferUtil.EMPTY_BYTE_BUFFER, CellNames.simpleDense(ByteBuffer.allocate(1)))) + ObjectSizes.measure(new UUID(0L, 0L));
    public final UUID cfId;
    public final byte[] partitionKey;
    public final byte[] cellName;

    private CounterCacheKey(UUID cfId, ByteBuffer partitionKey, CellName cellName) {
        this.cfId = cfId;
        this.partitionKey = ByteBufferUtil.getArray(partitionKey);
        this.cellName = ByteBufferUtil.getArray(cellName.toByteBuffer());
    }

    public static CounterCacheKey create(UUID cfId, ByteBuffer partitionKey, CellName cellName) {
        return new CounterCacheKey(cfId, partitionKey, cellName);
    }

    @Override
    public CacheKey.PathInfo getPathInfo() {
        Pair<String, String> cf = Schema.instance.getCF(this.cfId);
        return new CacheKey.PathInfo((String)cf.left, (String)cf.right, this.cfId);
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE + ObjectSizes.sizeOfArray(this.partitionKey) + ObjectSizes.sizeOfArray(this.cellName);
    }

    public String toString() {
        return String.format("CounterCacheKey(%s, %s, %s)", this.cfId, ByteBufferUtil.bytesToHex(ByteBuffer.wrap(this.partitionKey)), ByteBufferUtil.bytesToHex(ByteBuffer.wrap(this.cellName)));
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.cfId, this.partitionKey, this.cellName});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CounterCacheKey)) {
            return false;
        }
        CounterCacheKey cck = (CounterCacheKey)o;
        return this.cfId.equals(cck.cfId) && Arrays.equals(this.partitionKey, cck.partitionKey) && Arrays.equals(this.cellName, cck.cellName);
    }
}

