/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import com.google.common.collect.AbstractIterator;
import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.db.BufferCell;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.composites.AbstractComposite;
import org.apache.cassandra.db.composites.CType;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.CellNameType;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.composites.Composites;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.memory.AbstractAllocator;

public class ColumnSlice {
    public static final ColumnSlice ALL_COLUMNS = new ColumnSlice(Composites.EMPTY, Composites.EMPTY);
    public static final ColumnSlice[] ALL_COLUMNS_ARRAY = new ColumnSlice[]{ALL_COLUMNS};
    public final Composite start;
    public final Composite finish;

    public ColumnSlice(Composite start, Composite finish) {
        assert (start != null && finish != null);
        this.start = start;
        this.finish = finish;
    }

    public boolean isAlwaysEmpty(CellNameType comparator, boolean reversed) {
        Comparator<Composite> orderedComparator = reversed ? comparator.reverseComparator() : comparator;
        return !this.start.isEmpty() && !this.finish.isEmpty() && orderedComparator.compare(this.start, this.finish) > 0;
    }

    public boolean includes(Comparator<Composite> cmp, Composite name) {
        return cmp.compare(this.start, name) <= 0 && (this.finish.isEmpty() || cmp.compare(this.finish, name) >= 0);
    }

    public boolean isBefore(Comparator<Composite> cmp, Composite name) {
        return !this.finish.isEmpty() && cmp.compare(this.finish, name) < 0;
    }

    public boolean intersects(List<ByteBuffer> minCellNames, List<ByteBuffer> maxCellNames, CellNameType comparator, boolean reversed) {
        Composite sEnd;
        assert (minCellNames.size() == maxCellNames.size());
        Composite sStart = reversed ? this.finish : this.start;
        Composite composite = sEnd = reversed ? this.start : this.finish;
        if (this.compare(sStart, maxCellNames, comparator, true) > 0 || this.compare(sEnd, minCellNames, comparator, false) < 0) {
            return false;
        }
        for (int i = 0; i < minCellNames.size(); ++i) {
            ByteBuffer f;
            AbstractType<?> t = comparator.subtype(i);
            ByteBuffer s = i < sStart.size() ? sStart.get(i) : ByteBufferUtil.EMPTY_BYTE_BUFFER;
            ByteBuffer byteBuffer = f = i < sEnd.size() ? sEnd.get(i) : ByteBufferUtil.EMPTY_BYTE_BUFFER;
            if (i > 0 && (i < sEnd.size() && t.compare(f, minCellNames.get(i)) < 0 || i < sStart.size() && t.compare(s, maxCellNames.get(i)) > 0)) {
                return false;
            }
            if (i >= sStart.size() || i >= sEnd.size() || t.compare(s, f) != 0) break;
        }
        return true;
    }

    private int compare(Composite sliceBounds, List<ByteBuffer> sstableBounds, CellNameType comparator, boolean isSliceStart) {
        for (int i = 0; i < sstableBounds.size(); ++i) {
            if (i >= sliceBounds.size()) {
                return isSliceStart ? -1 : 1;
            }
            int comparison = comparator.subtype(i).compare(sliceBounds.get(i), sstableBounds.get(i));
            if (comparison == 0) continue;
            return comparison;
        }
        return 0;
    }

    public final int hashCode() {
        int hashCode = 31 + this.start.hashCode();
        return 31 * hashCode + this.finish.hashCode();
    }

    public final boolean equals(Object o) {
        if (!(o instanceof ColumnSlice)) {
            return false;
        }
        ColumnSlice that = (ColumnSlice)o;
        return this.start.equals(that.start) && this.finish.equals(that.finish);
    }

    public String toString() {
        return "[" + ByteBufferUtil.bytesToHex(this.start.toByteBuffer()) + ", " + ByteBufferUtil.bytesToHex(this.finish.toByteBuffer()) + "]";
    }

    private static Cell fakeCell(Composite name) {
        return new BufferCell(name instanceof CellName ? (CellName)name : new FakeCellName(name), ByteBufferUtil.EMPTY_BYTE_BUFFER);
    }

    private static class FakeCellName
    extends AbstractComposite
    implements CellName {
        private final Composite prefix;

        private FakeCellName(Composite prefix) {
            this.prefix = prefix;
        }

        @Override
        public int size() {
            return this.prefix.size();
        }

        @Override
        public boolean isStatic() {
            return this.prefix.isStatic();
        }

        @Override
        public ByteBuffer get(int i) {
            return this.prefix.get(i);
        }

        @Override
        public Composite.EOC eoc() {
            return this.prefix.eoc();
        }

        @Override
        public ByteBuffer toByteBuffer() {
            return this.prefix.toByteBuffer();
        }

        @Override
        public int clusteringSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ColumnIdentifier cql3ColumnName(CFMetaData metadata) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuffer collectionElement() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isCollectionCell() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isSameCQL3RowAs(CellNameType type, CellName other) {
            throw new UnsupportedOperationException();
        }

        @Override
        public CellName copy(CFMetaData cfm, AbstractAllocator allocator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long excessHeapSizeExcludingData() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long unsharedHeapSize() {
            throw new UnsupportedOperationException();
        }
    }

    public static class NavigableSetIterator
    extends AbstractIterator<Cell> {
        private final NavigableSet<Cell> set;
        private final ColumnSlice[] slices;
        private int idx = 0;
        private Iterator<Cell> currentSlice;

        public NavigableSetIterator(NavigableSet<Cell> set, ColumnSlice[] slices) {
            this.set = set;
            this.slices = slices;
        }

        protected Cell computeNext() {
            if (this.currentSlice == null) {
                if (this.idx >= this.slices.length) {
                    return (Cell)this.endOfData();
                }
                ColumnSlice slice = this.slices[this.idx++];
                this.currentSlice = slice.start.isEmpty() ? (slice.finish.isEmpty() ? this.set.iterator() : this.set.headSet(ColumnSlice.fakeCell(slice.finish), true).iterator()) : (slice.finish.isEmpty() ? this.set.tailSet(ColumnSlice.fakeCell(slice.start), true).iterator() : this.set.subSet(ColumnSlice.fakeCell(slice.start), true, ColumnSlice.fakeCell(slice.finish), true).iterator());
            }
            if (this.currentSlice.hasNext()) {
                return this.currentSlice.next();
            }
            this.currentSlice = null;
            return this.computeNext();
        }
    }

    public static class Serializer
    implements IVersionedSerializer<ColumnSlice> {
        private final CType type;

        public Serializer(CType type) {
            this.type = type;
        }

        @Override
        public void serialize(ColumnSlice cs, DataOutputPlus out, int version) throws IOException {
            CType.Serializer serializer = this.type.serializer();
            serializer.serialize(cs.start, out);
            serializer.serialize(cs.finish, out);
        }

        @Override
        public ColumnSlice deserialize(DataInput in, int version) throws IOException {
            CType.Serializer serializer = this.type.serializer();
            Composite start = (Composite)serializer.deserialize(in);
            Composite finish = (Composite)serializer.deserialize(in);
            return new ColumnSlice(start, finish);
        }

        @Override
        public long serializedSize(ColumnSlice cs, int version) {
            CType.Serializer serializer = this.type.serializer();
            return serializer.serializedSize(cs.start, TypeSizes.NATIVE) + serializer.serializedSize(cs.finish, TypeSizes.NATIVE);
        }
    }
}

