/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.composites;

import java.nio.ByteBuffer;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.composites.AbstractComposite;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.memory.AbstractAllocator;

public class CompoundComposite
extends AbstractComposite {
    private static final long EMPTY_SIZE = ObjectSizes.measure(new CompoundComposite(null, 0, false));
    final ByteBuffer[] elements;
    final int size;
    final boolean isStatic;

    CompoundComposite(ByteBuffer[] elements, int size, boolean isStatic) {
        this.elements = elements;
        this.size = size;
        this.isStatic = isStatic;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public ByteBuffer get(int i) {
        return i >= this.size() ? null : this.elements[i];
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    protected ByteBuffer[] elementsCopy(AbstractAllocator allocator) {
        ByteBuffer[] elementsCopy = new ByteBuffer[this.size];
        for (int i = 0; i < this.size; ++i) {
            elementsCopy[i] = allocator.clone(this.elements[i]);
        }
        return elementsCopy;
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE + ObjectSizes.sizeOnHeapOf(this.elements);
    }

    public long excessHeapSizeExcludingData() {
        return EMPTY_SIZE + ObjectSizes.sizeOnHeapExcludingData(this.elements);
    }

    @Override
    public Composite copy(CFMetaData cfm, AbstractAllocator allocator) {
        return new CompoundComposite(this.elementsCopy(allocator), this.size, this.isStatic);
    }
}

