/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.cql3.AbstractMarker;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.Term;

public class Relation {
    private final ColumnIdentifier entity;
    private final Type relationType;
    private final Term.Raw value;
    private final List<Term.Raw> inValues;
    public final boolean onToken;
    public final ColumnIdentifier previousInTuple;

    private Relation(ColumnIdentifier entity, Type type, Term.Raw value, List<Term.Raw> inValues, boolean onToken, ColumnIdentifier previousInTuple) {
        this.entity = entity;
        this.relationType = type;
        this.value = value;
        this.inValues = inValues;
        this.onToken = onToken;
        this.previousInTuple = previousInTuple;
    }

    public Relation(ColumnIdentifier entity, Type type, Term.Raw value) {
        this(entity, type, value, null, false, null);
    }

    public Relation(ColumnIdentifier entity, Type type, Term.Raw value, boolean onToken) {
        this(entity, type, value, null, onToken, null);
    }

    public Relation(ColumnIdentifier entity, Type type, Term.Raw value, ColumnIdentifier previousInTuple) {
        this(entity, type, value, null, false, previousInTuple);
    }

    public static Relation createInRelation(ColumnIdentifier entity) {
        return new Relation(entity, Type.IN, null, new ArrayList<Term.Raw>(), false, null);
    }

    public Type operator() {
        return this.relationType;
    }

    public ColumnIdentifier getEntity() {
        return this.entity;
    }

    public Term.Raw getValue() {
        assert (this.relationType != Type.IN || this.value == null || this.value instanceof AbstractMarker.INRaw);
        return this.value;
    }

    public List<Term.Raw> getInValues() {
        assert (this.relationType == Type.IN);
        return this.inValues;
    }

    public void addInValue(Term.Raw t) {
        this.inValues.add(t);
    }

    public String toString() {
        if (this.relationType == Type.IN) {
            return String.format("%s IN %s", this.entity, this.inValues);
        }
        return String.format("%s %s %s", new Object[]{this.entity, this.relationType, this.value});
    }

    public static enum Type {
        EQ,
        LT,
        LTE,
        GTE,
        GT,
        IN,
        CONTAINS,
        CONTAINS_KEY;


        public boolean allowsIndexQuery() {
            switch (this) {
                case EQ: 
                case CONTAINS: 
                case CONTAINS_KEY: {
                    return true;
                }
            }
            return false;
        }
    }
}

