/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.Lists;
import org.apache.cassandra.cql3.Maps;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Sets;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.composites.CellName;
import org.apache.cassandra.db.composites.Composite;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.utils.ByteBufferUtil;

public class ColumnCondition {
    public final ColumnDefinition column;
    private final Term collectionElement;
    private final Term value;

    private ColumnCondition(ColumnDefinition column, Term collectionElement, Term value) {
        this.column = column;
        this.collectionElement = collectionElement;
        this.value = value;
    }

    public static ColumnCondition equal(ColumnDefinition column, Term value) {
        return new ColumnCondition(column, null, value);
    }

    public static ColumnCondition equal(ColumnDefinition column, Term collectionElement, Term value) {
        return new ColumnCondition(column, collectionElement, value);
    }

    public void collectMarkerSpecification(VariableSpecifications boundNames) {
        if (this.collectionElement != null) {
            this.collectionElement.collectMarkerSpecification(boundNames);
        }
        this.value.collectMarkerSpecification(boundNames);
    }

    public WithOptions with(QueryOptions options) {
        return new WithOptions(options);
    }

    public static class Raw {
        private final Term.Raw value;
        private final Term.Raw collectionElement;

        private Raw(Term.Raw value, Term.Raw collectionElement) {
            this.value = value;
            this.collectionElement = collectionElement;
        }

        public static Raw simpleEqual(Term.Raw value) {
            return new Raw(value, null);
        }

        public static Raw collectionEqual(Term.Raw value, Term.Raw collectionElement) {
            return new Raw(value, collectionElement);
        }

        public ColumnCondition prepare(String keyspace, ColumnDefinition receiver) throws InvalidRequestException {
            if (receiver.type instanceof CounterColumnType) {
                throw new InvalidRequestException("Condtions on counters are not supported");
            }
            if (this.collectionElement == null) {
                return ColumnCondition.equal(receiver, this.value.prepare(keyspace, receiver));
            }
            if (!receiver.type.isCollection()) {
                throw new InvalidRequestException(String.format("Invalid element access syntax for non-collection column %s", receiver.name));
            }
            switch (((CollectionType)receiver.type).kind) {
                case LIST: {
                    return ColumnCondition.equal(receiver, this.collectionElement.prepare(keyspace, Lists.indexSpecOf(receiver)), this.value.prepare(keyspace, Lists.valueSpecOf(receiver)));
                }
                case SET: {
                    throw new InvalidRequestException(String.format("Invalid element access syntax for set column %s", receiver.name));
                }
                case MAP: {
                    return ColumnCondition.equal(receiver, this.collectionElement.prepare(keyspace, Maps.keySpecOf(receiver)), this.value.prepare(keyspace, Maps.valueSpecOf(receiver)));
                }
            }
            throw new AssertionError();
        }
    }

    public class WithOptions {
        private final QueryOptions options;

        private WithOptions(QueryOptions options) {
            this.options = options;
        }

        public boolean equalsTo(WithOptions other) throws InvalidRequestException {
            if (!this.column().equals(other.column())) {
                return false;
            }
            if (this.collectionElement() == null != (other.collectionElement() == null)) {
                return false;
            }
            if (this.collectionElement() != null) {
                Int32Type comparator;
                assert (ColumnCondition.this.column.type instanceof ListType || ColumnCondition.this.column.type instanceof MapType);
                AbstractType abstractType = comparator = ColumnCondition.this.column.type instanceof ListType ? Int32Type.instance : ((MapType)ColumnCondition.this.column.type).keys;
                if (comparator.compare(this.collectionElement().bindAndGet(this.options), other.collectionElement().bindAndGet(this.options)) != 0) {
                    return false;
                }
            }
            return this.value().bindAndGet(this.options).equals(other.value().bindAndGet(other.options));
        }

        private ColumnDefinition column() {
            return ColumnCondition.this.column;
        }

        private Term collectionElement() {
            return ColumnCondition.this.collectionElement;
        }

        private Term value() {
            return ColumnCondition.this.value;
        }

        public ByteBuffer getCollectionElementValue() throws InvalidRequestException {
            return ColumnCondition.this.collectionElement == null ? null : ColumnCondition.this.collectionElement.bindAndGet(this.options);
        }

        public boolean appliesTo(Composite rowPrefix, ColumnFamily current, long now) throws InvalidRequestException {
            if (ColumnCondition.this.column.type instanceof CollectionType) {
                return this.collectionAppliesTo((CollectionType)ColumnCondition.this.column.type, rowPrefix, current, now);
            }
            assert (ColumnCondition.this.collectionElement == null);
            Cell c = current.getColumn(current.metadata().comparator.create(rowPrefix, ColumnCondition.this.column));
            ByteBuffer v = ColumnCondition.this.value.bindAndGet(this.options);
            return v == null ? c == null || !c.isLive(now) : c != null && c.isLive(now) && c.value().equals(v);
        }

        private boolean collectionAppliesTo(CollectionType type, Composite rowPrefix, ColumnFamily current, final long now) throws InvalidRequestException {
            Term.Terminal v = ColumnCondition.this.value.bind(this.options);
            if (ColumnCondition.this.collectionElement != null && type instanceof MapType) {
                ByteBuffer e = ColumnCondition.this.collectionElement.bindAndGet(this.options);
                if (e == null) {
                    throw new InvalidRequestException("Invalid null value for map access");
                }
                return this.mapElementAppliesTo((MapType)type, current, rowPrefix, e, v.get(this.options), now);
            }
            CellName name = current.metadata().comparator.create(rowPrefix, ColumnCondition.this.column);
            ColumnSlice[] collectionSlice = new ColumnSlice[]{name.slice()};
            UnmodifiableIterator iter = Iterators.filter(current.iterator(collectionSlice), (Predicate)new Predicate<Cell>(){

                public boolean apply(Cell c) {
                    return c.isLive(now);
                }
            });
            if (v == null) {
                return !iter.hasNext();
            }
            if (ColumnCondition.this.collectionElement != null) {
                assert (type instanceof ListType);
                ByteBuffer e = ColumnCondition.this.collectionElement.bindAndGet(this.options);
                if (e == null) {
                    throw new InvalidRequestException("Invalid null value for list access");
                }
                return this.listElementAppliesTo((ListType)type, (Iterator<Cell>)iter, e, v.get(this.options));
            }
            switch (type.kind) {
                case LIST: {
                    return this.listAppliesTo((ListType)type, (Iterator<Cell>)iter, ((Lists.Value)v).elements);
                }
                case SET: {
                    return this.setAppliesTo((SetType)type, (Iterator<Cell>)iter, ((Sets.Value)v).elements);
                }
                case MAP: {
                    return this.mapAppliesTo((MapType)type, (Iterator<Cell>)iter, ((Maps.Value)v).map);
                }
            }
            throw new AssertionError();
        }

        private boolean listAppliesTo(ListType type, Iterator<Cell> iter, List<ByteBuffer> elements) {
            for (ByteBuffer e : elements) {
                if (iter.hasNext() && type.elements.compare(iter.next().value(), e) == 0) continue;
                return false;
            }
            return !iter.hasNext();
        }

        private boolean listElementAppliesTo(ListType type, Iterator<Cell> iter, ByteBuffer element, ByteBuffer value) throws InvalidRequestException {
            int idx = ByteBufferUtil.toInt(element);
            if (idx < 0) {
                throw new InvalidRequestException(String.format("Invalid negative list index %d", idx));
            }
            int adv = Iterators.advance(iter, (int)idx);
            if (adv != idx || !iter.hasNext()) {
                throw new InvalidRequestException(String.format("List index %d out of bound, list has size %d", idx, adv));
            }
            return type.elements.compare(iter.next().value(), value) == 0;
        }

        private boolean setAppliesTo(SetType type, Iterator<Cell> iter, Set<ByteBuffer> elements) {
            TreeSet<ByteBuffer> remaining = new TreeSet<ByteBuffer>(type.elements);
            remaining.addAll(elements);
            while (iter.hasNext()) {
                if (remaining.isEmpty()) {
                    return false;
                }
                if (remaining.remove(iter.next().name().collectionElement())) continue;
                return false;
            }
            return remaining.isEmpty();
        }

        private boolean mapAppliesTo(MapType type, Iterator<Cell> iter, Map<ByteBuffer, ByteBuffer> elements) {
            TreeMap<ByteBuffer, ByteBuffer> remaining = new TreeMap<ByteBuffer, ByteBuffer>(type.keys);
            remaining.putAll(elements);
            while (iter.hasNext()) {
                if (remaining.isEmpty()) {
                    return false;
                }
                Cell c = iter.next();
                ByteBuffer previous = (ByteBuffer)remaining.remove(c.name().collectionElement());
                if (previous != null && type.values.compare(previous, c.value()) == 0) continue;
                return false;
            }
            return remaining.isEmpty();
        }

        private boolean mapElementAppliesTo(MapType type, ColumnFamily current, Composite rowPrefix, ByteBuffer element, ByteBuffer value, long now) {
            CellName name = current.getComparator().create(rowPrefix, ColumnCondition.this.column, element);
            Cell c = current.getColumn(name);
            return c != null && c.isLive(now) && type.values.compare(c.value(), value) == 0;
        }
    }
}

