/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionInfo;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.columniterator.OnDiskAtomIterator;
import org.apache.cassandra.db.columniterator.SSTableSliceIterator;
import org.apache.cassandra.db.filter.ColumnCounter;
import org.apache.cassandra.db.filter.ColumnSlice;
import org.apache.cassandra.db.filter.IDiskAtomFilter;
import org.apache.cassandra.db.filter.TombstoneOverwhelmingException;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.tracing.Tracing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliceQueryFilter
implements IDiskAtomFilter {
    private static final Logger logger = LoggerFactory.getLogger(SliceQueryFilter.class);
    public static final Serializer serializer = new Serializer();
    public final ColumnSlice[] slices;
    public final boolean reversed;
    public volatile int count;
    public final int compositesToGroup;
    private ColumnCounter columnCounter;

    public SliceQueryFilter(ByteBuffer start, ByteBuffer finish, boolean reversed, int count) {
        this(new ColumnSlice[]{new ColumnSlice(start, finish)}, reversed, count);
    }

    public SliceQueryFilter(ByteBuffer start, ByteBuffer finish, boolean reversed, int count, int compositesToGroup) {
        this(new ColumnSlice[]{new ColumnSlice(start, finish)}, reversed, count, compositesToGroup);
    }

    public SliceQueryFilter(ColumnSlice[] slices, boolean reversed, int count) {
        this(slices, reversed, count, -1);
    }

    public SliceQueryFilter(ColumnSlice[] slices, boolean reversed, int count, int compositesToGroup) {
        this.slices = slices;
        this.reversed = reversed;
        this.count = count;
        this.compositesToGroup = compositesToGroup;
    }

    @Override
    public SliceQueryFilter cloneShallow() {
        return new SliceQueryFilter(this.slices, this.reversed, this.count, this.compositesToGroup);
    }

    public SliceQueryFilter withUpdatedCount(int newCount) {
        return new SliceQueryFilter(this.slices, this.reversed, newCount, this.compositesToGroup);
    }

    public SliceQueryFilter withUpdatedSlices(ColumnSlice[] newSlices) {
        return new SliceQueryFilter(newSlices, this.reversed, this.count, this.compositesToGroup);
    }

    public SliceQueryFilter withUpdatedStart(ByteBuffer newStart, AbstractType<?> comparator) {
        Comparator<ByteBuffer> cmp = this.reversed ? comparator.reverseComparator : comparator;
        ArrayList<ColumnSlice> newSlices = new ArrayList<ColumnSlice>();
        boolean pastNewStart = false;
        for (int i = 0; i < this.slices.length; ++i) {
            ColumnSlice slice = this.slices[i];
            if (pastNewStart) {
                newSlices.add(slice);
                continue;
            }
            if (this.slices[i].isBefore(cmp, newStart)) continue;
            if (slice.includes(cmp, newStart)) {
                newSlices.add(new ColumnSlice(newStart, slice.finish));
            } else {
                newSlices.add(slice);
            }
            pastNewStart = true;
        }
        return this.withUpdatedSlices(newSlices.toArray(new ColumnSlice[newSlices.size()]));
    }

    public SliceQueryFilter withUpdatedSlice(ByteBuffer start, ByteBuffer finish) {
        return new SliceQueryFilter(new ColumnSlice[]{new ColumnSlice(start, finish)}, this.reversed, this.count, this.compositesToGroup);
    }

    @Override
    public OnDiskAtomIterator getColumnFamilyIterator(final DecoratedKey key, final ColumnFamily cf) {
        assert (cf != null);
        final Iterator<Column> filteredIter = this.reversed ? cf.reverseIterator(this.slices) : cf.iterator(this.slices);
        return new OnDiskAtomIterator(){

            @Override
            public ColumnFamily getColumnFamily() {
                return cf;
            }

            @Override
            public DecoratedKey getKey() {
                return key;
            }

            @Override
            public boolean hasNext() {
                return filteredIter.hasNext();
            }

            @Override
            public OnDiskAtom next() {
                return (OnDiskAtom)filteredIter.next();
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public OnDiskAtomIterator getSSTableColumnIterator(SSTableReader sstable, DecoratedKey key) {
        return new SSTableSliceIterator(sstable, key, this.slices, this.reversed);
    }

    @Override
    public OnDiskAtomIterator getSSTableColumnIterator(SSTableReader sstable, FileDataInput file, DecoratedKey key, RowIndexEntry indexEntry) {
        return new SSTableSliceIterator(sstable, file, key, this.slices, this.reversed, indexEntry);
    }

    @Override
    public Comparator<Column> getColumnComparator(AbstractType<?> comparator) {
        return this.reversed ? comparator.columnReverseComparator : comparator.columnComparator;
    }

    @Override
    public void collectReducedColumns(ColumnFamily container, Iterator<Column> reducedColumns, int gcBefore, long now) {
        this.columnCounter = this.columnCounter(container.getComparator(), now);
        DeletionInfo.InOrderTester tester = container.deletionInfo().inOrderTester(this.reversed);
        while (reducedColumns.hasNext()) {
            Column column = reducedColumns.next();
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("collecting %s of %s: %s", this.columnCounter.live(), this.count, column.getString(container.getComparator())));
            }
            this.columnCounter.count(column, tester);
            if (this.columnCounter.live() > this.count) break;
            if (this.respectTombstoneThresholds() && this.columnCounter.ignored() > DatabaseDescriptor.getTombstoneFailureThreshold()) {
                Tracing.trace("Scanned over {} tombstones; query aborted (see tombstone_fail_threshold)", DatabaseDescriptor.getTombstoneFailureThreshold());
                logger.error("Scanned over {} tombstones in {}.{}; query aborted (see tombstone_fail_threshold)", new Object[]{DatabaseDescriptor.getTombstoneFailureThreshold(), container.metadata().ksName, container.metadata().cfName});
                throw new TombstoneOverwhelmingException();
            }
            container.addIfRelevant(column, tester, gcBefore);
        }
        Tracing.trace("Read {} live and {} tombstoned cells", this.columnCounter.live(), this.columnCounter.ignored());
        if (this.respectTombstoneThresholds() && this.columnCounter.ignored() > DatabaseDescriptor.getTombstoneWarnThreshold()) {
            logger.warn("Read {} live and {} tombstoned cells in {}.{} (see tombstone_warn_threshold)", new Object[]{this.columnCounter.live(), this.columnCounter.ignored(), container.metadata().ksName, container.metadata().cfName});
        }
    }

    protected boolean respectTombstoneThresholds() {
        return true;
    }

    @Override
    public int getLiveCount(ColumnFamily cf, long now) {
        return this.columnCounter(cf.getComparator(), now).countAll(cf).live();
    }

    @Override
    public ColumnCounter columnCounter(AbstractType<?> comparator, long now) {
        if (this.compositesToGroup < 0) {
            return new ColumnCounter(now);
        }
        if (this.compositesToGroup == 0) {
            return new ColumnCounter.GroupByPrefix(now, null, 0);
        }
        return new ColumnCounter.GroupByPrefix(now, (CompositeType)comparator, this.compositesToGroup);
    }

    public void trim(ColumnFamily cf, int trimTo, long now) {
        ColumnCounter counter = this.columnCounter(cf.getComparator(), now);
        Collection<Column> columns = this.reversed ? cf.getReverseSortedColumns() : cf.getSortedColumns();
        DeletionInfo.InOrderTester tester = cf.deletionInfo().inOrderTester(this.reversed);
        Iterator<Column> iter = columns.iterator();
        while (iter.hasNext()) {
            Column column = iter.next();
            counter.count(column, tester);
            if (counter.live() <= trimTo) continue;
            iter.remove();
            while (iter.hasNext()) {
                iter.next();
                iter.remove();
            }
        }
    }

    public ByteBuffer start() {
        return this.slices[0].start;
    }

    public ByteBuffer finish() {
        return this.slices[this.slices.length - 1].finish;
    }

    public void setStart(ByteBuffer start) {
        assert (this.slices.length == 1);
        this.slices[0] = new ColumnSlice(start, this.slices[0].finish);
    }

    public int lastCounted() {
        return this.columnCounter == null ? 0 : this.columnCounter.live();
    }

    public int lastIgnored() {
        return this.columnCounter == null ? 0 : this.columnCounter.ignored();
    }

    public int lastLive() {
        return this.columnCounter == null ? 0 : this.columnCounter.live();
    }

    public String toString() {
        return "SliceQueryFilter [reversed=" + this.reversed + ", slices=" + Arrays.toString(this.slices) + ", count=" + this.count + ", toGroup = " + this.compositesToGroup + "]";
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public void updateColumnsLimit(int newLimit) {
        this.count = newLimit;
    }

    @Override
    public boolean maySelectPrefix(Comparator<ByteBuffer> cmp, ByteBuffer prefix) {
        for (ColumnSlice slice : this.slices) {
            if (!slice.includes(cmp, prefix)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldInclude(SSTableReader sstable) {
        List<ByteBuffer> minColumnNames = sstable.getSSTableMetadata().minColumnNames;
        List<ByteBuffer> maxColumnNames = sstable.getSSTableMetadata().maxColumnNames;
        assert (minColumnNames.size() == maxColumnNames.size());
        AbstractType<?> comparator = sstable.metadata.comparator;
        if (minColumnNames.isEmpty() || maxColumnNames.isEmpty()) {
            return true;
        }
        return comparator.intersects(minColumnNames, maxColumnNames, this);
    }

    public static class Serializer
    implements IVersionedSerializer<SliceQueryFilter> {
        @Override
        public void serialize(SliceQueryFilter f, DataOutput out, int version) throws IOException {
            out.writeInt(f.slices.length);
            for (ColumnSlice slice : f.slices) {
                ColumnSlice.serializer.serialize(slice, out, version);
            }
            out.writeBoolean(f.reversed);
            int count = f.count;
            out.writeInt(count);
            out.writeInt(f.compositesToGroup);
        }

        @Override
        public SliceQueryFilter deserialize(DataInput in, int version) throws IOException {
            ColumnSlice[] slices = new ColumnSlice[in.readInt()];
            for (int i = 0; i < slices.length; ++i) {
                slices[i] = ColumnSlice.serializer.deserialize(in, version);
            }
            boolean reversed = in.readBoolean();
            int count = in.readInt();
            int compositesToGroup = -1;
            compositesToGroup = in.readInt();
            return new SliceQueryFilter(slices, reversed, count, compositesToGroup);
        }

        @Override
        public long serializedSize(SliceQueryFilter f, int version) {
            TypeSizes sizes = TypeSizes.NATIVE;
            int size = 0;
            size += sizes.sizeof(f.slices.length);
            for (ColumnSlice slice : f.slices) {
                size = (int)((long)size + ColumnSlice.serializer.serializedSize(slice, version));
            }
            size += sizes.sizeof(f.reversed);
            size += sizes.sizeof(f.count);
            return size += sizes.sizeof(f.compositesToGroup);
        }
    }
}

