/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.statements.CFPropDefs;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.ColumnToCollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.transport.messages.ResultMessage;

public class AlterTableStatement
extends SchemaAlteringStatement {
    public final Type oType;
    public final CQL3Type validator;
    public final ColumnIdentifier columnName;
    private final CFPropDefs cfProps;
    private final Map<ColumnIdentifier, ColumnIdentifier> renames;

    public AlterTableStatement(CFName name, Type type, ColumnIdentifier columnName, CQL3Type validator, CFPropDefs cfProps, Map<ColumnIdentifier, ColumnIdentifier> renames) {
        super(name);
        this.oType = type;
        this.columnName = columnName;
        this.validator = validator;
        this.cfProps = cfProps;
        this.renames = renames;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        state.hasColumnFamilyAccess(this.keyspace(), this.columnFamily(), Permission.ALTER);
    }

    @Override
    public void validate(ClientState state) {
    }

    @Override
    public void announceMigration() throws RequestValidationException {
        CFMetaData meta = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
        CFMetaData cfm = meta.clone();
        CFDefinition cfDef = meta.getCfDef();
        CFDefinition.Name name = this.columnName == null ? null : cfDef.get(this.columnName);
        switch (this.oType) {
            case ADD: {
                AbstractType<?> type;
                if (cfDef.isCompact) {
                    throw new InvalidRequestException("Cannot add new column to a compact CF");
                }
                if (name != null) {
                    switch (name.kind) {
                        case KEY_ALIAS: 
                        case COLUMN_ALIAS: {
                            throw new InvalidRequestException(String.format("Invalid column name %s because it conflicts with a PRIMARY KEY part", this.columnName));
                        }
                        case COLUMN_METADATA: {
                            throw new InvalidRequestException(String.format("Invalid column name %s because it conflicts with an existing column", this.columnName));
                        }
                    }
                }
                if ((type = this.validator.getType()) instanceof CollectionType) {
                    if (!cfDef.isComposite) {
                        throw new InvalidRequestException("Cannot use collection types with non-composite PRIMARY KEY");
                    }
                    if (cfDef.cfm.isSuper()) {
                        throw new InvalidRequestException("Cannot use collection types with Super column family");
                    }
                    HashMap<ByteBuffer, CollectionType> collections = cfDef.hasCollections ? new HashMap<ByteBuffer, CollectionType>(cfDef.getCollectionType().defined) : new HashMap();
                    collections.put(this.columnName.key, (CollectionType)type);
                    ColumnToCollectionType newColType = ColumnToCollectionType.getInstance(collections);
                    ArrayList ctypes = new ArrayList(((CompositeType)cfm.comparator).types);
                    if (cfDef.hasCollections) {
                        ctypes.set(ctypes.size() - 1, newColType);
                    } else {
                        ctypes.add(newColType);
                    }
                    cfm.comparator = CompositeType.getInstance(ctypes);
                }
                Integer componentIndex = cfDef.isComposite ? Integer.valueOf(((CompositeType)meta.comparator).types.size() - (cfDef.hasCollections ? 2 : 1)) : null;
                cfm.addColumnDefinition(ColumnDefinition.regularDef(this.columnName.key, type, componentIndex));
                break;
            }
            case ALTER: {
                if (name == null) {
                    throw new InvalidRequestException(String.format("Column %s was not found in table %s", this.columnName, this.columnFamily()));
                }
                switch (name.kind) {
                    case KEY_ALIAS: {
                        AbstractType<?> newType = this.validator.getType();
                        if (newType instanceof CounterColumnType) {
                            throw new InvalidRequestException(String.format("counter type is not supported for PRIMARY KEY part %s", this.columnName));
                        }
                        if (cfDef.hasCompositeKey) {
                            List<AbstractType<?>> oldTypes = ((CompositeType)cfm.getKeyValidator()).types;
                            if (!newType.isValueCompatibleWith(oldTypes.get(name.position))) {
                                throw new ConfigurationException(String.format("Cannot change %s from type %s to type %s: types are incompatible.", this.columnName, oldTypes.get(name.position).asCQL3Type(), this.validator));
                            }
                            ArrayList newTypes = new ArrayList(oldTypes);
                            newTypes.set(name.position, newType);
                            cfm.keyValidator(CompositeType.getInstance(newTypes));
                            break;
                        }
                        if (!newType.isValueCompatibleWith(cfm.getKeyValidator())) {
                            throw new ConfigurationException(String.format("Cannot change %s from type %s to type %s: types are incompatible.", this.columnName, cfm.getKeyValidator().asCQL3Type(), this.validator));
                        }
                        cfm.keyValidator(newType);
                        break;
                    }
                    case COLUMN_ALIAS: {
                        assert (cfDef.isComposite);
                        List<AbstractType<?>> oldTypes = ((CompositeType)cfm.comparator).types;
                        if (!this.validator.getType().isCompatibleWith(oldTypes.get(name.position))) {
                            throw new ConfigurationException(String.format("Cannot change %s from type %s to type %s: types are not order-compatible.", this.columnName, oldTypes.get(name.position).asCQL3Type(), this.validator));
                        }
                        ArrayList newTypes = new ArrayList(oldTypes);
                        newTypes.set(name.position, this.validator.getType());
                        cfm.comparator = CompositeType.getInstance(newTypes);
                        break;
                    }
                    case VALUE_ALIAS: {
                        if (!this.validator.getType().isValueCompatibleWith(cfm.getDefaultValidator())) {
                            throw new ConfigurationException(String.format("Cannot change %s from type %s to type %s: types are incompatible.", this.columnName, cfm.getDefaultValidator().asCQL3Type(), this.validator));
                        }
                        cfm.defaultValidator(this.validator.getType());
                        break;
                    }
                    case COLUMN_METADATA: {
                        ColumnDefinition column = cfm.getColumnDefinition(this.columnName.key);
                        if (!this.validator.getType().isValueCompatibleWith(column.getValidator())) {
                            throw new ConfigurationException(String.format("Cannot change %s from type %s to type %s: types are incompatible.", this.columnName, column.getValidator().asCQL3Type(), this.validator));
                        }
                        column.setValidator(this.validator.getType());
                    }
                }
                break;
            }
            case DROP: {
                if (cfDef.isCompact) {
                    throw new InvalidRequestException("Cannot drop columns from a compact CF");
                }
                if (!cfDef.isComposite) {
                    throw new InvalidRequestException("Cannot drop columns from a non-CQL3 CF");
                }
                if (name == null) {
                    throw new InvalidRequestException(String.format("Column %s was not found in table %s", this.columnName, this.columnFamily()));
                }
                switch (name.kind) {
                    case KEY_ALIAS: 
                    case COLUMN_ALIAS: {
                        throw new InvalidRequestException(String.format("Cannot drop PRIMARY KEY part %s", this.columnName));
                    }
                    case COLUMN_METADATA: {
                        ColumnDefinition toDelete = null;
                        for (ColumnDefinition columnDef : cfm.regularColumns()) {
                            if (!columnDef.name.equals(this.columnName.key)) continue;
                            toDelete = columnDef;
                        }
                        assert (toDelete != null);
                        cfm.removeColumnDefinition(toDelete);
                        cfm.recordColumnDrop(toDelete);
                    }
                }
                break;
            }
            case OPTS: {
                if (this.cfProps == null) {
                    throw new InvalidRequestException(String.format("ALTER COLUMNFAMILY WITH invoked, but no parameters found", new Object[0]));
                }
                this.cfProps.validate();
                this.cfProps.applyToCFMetadata(cfm);
                break;
            }
            case RENAME: {
                for (Map.Entry<ColumnIdentifier, ColumnIdentifier> entry : this.renames.entrySet()) {
                    ColumnIdentifier from = entry.getKey();
                    ColumnIdentifier to = entry.getValue();
                    cfm.renameColumn(from.key, from.toString(), to.key, to.toString());
                }
                break;
            }
        }
        MigrationManager.announceColumnFamilyUpdate(cfm, false);
    }

    public String toString() {
        return String.format("AlterTableStatement(name=%s, type=%s, column=%s, validator=%s)", new Object[]{this.cfName, this.oType, this.columnName, this.validator});
    }

    @Override
    public ResultMessage.SchemaChange.Change changeType() {
        return ResultMessage.SchemaChange.Change.UPDATED;
    }

    public static enum Type {
        ADD,
        ALTER,
        DROP,
        OPTS,
        RENAME;

    }
}

