/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.utils.BoundedStatsDeque;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ArrivalWindow {
    private static final Logger logger = LoggerFactory.getLogger(ArrivalWindow.class);
    private long tLast = 0L;
    private final BoundedStatsDeque arrivalIntervals;
    private final double PHI_FACTOR = 1.0 / Math.log(10.0);
    private static final long MILLI_TO_NANO = 1000000L;
    private final long MAX_INTERVAL_IN_NANO = DatabaseDescriptor.getRpcTimeout() * 1000000L;

    ArrivalWindow(int size) {
        this.arrivalIntervals = new BoundedStatsDeque(size);
    }

    synchronized void add(long value) {
        assert (this.tLast >= 0L);
        if (this.tLast > 0L) {
            long interArrivalTime = value - this.tLast;
            if (interArrivalTime <= this.MAX_INTERVAL_IN_NANO) {
                this.arrivalIntervals.add(interArrivalTime);
            } else {
                logger.debug("Ignoring interval time of {}", (Object)interArrivalTime);
            }
        } else {
            this.arrivalIntervals.add(30000000000L);
        }
        this.tLast = value;
    }

    double mean() {
        return this.arrivalIntervals.mean();
    }

    double phi(long tnow) {
        assert (this.arrivalIntervals.size() > 0 && this.tLast > 0L);
        long t = tnow - this.tLast;
        return (double)t / this.mean();
    }

    public String toString() {
        return StringUtils.join(this.arrivalIntervals.iterator(), (String)" ");
    }
}

