/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.util.Memory;
import org.apache.cassandra.io.util.MemoryInputStream;
import org.apache.cassandra.io.util.MemoryOutputStream;
import org.apache.cassandra.utils.FBUtilities;

public class IndexSummary
implements Closeable {
    public static final IndexSummarySerializer serializer = new IndexSummarySerializer();
    private final int indexInterval;
    private final IPartitioner partitioner;
    private final int summary_size;
    private final Memory bytes;

    public IndexSummary(IPartitioner partitioner, Memory memory, int summary_size, int indexInterval) {
        this.partitioner = partitioner;
        this.indexInterval = indexInterval;
        this.summary_size = summary_size;
        this.bytes = memory;
    }

    public int binarySearch(RowPosition key) {
        int low = 0;
        int mid = this.summary_size;
        int high = mid - 1;
        int result = -1;
        while (low <= high) {
            mid = low + high >> 1;
            result = -DecoratedKey.compareTo(this.partitioner, ByteBuffer.wrap(this.getKey(mid)), key);
            if (result > 0) {
                low = mid + 1;
                continue;
            }
            if (result == 0) {
                return mid;
            }
            high = mid - 1;
        }
        return -mid - (result < 0 ? 1 : 2);
    }

    public int getIndex(int index) {
        return this.bytes.getInt(index << 2);
    }

    public byte[] getKey(int index) {
        long start = this.getIndex(index);
        int keySize = (int)(this.caclculateEnd(index) - start - 8L);
        byte[] key = new byte[keySize];
        this.bytes.getBytes(start, key, 0, keySize);
        return key;
    }

    public long getPosition(int index) {
        return this.bytes.getLong(this.caclculateEnd(index) - 8L);
    }

    private long caclculateEnd(int index) {
        return index == this.summary_size - 1 ? this.bytes.size() : (long)this.getIndex(index + 1);
    }

    public int getIndexInterval() {
        return this.indexInterval;
    }

    public int size() {
        return this.summary_size;
    }

    public long offHeapSize() {
        return this.bytes.size();
    }

    @Override
    public void close() throws IOException {
        this.bytes.free();
    }

    public static class IndexSummarySerializer {
        public void serialize(IndexSummary t, DataOutputStream out) throws IOException {
            out.writeInt(t.indexInterval);
            out.writeInt(t.summary_size);
            out.writeLong(t.bytes.size());
            FBUtilities.copy(new MemoryInputStream(t.bytes), out, t.bytes.size());
        }

        public IndexSummary deserialize(DataInputStream in, IPartitioner partitioner) throws IOException {
            int indexInterval = in.readInt();
            int summary_size = in.readInt();
            long offheap_size = in.readLong();
            Memory memory = Memory.allocate(offheap_size);
            FBUtilities.copy(in, new MemoryOutputStream(memory), offheap_size);
            return new IndexSummary(partitioner, memory, summary_size, indexInterval);
        }
    }
}

