/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.service.paxos.PrepareResponse;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.UUIDGen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaxosState {
    private static final Logger logger = LoggerFactory.getLogger(PaxosState.class);
    private static final Object[] locks = new Object[1024];
    private final Commit promised;
    private final Commit accepted;
    private final Commit mostRecentCommit;

    private static Object lockFor(ByteBuffer key) {
        return locks[(Integer.MAX_VALUE & key.hashCode()) % locks.length];
    }

    public PaxosState(ByteBuffer key, CFMetaData metadata) {
        this(Commit.emptyCommit(key, metadata), Commit.emptyCommit(key, metadata), Commit.emptyCommit(key, metadata));
    }

    public PaxosState(Commit promised, Commit accepted, Commit mostRecentCommit) {
        assert (promised.key == accepted.key && accepted.key == mostRecentCommit.key);
        assert (promised.update.metadata() == accepted.update.metadata() && accepted.update.metadata() == mostRecentCommit.update.metadata());
        this.promised = promised;
        this.accepted = accepted;
        this.mostRecentCommit = mostRecentCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PrepareResponse prepare(Commit toPrepare) {
        PrepareResponse prepareResponse;
        PaxosState state;
        long start = System.nanoTime();
        try {
            Object object = PaxosState.lockFor(toPrepare.key);
            synchronized (object) {
                state = SystemKeyspace.loadPaxosState(toPrepare.key, toPrepare.update.metadata());
                if (toPrepare.isAfter(state.promised)) {
                    Tracing.trace("Promising ballot {}", toPrepare.ballot);
                    SystemKeyspace.savePaxosPromise(toPrepare);
                    PrepareResponse prepareResponse2 = new PrepareResponse(true, state.accepted, state.mostRecentCommit);
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 6] lbl10 : MonitorExitStatement: MONITOREXIT : var3_2
                    Keyspace.open((String)toPrepare.update.metadata().ksName).getColumnFamilyStore((UUID)toPrepare.update.metadata().cfId).metric.casPrepare.addNano(System.nanoTime() - start);
                    return prepareResponse2;
                }
            }
        }
        catch (Throwable throwable) {
            Keyspace.open((String)toPrepare.update.metadata().ksName).getColumnFamilyStore((UUID)toPrepare.update.metadata().cfId).metric.casPrepare.addNano(System.nanoTime() - start);
            throw throwable;
        }
        {
            Tracing.trace("Promise rejected; {} is not sufficiently newer than {}", toPrepare, state.promised);
            prepareResponse = new PrepareResponse(false, state.promised, state.mostRecentCommit);
        }
        Keyspace.open((String)toPrepare.update.metadata().ksName).getColumnFamilyStore((UUID)toPrepare.update.metadata().cfId).metric.casPrepare.addNano(System.nanoTime() - start);
        return prepareResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Boolean propose(Commit proposal) {
        Boolean bl;
        PaxosState state;
        long start = System.nanoTime();
        try {
            Object object = PaxosState.lockFor(proposal.key);
            synchronized (object) {
                state = SystemKeyspace.loadPaxosState(proposal.key, proposal.update.metadata());
                if (proposal.hasBallot(state.promised.ballot) || proposal.isAfter(state.promised)) {
                    Tracing.trace("Accepting proposal {}", proposal);
                    SystemKeyspace.savePaxosProposal(proposal);
                    Boolean bl2 = true;
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 6] lbl10 : MonitorExitStatement: MONITOREXIT : var3_2
                    Keyspace.open((String)proposal.update.metadata().ksName).getColumnFamilyStore((UUID)proposal.update.metadata().cfId).metric.casPropose.addNano(System.nanoTime() - start);
                    return bl2;
                }
            }
        }
        catch (Throwable throwable) {
            Keyspace.open((String)proposal.update.metadata().ksName).getColumnFamilyStore((UUID)proposal.update.metadata().cfId).metric.casPropose.addNano(System.nanoTime() - start);
            throw throwable;
        }
        {
            Tracing.trace("Rejecting proposal for {} because inProgress is now {}", proposal, state.promised);
            bl = false;
        }
        Keyspace.open((String)proposal.update.metadata().ksName).getColumnFamilyStore((UUID)proposal.update.metadata().cfId).metric.casPropose.addNano(System.nanoTime() - start);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void commit(Commit proposal) {
        long start = System.nanoTime();
        try {
            if (UUIDGen.unixTimestamp(proposal.ballot) >= SystemKeyspace.getTruncatedAt(proposal.update.metadata().cfId)) {
                Tracing.trace("Committing proposal {}", proposal);
                RowMutation rm = proposal.makeMutation();
                Keyspace.open(rm.getKeyspaceName()).apply(rm, true);
            } else {
                Tracing.trace("Not committing proposal {} as ballot timestamp predates last truncation time", proposal);
            }
            SystemKeyspace.savePaxosCommit(proposal);
        }
        finally {
            Keyspace.open((String)proposal.update.metadata().ksName).getColumnFamilyStore((UUID)proposal.update.metadata().cfId).metric.casCommit.addNano(System.nanoTime() - start);
        }
    }

    static {
        for (int i = 0; i < locks.length; ++i) {
            PaxosState.locks[i] = new Object();
        }
    }
}

