/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.ConfigurationLoader;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.SeedProviderDef;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.introspector.MissingProperty;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.introspector.PropertyUtils;

public class YamlConfigurationLoader
implements ConfigurationLoader {
    private static final Logger logger = LoggerFactory.getLogger(YamlConfigurationLoader.class);
    private static final String DEFAULT_CONFIGURATION = "cassandra.yaml";

    private URL getStorageConfigURL() throws ConfigurationException {
        URL url;
        block3: {
            String configUrl = System.getProperty("cassandra.config");
            if (configUrl == null) {
                configUrl = DEFAULT_CONFIGURATION;
            }
            try {
                url = new URL(configUrl);
                url.openStream().close();
            }
            catch (Exception e) {
                ClassLoader loader = DatabaseDescriptor.class.getClassLoader();
                url = loader.getResource(configUrl);
                if (url != null) break block3;
                throw new ConfigurationException("Cannot locate " + configUrl + ". If you are executing this from an " + "external tool, it needs to set Config.setClientMode(true) to avoid loading configuration.\"");
            }
        }
        return url;
    }

    @Override
    public Config loadConfig() throws ConfigurationException {
        return this.loadConfig(this.getStorageConfigURL());
    }

    public Config loadConfig(URL url) throws ConfigurationException {
        Config config;
        InputStream input = null;
        try {
            logger.info("Loading settings from {}", (Object)url);
            try {
                input = url.openStream();
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            Constructor constructor = new Constructor(Config.class);
            TypeDescription seedDesc = new TypeDescription(SeedProviderDef.class);
            seedDesc.putMapPropertyType("parameters", String.class, String.class);
            constructor.addTypeDescription(seedDesc);
            MissingPropertiesChecker propertiesChecker = new MissingPropertiesChecker();
            constructor.setPropertyUtils((PropertyUtils)propertiesChecker);
            Yaml yaml = new Yaml((BaseConstructor)constructor);
            Config result = (Config)yaml.loadAs(input, Config.class);
            result.configHintedHandoff();
            propertiesChecker.check();
            config = result;
        }
        catch (YAMLException e) {
            try {
                throw new ConfigurationException("Invalid yaml", e);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(input);
                throw throwable;
            }
        }
        FileUtils.closeQuietly(input);
        return config;
    }

    private static class MissingPropertiesChecker
    extends PropertyUtils {
        private final Set<String> missingProperties = new HashSet<String>();

        public MissingPropertiesChecker() {
            this.setSkipMissingProperties(true);
        }

        public Property getProperty(Class<? extends Object> type, String name) throws IntrospectionException {
            Property result = super.getProperty(type, name);
            if (result instanceof MissingProperty) {
                this.missingProperties.add(result.getName());
            }
            return result;
        }

        public void check() throws ConfigurationException {
            if (!this.missingProperties.isEmpty()) {
                throw new ConfigurationException("Invalid yaml. Please remove properties " + this.missingProperties + " from your cassandra.yaml");
            }
        }
    }
}

