/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.AbstractIterator;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ColumnToCollectionType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.utils.ByteBufferUtil;

public class CFDefinition
implements Iterable<Name> {
    public static final AbstractType<?> definitionType = UTF8Type.instance;
    private static final Comparator<ColumnIdentifier> identifierComparator = new Comparator<ColumnIdentifier>(){

        @Override
        public int compare(ColumnIdentifier id1, ColumnIdentifier id2) {
            return ByteBufferUtil.compareUnsigned(id1.key, id2.key);
        }
    };
    public final CFMetaData cfm;
    private final LinkedHashMap<ColumnIdentifier, Name> partitionKeys = new LinkedHashMap();
    private final LinkedHashMap<ColumnIdentifier, Name> clusteringColumns = new LinkedHashMap();
    private final Name compactValue;
    private final Map<ColumnIdentifier, Name> staticColumns = new TreeMap<ColumnIdentifier, Name>(identifierComparator);
    private final Map<ColumnIdentifier, Name> regularColumns = new TreeMap<ColumnIdentifier, Name>(identifierComparator);
    public final boolean isComposite;
    public final boolean hasCompositeKey;
    public final boolean isCompact;
    public final boolean hasCollections;

    public CFDefinition(CFMetaData cfm) {
        ColumnIdentifier id;
        int i;
        this.cfm = cfm;
        this.hasCompositeKey = cfm.getKeyValidator() instanceof CompositeType;
        for (i = 0; i < cfm.partitionKeyColumns().size(); ++i) {
            id = new ColumnIdentifier(cfm.partitionKeyColumns().get((int)i).name, definitionType);
            this.partitionKeys.put(id, new Name(cfm.ksName, cfm.cfName, id, Name.Kind.KEY_ALIAS, i, cfm.getKeyValidator().getComponents().get(i)));
        }
        this.isComposite = cfm.comparator instanceof CompositeType;
        this.hasCollections = cfm.comparator.getComponents().get(cfm.comparator.componentsCount() - 1) instanceof ColumnToCollectionType;
        this.isCompact = cfm.clusteringKeyColumns().size() == cfm.comparator.componentsCount();
        for (i = 0; i < cfm.clusteringKeyColumns().size(); ++i) {
            id = new ColumnIdentifier(cfm.clusteringKeyColumns().get((int)i).name, definitionType);
            this.clusteringColumns.put(id, new Name(cfm.ksName, cfm.cfName, id, Name.Kind.COLUMN_ALIAS, i, cfm.comparator.getComponents().get(i)));
        }
        if (this.isCompact) {
            this.compactValue = CFDefinition.createValue(cfm);
        } else {
            ColumnIdentifier id2;
            this.compactValue = null;
            for (ColumnDefinition def : cfm.regularColumns()) {
                id2 = new ColumnIdentifier(def.name, cfm.getColumnDefinitionComparator(def));
                this.regularColumns.put(id2, new Name(cfm.ksName, cfm.cfName, id2, Name.Kind.COLUMN_METADATA, def.getValidator()));
            }
            for (ColumnDefinition def : cfm.staticColumns()) {
                id2 = new ColumnIdentifier(def.name, cfm.getColumnDefinitionComparator(def));
                this.staticColumns.put(id2, new Name(cfm.ksName, cfm.cfName, id2, Name.Kind.STATIC, def.getValidator()));
            }
        }
    }

    public ColumnToCollectionType getCollectionType() {
        if (!this.hasCollections) {
            return null;
        }
        CompositeType composite = (CompositeType)this.cfm.comparator;
        return (ColumnToCollectionType)composite.types.get(composite.types.size() - 1);
    }

    private static Name createValue(CFMetaData cfm) {
        ColumnIdentifier alias = new ColumnIdentifier(cfm.compactValueColumn().name, definitionType);
        return alias.key.equals(ByteBufferUtil.EMPTY_BYTE_BUFFER) ? null : new Name(cfm.ksName, cfm.cfName, alias, Name.Kind.VALUE_ALIAS, cfm.getDefaultValidator());
    }

    public int partitionKeyCount() {
        return this.partitionKeys.size();
    }

    public Collection<Name> partitionKeys() {
        return this.partitionKeys.values();
    }

    public int clusteringColumnsCount() {
        return this.clusteringColumns.size();
    }

    public Collection<Name> clusteringColumns() {
        return this.clusteringColumns.values();
    }

    public Collection<Name> regularColumns() {
        return this.regularColumns.values();
    }

    public Collection<Name> staticColumns() {
        return this.staticColumns.values();
    }

    public Name compactValue() {
        return this.compactValue;
    }

    public Name get(ColumnIdentifier name) {
        Name def = this.partitionKeys.get(name);
        if (def != null) {
            return def;
        }
        if (this.compactValue != null && name.equals(this.compactValue.name)) {
            return this.compactValue;
        }
        def = this.clusteringColumns.get(name);
        if (def != null) {
            return def;
        }
        def = this.regularColumns.get(name);
        if (def != null) {
            return def;
        }
        return this.staticColumns.get(name);
    }

    @Override
    public Iterator<Name> iterator() {
        return new AbstractIterator<Name>(){
            private final Iterator<Name> keyIter;
            private final Iterator<Name> clusteringIter;
            private boolean valueDone;
            private final Iterator<Name> staticIter;
            private final Iterator<Name> regularIter;
            {
                this.keyIter = CFDefinition.this.partitionKeys.values().iterator();
                this.clusteringIter = CFDefinition.this.clusteringColumns.values().iterator();
                this.staticIter = CFDefinition.this.staticColumns.values().iterator();
                this.regularIter = CFDefinition.this.regularColumns.values().iterator();
            }

            protected Name computeNext() {
                if (this.keyIter.hasNext()) {
                    return this.keyIter.next();
                }
                if (this.clusteringIter.hasNext()) {
                    return this.clusteringIter.next();
                }
                if (CFDefinition.this.compactValue != null && !this.valueDone) {
                    this.valueDone = true;
                    return CFDefinition.this.compactValue;
                }
                if (this.staticIter.hasNext()) {
                    return this.staticIter.next();
                }
                if (this.regularIter.hasNext()) {
                    return this.regularIter.next();
                }
                return (Name)this.endOfData();
            }
        };
    }

    public ColumnNameBuilder getKeyNameBuilder() {
        return this.hasCompositeKey ? new CompositeType.Builder((CompositeType)this.cfm.getKeyValidator()) : new NonCompositeBuilder(this.cfm.getKeyValidator());
    }

    public ColumnNameBuilder getColumnNameBuilder() {
        return this.isComposite ? new CompositeType.Builder((CompositeType)this.cfm.comparator) : new NonCompositeBuilder(this.cfm.comparator);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Joiner.on((String)", ").join(this.partitionKeys.values()));
        if (!this.clusteringColumns.isEmpty()) {
            sb.append(", ").append(Joiner.on((String)", ").join(this.clusteringColumns.values()));
        }
        sb.append(" => ");
        if (this.compactValue != null) {
            sb.append(this.compactValue.name);
        }
        sb.append("{");
        sb.append(Joiner.on((String)", ").join(this.staticColumns.values()));
        if (!this.staticColumns.isEmpty()) {
            sb.append(", ");
        }
        sb.append(Joiner.on((String)", ").join(this.regularColumns.values()));
        sb.append("}");
        return sb.toString();
    }

    private static class NonCompositeBuilder
    implements ColumnNameBuilder {
        private final AbstractType<?> type;
        private ByteBuffer columnName;

        private NonCompositeBuilder(AbstractType<?> type) {
            this.type = type;
        }

        @Override
        public NonCompositeBuilder add(ByteBuffer bb) {
            if (this.columnName != null) {
                throw new IllegalStateException("Column name is already constructed");
            }
            this.columnName = bb;
            return this;
        }

        @Override
        public int componentCount() {
            return this.columnName == null ? 0 : 1;
        }

        @Override
        public int remainingCount() {
            return this.columnName == null ? 1 : 0;
        }

        @Override
        public ByteBuffer get(int i) {
            if (i < 0 || i >= (this.columnName == null ? 0 : 1)) {
                throw new IllegalArgumentException();
            }
            return this.columnName;
        }

        @Override
        public ByteBuffer build() {
            return this.columnName == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : this.columnName;
        }

        @Override
        public ByteBuffer buildAsEndOfRange() {
            return this.build();
        }

        @Override
        public ByteBuffer buildForRelation(Relation.Type op) {
            return this.build();
        }

        @Override
        public NonCompositeBuilder copy() {
            NonCompositeBuilder newBuilder = new NonCompositeBuilder(this.type);
            newBuilder.columnName = this.columnName;
            return newBuilder;
        }

        @Override
        public ByteBuffer getComponent(int i) {
            if (i != 0 || this.columnName == null) {
                throw new IllegalArgumentException();
            }
            return this.columnName;
        }
    }

    public static class Name
    extends ColumnSpecification {
        public final Kind kind;
        public final int position;

        private Name(String ksName, String cfName, ColumnIdentifier name, Kind kind, AbstractType<?> type) {
            this(ksName, cfName, name, kind, -1, type);
        }

        private Name(String ksName, String cfName, ColumnIdentifier name, Kind kind, int position, AbstractType<?> type) {
            super(ksName, cfName, name, type);
            this.kind = kind;
            this.position = position;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Name)) {
                return false;
            }
            Name that = (Name)o;
            return Objects.equal((Object)this.ksName, (Object)that.ksName) && Objects.equal((Object)this.cfName, (Object)that.cfName) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.type, (Object)that.type) && this.kind == that.kind && this.position == that.position;
        }

        public final int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.ksName, this.cfName, this.name, this.type, this.kind, this.position});
        }

        public boolean isPrimaryKeyColumn() {
            return this.kind == Kind.KEY_ALIAS || this.kind == Kind.COLUMN_ALIAS;
        }

        public static enum Kind {
            KEY_ALIAS,
            COLUMN_ALIAS,
            VALUE_ALIAS,
            COLUMN_METADATA,
            STATIC;

        }
    }
}

